/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.LogHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ProviderHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.RequestHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ResolverHandler;
import com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped.WrappedStaticStateRequestManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardRequestManager
implements IStandardRequestManager {
    private static final String NBT_REQUEST_IDENTITY_MAP = "Request_Identities";
    private static final String NBT_RESOLVER_REQUESTS_ASSIGNMENTS = "Resolver_Requests";
    private static final String NBT_PLAYER = "Player";
    private static final String NBT_RETRYING = "Retrying";
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_ASSIGNMENTS = "Assignments";
    private static final String NBT_REQUEST = "Request";
    @NotNull
    private final BiMap<IToken<?>, IRequestResolverProvider> providerBiMap = HashBiMap.create();
    @NotNull
    private final BiMap<IToken<?>, IRequestResolver<? extends IRequestable>> resolverBiMap = HashBiMap.create();
    @NotNull
    private final BiMap<IToken<?>, IRequest<?>> requestBiMap = HashBiMap.create();
    @NotNull
    private final Map<IToken<?>, ImmutableCollection<IToken<?>>> providerResolverMap = new HashMap();
    @NotNull
    private final Map<IToken<?>, Set<IToken<?>>> resolverRequestMap = new HashMap();
    @NotNull
    private final Map<IToken<?>, IToken<?>> requestResolverMap = new HashMap();
    @NotNull
    private final Map<TypeToken<?>, Collection<IRequestResolver<?>>> requestClassResolverMap = new HashMap();
    @NotNull
    private final IColony colony;
    @NotNull
    private IPlayerRequestResolver playerResolver = null;
    @NotNull
    private IRetryingRequestResolver retryingResolver = null;

    public StandardRequestManager(IColony colony) {
        this.colony = colony;
        this.playerResolver = this.getFactoryController().getNewInstance(TypeConstants.PLAYER_REQUEST_RESOLVER, this, new Object[0]);
        this.retryingResolver = this.getFactoryController().getNewInstance(TypeConstants.RETRYING_REQUEST_RESOLVER, this, new Object[0]);
        ResolverHandler.registerResolver(this, this.playerResolver);
        ResolverHandler.registerResolver(this, this.retryingResolver);
    }

    StandardRequestManager() {
        this.colony = null;
        this.playerResolver = null;
        this.retryingResolver = null;
    }

    @Override
    @NotNull
    public IColony getColony() {
        return this.colony;
    }

    @Override
    @NotNull
    public IFactoryController getFactoryController() {
        return StandardFactoryController.getInstance();
    }

    @Override
    @NotNull
    public <T extends IRequestable> IToken<?> createRequest(@NotNull IRequester requester, @NotNull T object) {
        IRequest<T> request = RequestHandler.createRequest(this, requester, object);
        if (this.colony != null) {
            this.colony.markDirty();
        }
        return request.getToken();
    }

    @Override
    public void assignRequest(@NotNull IToken<?> token) {
        RequestHandler.assignRequest(this, RequestHandler.getRequest(this, token));
        if (this.colony != null) {
            this.colony.markDirty();
        }
    }

    @Override
    @NotNull
    public <T extends IRequestable> IToken<?> createAndAssignRequest(@NotNull IRequester requester, @NotNull T object) {
        IToken<?> token = this.createRequest(requester, object);
        this.assignRequest(token);
        return token;
    }

    @Override
    @Nullable
    public IToken<?> reassignRequest(@NotNull IToken<?> token, @NotNull Collection<IToken<?>> resolverTokenBlackList) {
        IRequest request = RequestHandler.getRequest(this, token);
        return RequestHandler.reassignRequest(this, request, resolverTokenBlackList);
    }

    @Override
    @Nullable
    public IRequest getRequestForToken(@NotNull IToken<?> token) {
        IRequest internalRequest = RequestHandler.getRequestOrNull(this, token);
        if (internalRequest == null) {
            return null;
        }
        NBTTagCompound requestData = this.getFactoryController().serialize(internalRequest);
        return (IRequest)this.getFactoryController().deserialize(requestData);
    }

    @Override
    @NotNull
    public IRequestResolver getResolverForToken(@NotNull IToken<?> token) {
        IRequestResolver<? extends IRequestable> resolver = ResolverHandler.getResolver(this, token);
        return (IRequestResolver)this.getFactoryController().deserialize(this.getFactoryController().serialize(resolver));
    }

    @Override
    @Nullable
    public IRequestResolver getResolverForRequest(@NotNull IToken<?> requestToken) {
        IRequest request = RequestHandler.getRequest(this, requestToken);
        return this.getResolverForToken(ResolverHandler.getResolverForRequest((IStandardRequestManager)this, request).getRequesterId());
    }

    @Override
    public void updateRequestState(@NotNull IToken<?> token, @NotNull RequestState state) {
        IRequest request = RequestHandler.getRequest(this, token);
        LogHandler.log("Updating request state from:" + token + ". With original state: " + (Object)((Object)request.getState()) + " to : " + (Object)((Object)state));
        request.setState(new WrappedStaticStateRequestManager(this), state);
        if (this.colony != null) {
            this.colony.markDirty();
        }
        switch (request.getState()) {
            case COMPLETED: {
                LogHandler.log("Request completed: " + token + ". Notifying parent and requester...");
                RequestHandler.onRequestSuccessful(this, token);
                return;
            }
            case OVERRULED: {
                LogHandler.log("Request overruled: " + token + ". Notifying parent, children and requester...");
                RequestHandler.onRequestOverruled(this, token);
                break;
            }
            case CANCELLED: {
                LogHandler.log("Request cancelled: " + token + ". Notifying parent, children and requester...");
                RequestHandler.onRequestCancelled(this, token);
                return;
            }
            case RECEIVED: {
                LogHandler.log("Request received: " + token + ". Removing from system...");
                RequestHandler.cleanRequestData(this, token);
                return;
            }
        }
    }

    @Override
    public void overruleRequest(@NotNull IToken<?> token, @Nullable ItemStack stack) {
        IRequest request = RequestHandler.getRequest(this, token);
        if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
            request.setDelivery(stack);
        }
        this.updateRequestState(token, RequestState.OVERRULED);
    }

    @Override
    public void onProviderAddedToColony(@NotNull IRequestResolverProvider provider) {
        ProviderHandler.registerProvider(this, provider);
    }

    @Override
    public void onProviderRemovedFromColony(@NotNull IRequestResolverProvider provider) throws IllegalArgumentException {
        ProviderHandler.removeProvider((IStandardRequestManager)this, provider);
    }

    @Override
    @NotNull
    public IPlayerRequestResolver getPlayerResolver() {
        return this.playerResolver;
    }

    @Override
    @NotNull
    public IRetryingRequestResolver getRetryingRequestResolver() {
        return this.retryingResolver;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound systemCompound = new NBTTagCompound();
        if (this.playerResolver != null) {
            systemCompound.func_74782_a(NBT_PLAYER, (NBTBase)this.getFactoryController().serialize(this.playerResolver));
        }
        if (this.retryingResolver != null) {
            systemCompound.func_74782_a(NBT_RETRYING, (NBTBase)this.getFactoryController().serialize(this.retryingResolver));
        }
        NBTTagList requestIdentityList = new NBTTagList();
        this.requestBiMap.keySet().forEach(token -> {
            NBTTagCompound requestCompound = new NBTTagCompound();
            requestCompound.func_74782_a(NBT_TOKEN, (NBTBase)this.getFactoryController().serialize(token));
            requestCompound.func_74782_a(NBT_REQUEST, (NBTBase)this.getFactoryController().serialize(this.requestBiMap.get(token)));
            requestIdentityList.func_74742_a((NBTBase)requestCompound);
        });
        systemCompound.func_74782_a(NBT_REQUEST_IDENTITY_MAP, (NBTBase)requestIdentityList);
        NBTTagList resolverRequestAssignmentList = new NBTTagList();
        this.resolverRequestMap.keySet().forEach(token -> {
            NBTTagCompound assignmentCompound = new NBTTagCompound();
            assignmentCompound.func_74782_a(NBT_TOKEN, (NBTBase)this.getFactoryController().serialize(token));
            NBTTagList assignedList = new NBTTagList();
            this.resolverRequestMap.get(token).forEach(assignedToken -> assignedList.func_74742_a((NBTBase)this.getFactoryController().serialize(assignedToken)));
            assignmentCompound.func_74782_a(NBT_ASSIGNMENTS, (NBTBase)assignedList);
            resolverRequestAssignmentList.func_74742_a((NBTBase)assignmentCompound);
        });
        systemCompound.func_74782_a(NBT_RESOLVER_REQUESTS_ASSIGNMENTS, (NBTBase)resolverRequestAssignmentList);
        return systemCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (this.playerResolver != null) {
            ResolverHandler.removeResolverInternal(this, this.playerResolver);
        }
        if (this.retryingResolver != null) {
            ResolverHandler.removeResolverInternal(this, this.retryingResolver);
        }
        this.playerResolver = nbt.func_74764_b(NBT_PLAYER) ? (IPlayerRequestResolver)this.getFactoryController().deserialize(nbt.func_74775_l(NBT_PLAYER)) : null;
        if (nbt.func_74764_b(NBT_RETRYING)) {
            this.retryingResolver = (IRetryingRequestResolver)this.getFactoryController().deserialize(nbt.func_74775_l(NBT_RETRYING));
            this.retryingResolver.updateManager(this);
        } else {
            this.retryingResolver = null;
        }
        if (this.playerResolver != null) {
            ResolverHandler.registerResolver(this, this.playerResolver);
        }
        if (this.retryingResolver != null) {
            ResolverHandler.registerResolver(this, this.retryingResolver);
        }
        NBTTagList requestIdentityList = nbt.func_150295_c(NBT_REQUEST_IDENTITY_MAP, 10);
        this.requestBiMap.clear();
        NBTUtils.streamCompound(requestIdentityList).forEach(identityCompound -> {
            IToken token = (IToken)this.getFactoryController().deserialize(identityCompound.func_74775_l(NBT_TOKEN));
            IRequest request = (IRequest)this.getFactoryController().deserialize(identityCompound.func_74775_l(NBT_REQUEST));
            this.requestBiMap.put((Object)token, (Object)request);
        });
        NBTTagList resolverRequestAssignmentList = nbt.func_150295_c(NBT_RESOLVER_REQUESTS_ASSIGNMENTS, 10);
        this.resolverRequestMap.clear();
        this.requestResolverMap.clear();
        NBTUtils.streamCompound(resolverRequestAssignmentList).forEach(assignmentCompound -> {
            IToken token = (IToken)this.getFactoryController().deserialize(assignmentCompound.func_74775_l(NBT_TOKEN));
            if (!this.resolverBiMap.containsKey((Object)token)) {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                    Log.getLogger().error("Unknown resolver found in NBT Data. Something might be going wrong and requests might linger around!");
                }
                return;
            }
            NBTTagList assignmentsLists = assignmentCompound.func_150295_c(NBT_ASSIGNMENTS, 10);
            Set assignedRequests = NBTUtils.streamCompound(assignmentsLists).map(tokenCompound -> {
                IToken assignedToken = (IToken)this.getFactoryController().deserialize((NBTTagCompound)tokenCompound);
                this.requestResolverMap.put(assignedToken, token);
                return assignedToken;
            }).collect(Collectors.toSet());
            this.resolverRequestMap.put(token, assignedRequests);
        });
    }

    public void func_73660_a() {
        this.retryingResolver.func_73660_a();
    }

    @Override
    @NotNull
    public BiMap<IToken<?>, IRequestResolverProvider> getProviderBiMap() {
        return this.providerBiMap;
    }

    @Override
    @NotNull
    public BiMap<IToken<?>, IRequestResolver<? extends IRequestable>> getResolverBiMap() {
        return this.resolverBiMap;
    }

    @Override
    @NotNull
    public BiMap<IToken<?>, IRequest<?>> getRequestBiMap() {
        return this.requestBiMap;
    }

    @Override
    @NotNull
    public Map<IToken<?>, ImmutableCollection<IToken<?>>> getProviderResolverMap() {
        return this.providerResolverMap;
    }

    @Override
    @NotNull
    public Map<IToken<?>, Set<IToken<?>>> getResolverRequestMap() {
        return this.resolverRequestMap;
    }

    @Override
    @NotNull
    public Map<IToken<?>, IToken<?>> getRequestResolverMap() {
        return this.requestResolverMap;
    }

    @Override
    @NotNull
    public Map<TypeToken<?>, Collection<IRequestResolver<?>>> getRequestClassResolverMap() {
        return this.requestClassResolverMap;
    }

    @Override
    public boolean isDataSimulation() {
        return false;
    }

    @Override
    public boolean isResolvingSimulation() {
        return false;
    }
}

