/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.handlers;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.LogHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.RequestHandler;
import com.minecolonies.coremod.colony.requestsystem.management.manager.wrapped.WrappedStaticStateRequestManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class ResolverHandler {
    public static Collection<IToken<?>> registerResolvers(IStandardRequestManager manager, IRequestResolver<?> ... resolvers) {
        return Arrays.stream(resolvers).map(resolver -> ResolverHandler.registerResolver(manager, resolver)).collect(Collectors.toList());
    }

    public static IToken<?> registerResolver(IStandardRequestManager manager, IRequestResolver<? extends IRequestable> resolver) {
        if (manager.getResolverBiMap().containsKey(resolver.getRequesterId())) {
            throw new IllegalArgumentException("The token attached to this resolver is already registered. Cannot register twice!");
        }
        if (manager.getResolverBiMap().containsValue(resolver)) {
            throw new IllegalArgumentException("The given resolver is already registered with a different token. Cannot register twice!");
        }
        manager.getResolverBiMap().put(resolver.getRequesterId(), resolver);
        Set<TypeToken> resolverTypes = ReflectionUtils.getSuperClasses(resolver.getRequestType());
        resolverTypes.remove(TypeConstants.OBJECT);
        resolverTypes.forEach(c -> {
            if (!manager.getRequestClassResolverMap().containsKey(c)) {
                manager.getRequestClassResolverMap().put((TypeToken<?>)c, new ArrayList());
            }
            LogHandler.log("Registering resolver: " + resolver + " with request type: " + c);
            manager.getRequestClassResolverMap().get(c).add(resolver);
        });
        return resolver.getRequesterId();
    }

    public static Collection<IToken<?>> registerResolvers(IStandardRequestManager manager, Collection<IRequestResolver<?>> resolvers) {
        return resolvers.stream().map(resolver -> ResolverHandler.registerResolver(manager, resolver)).collect(Collectors.toList());
    }

    public static void removeResolver(IStandardRequestManager manager, IToken<?> token) {
        if (!manager.getResolverBiMap().containsKey(token)) {
            throw new IllegalArgumentException("The token is unknown to this manager.");
        }
        ResolverHandler.removeResolver(manager, ResolverHandler.getResolver(manager, token));
    }

    public static void removeResolver(IStandardRequestManager manager, IRequestResolver<?> resolver) {
        IRequestResolver<? extends IRequestable> registeredResolver = ResolverHandler.getResolver(manager, resolver.getRequesterId());
        if (!registeredResolver.equals(resolver)) {
            throw new IllegalArgumentException("The given resolver and the resolver that is registered with its token are not the same.");
        }
        if (manager.getResolverRequestMap().containsKey(registeredResolver.getRequesterId()) && manager.getResolverRequestMap().get(registeredResolver.getRequesterId()).size() > 0) {
            throw new IllegalArgumentException("Cannot remove a resolver that is still in use. Reassign all registered requests before removing");
        }
        ResolverHandler.removeResolverInternal(manager, resolver);
    }

    public static IRequestResolver<? extends IRequestable> getResolver(IStandardRequestManager manager, IToken<?> token) {
        if (!manager.getResolverBiMap().containsKey(token)) {
            throw new IllegalArgumentException("The given token for a resolver is not known to this manager!");
        }
        LogHandler.log("Retrieving resolver for: " + token);
        return (IRequestResolver)manager.getResolverBiMap().get(token);
    }

    public static void removeResolverInternal(IStandardRequestManager manager, IRequestResolver<?> resolver) {
        manager.getResolverBiMap().remove(resolver.getRequesterId());
        Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(resolver.getRequestType());
        requestTypes.remove(TypeConstants.OBJECT);
        requestTypes.forEach(c -> {
            LogHandler.log("Removing resolver: " + resolver + " with request type: " + c);
            manager.getRequestClassResolverMap().get(c).remove(resolver);
        });
    }

    public static void removeResolvers(IStandardRequestManager manager, IRequestResolver<?> ... resolvers) {
        ResolverHandler.removeResolvers(manager, Arrays.asList(resolvers));
    }

    public static void removeResolvers(IStandardRequestManager manager, Iterable<IRequestResolver<?>> resolvers) {
        resolvers.forEach(resolver -> ResolverHandler.removeResolver(manager, resolver));
    }

    public static void addRequestToResolver(IStandardRequestManager manager, IRequestResolver<?> resolver, IRequest<?> request) {
        if (!manager.getResolverRequestMap().containsKey(resolver.getRequesterId())) {
            manager.getResolverRequestMap().put(resolver.getRequesterId(), new HashSet());
        }
        LogHandler.log("Adding request: " + request + " to resolver: " + resolver);
        manager.getResolverRequestMap().get(resolver.getRequesterId()).add((IToken<?>)request.getToken());
        manager.getRequestResolverMap().put((IToken<?>)request.getToken(), resolver.getRequesterId());
        request.setState(new WrappedStaticStateRequestManager(manager), RequestState.ASSIGNED);
    }

    public static void removeRequestFromResolver(IStandardRequestManager manager, IRequestResolver<?> resolver, IRequest<?> request) {
        if (!manager.getResolverRequestMap().containsKey(resolver.getRequesterId())) {
            throw new IllegalArgumentException("The given resolver is unknown to this Manager");
        }
        if (!manager.getResolverRequestMap().get(resolver.getRequesterId()).contains(request.getToken())) {
            throw new IllegalArgumentException("The given request is not registered to the given resolver.");
        }
        LogHandler.log("Removing request: " + request + " from resolver: " + resolver);
        manager.getResolverRequestMap().get(resolver.getRequesterId()).remove(request.getToken());
        manager.getRequestResolverMap().remove(request.getToken());
    }

    public static IRequestResolver<? extends IRequestable> getResolverForRequest(IStandardRequestManager manager, IToken<?> requestToken) {
        RequestHandler.getRequest(manager, requestToken);
        if (!manager.getRequestResolverMap().containsKey(requestToken)) {
            throw new IllegalArgumentException("The given token belongs to a not resolved request");
        }
        return ResolverHandler.getResolver(manager, manager.getRequestResolverMap().get(requestToken));
    }

    public static IRequestResolver<? extends IRequestable> getResolverForRequest(IStandardRequestManager manager, IRequest<?> request) {
        RequestHandler.getRequest(manager, request.getToken());
        if (!manager.getRequestResolverMap().containsKey(request.getToken())) {
            throw new IllegalArgumentException("The given token belongs to a not resolved request");
        }
        return ResolverHandler.getResolver(manager, manager.getRequestResolverMap().get(request.getToken()));
    }
}

