/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.management.handlers;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.LogHandler;
import com.minecolonies.coremod.colony.requestsystem.management.handlers.ResolverHandler;
import java.util.ArrayList;
import java.util.Collection;

public final class ProviderHandler {
    public static ImmutableCollection<IToken<?>> getRegisteredResolvers(IStandardRequestManager manager, IRequestResolverProvider provider) {
        ProviderHandler.getProvider(manager, provider.getToken());
        return manager.getProviderResolverMap().get(provider.getToken());
    }

    public static IRequestResolverProvider getProvider(IStandardRequestManager manager, IToken<?> token) {
        if (!manager.getProviderBiMap().containsKey(token)) {
            throw new IllegalArgumentException("The given token for a provider is not registered");
        }
        return (IRequestResolverProvider)manager.getProviderBiMap().get(token);
    }

    public static void registerProvider(IStandardRequestManager manager, IRequestResolverProvider provider) {
        if (manager.getProviderBiMap().containsKey(provider.getToken()) || manager.getProviderBiMap().containsValue((Object)provider)) {
            throw new IllegalArgumentException("The given provider is already registered");
        }
        manager.getProviderBiMap().put(provider.getToken(), (Object)provider);
        ImmutableList.Builder resolverListBuilder = new ImmutableList.Builder();
        resolverListBuilder.addAll(ResolverHandler.registerResolvers(manager, provider.getResolvers()));
        manager.getProviderResolverMap().put(provider.getToken(), (ImmutableCollection<IToken<?>>)resolverListBuilder.build());
        manager.getColony().markDirty();
    }

    public static void removeProvider(IStandardRequestManager manager, IToken<?> token) {
        ProviderHandler.removeProviderInternal(manager, token);
    }

    public static void removeProviderInternal(IStandardRequestManager manager, IToken<?> token) {
        IRequestResolverProvider provider = ProviderHandler.getProvider(manager, token);
        LogHandler.log("Removing provider: " + provider);
        ImmutableCollection<IToken<?>> assignedResolvers = ProviderHandler.getRegisteredResolvers(manager, token);
        for (IToken resolverToken : assignedResolvers) {
            if (!manager.getResolverRequestMap().containsKey(resolverToken) || manager.getResolverRequestMap().get(resolverToken).isEmpty()) {
                LogHandler.log("Removing resolver without assigned requests: " + resolverToken);
                manager.getResolverRequestMap().remove(resolverToken);
                ResolverHandler.removeResolver(manager, resolverToken);
                continue;
            }
            ArrayList assignedRequests = new ArrayList(manager.getResolverRequestMap().get(resolverToken));
            LogHandler.log("Starting reassignment of already registered requests registered to resolver with token: " + resolverToken);
            for (IToken requestToken : assignedRequests) {
                manager.reassignRequest(requestToken, (Collection<IToken<?>>)assignedResolvers);
            }
            ResolverHandler.removeResolver(manager, resolverToken);
            LogHandler.log("Finished reassignment of already registered requests registered to resolver with token: " + resolverToken);
        }
        manager.getProviderBiMap().remove(provider.getToken());
        manager.getProviderResolverMap().remove(provider.getToken());
        manager.getColony().markDirty();
        LogHandler.log("Removed provider: " + provider);
    }

    public static ImmutableCollection<IToken<?>> getRegisteredResolvers(IStandardRequestManager manager, IToken<?> token) {
        ProviderHandler.getProvider(manager, token);
        return manager.getProviderResolverMap().get(token);
    }

    public static void removeProvider(IStandardRequestManager manager, IRequestResolverProvider provider) {
        IRequestResolverProvider registeredProvider = ProviderHandler.getProvider(manager, provider.getToken());
        if (!registeredProvider.equals(provider)) {
            throw new IllegalArgumentException("The given providers token is registered to a different provider!");
        }
        ProviderHandler.removeProviderInternal(manager, provider.getToken());
    }
}

