/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.WorkManager;
import com.minecolonies.coremod.colony.managers.IColonyPackageManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.network.messages.ColonyStylesMessage;
import com.minecolonies.coremod.network.messages.ColonyViewMessage;
import com.minecolonies.coremod.network.messages.ColonyViewWorkOrderMessage;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.util.ColonyUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ColonyPackageManager
implements IColonyPackageManager {
    private static final int CHANCE_TO_UPDATE = 1000;
    @NotNull
    private Set<EntityPlayerMP> subscribers = new HashSet<EntityPlayerMP>();
    private boolean isDirty = false;
    private int ticksPassed = 0;
    private int lastContactInHours = 0;
    private final Colony colony;

    public ColonyPackageManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public void setLastContactInHours(int lastContactInHours) {
        this.lastContactInHours = lastContactInHours;
    }

    @Override
    public Set<EntityPlayerMP> getSubscribers() {
        return new HashSet<EntityPlayerMP>(this.subscribers);
    }

    @Override
    public void updateSubscribers() {
        World world = this.colony.getWorld();
        if (world == null || world.func_73046_m() == null) {
            return;
        }
        Set<EntityPlayerMP> oldSubscribers = this.subscribers;
        this.subscribers = new HashSet<EntityPlayerMP>();
        world.func_73046_m().func_184103_al().func_181057_v().stream().filter(this.colony.getPermissions()::isSubscriber).forEach(this.subscribers::add);
        if (this.subscribers.isEmpty()) {
            if (this.ticksPassed >= 72000) {
                this.ticksPassed = 0;
                ++this.lastContactInHours;
                this.colony.markDirty();
            }
            ++this.ticksPassed;
        } else if (this.lastContactInHours != 0) {
            this.lastContactInHours = 0;
            this.ticksPassed = 0;
            this.colony.markDirty();
        }
        for (EntityPlayer o : world.field_73010_i) {
            EntityPlayerMP player;
            double distance;
            if (!(o instanceof EntityPlayerMP) || !((distance = (player = (EntityPlayerMP)o).func_174818_b(this.colony.getCenter())) < ColonyConstants.MAX_SQ_DIST_SUBSCRIBER_UPDATE) && (!oldSubscribers.contains(player) || !(distance < ColonyConstants.MAX_SQ_DIST_OLD_SUBSCRIBER_UPDATE))) continue;
            this.subscribers.add(player);
        }
        if (!this.subscribers.isEmpty()) {
            boolean hasNewSubscribers = ColonyUtils.hasNewSubscribers(oldSubscribers, this.subscribers);
            this.sendColonyViewPackets(oldSubscribers, hasNewSubscribers);
            this.sendPermissionsPackets(oldSubscribers, hasNewSubscribers);
            this.sendWorkOrderPackets(oldSubscribers, hasNewSubscribers);
            this.colony.getCitizenManager().sendPackets(oldSubscribers, hasNewSubscribers, this.subscribers);
            this.colony.getBuildingManager().sendPackets(oldSubscribers, hasNewSubscribers, this.subscribers);
            if (Structures.isDirty()) {
                this.sendSchematicsPackets(hasNewSubscribers);
                Structures.clearDirty();
            }
        }
        this.isDirty = false;
        this.colony.getPermissions().clearDirty();
        this.colony.getBuildingManager().clearDirty();
        this.colony.getCitizenManager().clearDirty();
    }

    @Override
    public void sendColonyViewPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.isDirty || hasNewSubscribers) {
            for (EntityPlayerMP player : this.subscribers) {
                boolean isNewSubscriber;
                boolean bl = isNewSubscriber = !oldSubscribers.contains(player);
                if (!this.isDirty && !isNewSubscriber) continue;
                MineColonies.getNetwork().sendTo((IMessage)new ColonyViewMessage(this.colony, isNewSubscriber), player);
            }
        }
    }

    @Override
    public void sendPermissionsPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        Permissions permissions = this.colony.getPermissions();
        if (permissions.isDirty() || hasNewSubscribers || this.colony.getWorld().field_73012_v.nextInt(1000) <= 1) {
            this.subscribers.stream().filter(player -> permissions.isDirty() || !oldSubscribers.contains(player)).forEach(player -> {
                Rank rank = permissions.getRank((EntityPlayer)player);
                MineColonies.getNetwork().sendTo((IMessage)new PermissionsMessage.View(this.colony, rank), player);
            });
        }
    }

    @Override
    public void sendWorkOrderPackets(@NotNull Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        WorkManager workManager = this.colony.getWorkManager();
        if (workManager.isDirty() || hasNewSubscribers) {
            for (AbstractWorkOrder workOrder : workManager.getWorkOrders().values()) {
                this.subscribers.stream().filter(player -> workManager.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewWorkOrderMessage(this.colony, workOrder), player));
            }
            workManager.setDirty(false);
        }
    }

    @Override
    public void sendSchematicsPackets(boolean hasNewSubscribers) {
        if (Structures.isDirty() || hasNewSubscribers) {
            this.subscribers.stream().forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyStylesMessage(), player));
        }
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }
}

