/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.managers.IBarbarianManager;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BarbarianManager
implements IBarbarianManager {
    private boolean raidTonight = false;
    private boolean raidBeenCalculated = false;
    private boolean haveBarbEvents = true;
    private final Colony colony;

    public BarbarianManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public boolean canHaveBarbEvents() {
        return this.haveBarbEvents;
    }

    @Override
    public boolean hasRaidBeenCalculated() {
        return this.raidBeenCalculated;
    }

    @Override
    public boolean willRaidTonight() {
        return this.raidTonight;
    }

    @Override
    public void setCanHaveBarbEvents(boolean canHave) {
        this.haveBarbEvents = canHave;
        this.colony.markDirty();
    }

    @Override
    public void setHasRaidBeenCalculated(boolean hasSet) {
        this.raidBeenCalculated = hasSet;
    }

    @Override
    public void setWillRaidTonight(boolean willRaid) {
        this.raidTonight = willRaid;
    }

    @Override
    public BlockPos getRandomOutsiderInDirection(EnumFacing directionX, EnumFacing directionZ) {
        BlockPos center = this.colony.getCenter();
        World world = this.colony.getWorld();
        List positions = this.colony.getWayPoints().keySet().stream().filter(pos -> BarbarianManager.isInDirection(directionX, directionZ, pos.func_177973_b((Vec3i)center))).collect(Collectors.toList());
        positions.addAll(this.colony.getBuildingManager().getBuildings().keySet().stream().filter(pos -> BarbarianManager.isInDirection(directionX, directionZ, pos.func_177973_b((Vec3i)center))).collect(Collectors.toList()));
        BlockPos thePos = center;
        double distance = 0.0;
        AbstractBuilding theBuilding = null;
        for (BlockPos pos2 : positions) {
            double currentDistance = center.func_177951_i((Vec3i)pos2);
            if (!(currentDistance > distance) || !world.func_175697_a(pos2, 10)) continue;
            distance = currentDistance;
            thePos = pos2;
            theBuilding = this.colony.getBuildingManager().getBuilding(thePos);
        }
        int minDistance = 0;
        if (theBuilding != null) {
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = theBuilding.getCorners();
            minDistance = Math.max((Integer)((Tuple)corners.func_76341_a()).func_76341_a() - (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a() - (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
        }
        if (thePos.equals((Object)center)) {
            return center;
        }
        int radius = 10;
        while (world.func_175697_a(thePos, radius)) {
            radius += 10;
        }
        int dist = Math.max(minDistance, Math.min(radius, 75));
        thePos = thePos.func_177967_a(directionX, dist);
        thePos = thePos.func_177967_a(directionZ, dist);
        int randomDegree = world.field_73012_v.nextInt(360);
        double rads = (double)randomDegree / 180.0 * Math.PI;
        double x = Math.round((double)thePos.func_177958_n() + 3.0 * Math.sin(rads));
        double z = Math.round((double)thePos.func_177952_p() + 3.0 * Math.cos(rads));
        Log.getLogger().info("Spawning at: " + x + " " + z);
        return new BlockPos(x, (double)thePos.func_177956_o(), z);
    }

    private static boolean isInDirection(EnumFacing directionX, EnumFacing directionZ, BlockPos vector) {
        return EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)0.0f, (float)0.0f) == directionX && EnumFacing.func_176737_a((float)0.0f, (float)0.0f, (float)vector.func_177952_p()) == directionZ;
    }
}

