/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.guard.EntityAIMeleeGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.EntityAIRangeGuard;
import com.minecolonies.coremod.sounds.ArcherSounds;
import com.minecolonies.coremod.sounds.KnightSounds;
import java.util.Random;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobGuard
extends AbstractJob {
    private static final int GUARD_CHANCE = 3;

    public JobGuard(CitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Guard";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        AbstractBuildingWorker building = this.getCitizen().getWorkBuilding();
        if (building instanceof AbstractBuildingGuards) {
            AbstractBuildingGuards.GuardJob job = ((AbstractBuildingGuards)building).getJob();
            if (job == null) {
                job = JobGuard.generateRandomAI((AbstractBuildingGuards)building);
            }
            if (job == AbstractBuildingGuards.GuardJob.KNIGHT) {
                return RenderBipedCitizen.Model.KNIGHT_GUARD;
            }
            return RenderBipedCitizen.Model.ARCHER_GUARD;
        }
        return RenderBipedCitizen.Model.ARCHER_GUARD;
    }

    @Override
    @NotNull
    public AbstractAISkeleton<? extends AbstractJob> generateAI() {
        AbstractBuildingWorker building = this.getCitizen().getWorkBuilding();
        if (building instanceof AbstractBuildingGuards) {
            AbstractBuildingGuards.GuardJob job = ((AbstractBuildingGuards)building).getJob();
            if (job == AbstractBuildingGuards.GuardJob.KNIGHT) {
                return new EntityAIMeleeGuard(this);
            }
            return new EntityAIRangeGuard(this);
        }
        return new EntityAIRangeGuard(this);
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            if (this.getModel().equals((Object)RenderBipedCitizen.Model.ARCHER_GUARD)) {
                return this.getCitizen().isFemale() ? ArcherSounds.Female.badWeather : null;
            }
            return this.getCitizen().isFemale() ? null : KnightSounds.Male.badWeather;
        }
        return null;
    }

    @NotNull
    private static AbstractBuildingGuards.GuardJob generateRandomAI(@NotNull AbstractBuildingGuards building) {
        int chance = new Random().nextInt(3);
        if (chance == 1) {
            building.setJob(AbstractBuildingGuards.GuardJob.KNIGHT);
            return AbstractBuildingGuards.GuardJob.KNIGHT;
        }
        building.setJob(AbstractBuildingGuards.GuardJob.RANGER);
        return AbstractBuildingGuards.GuardJob.RANGER;
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, EntityCitizen citizen) {
        super.triggerDeathAchievement(source, citizen);
        if (source.func_76346_g() instanceof EntityEnderman) {
            citizen.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementGuardDeathEnderman);
        }
    }
}

