/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.farmer.EntityAIWorkFarmer;
import com.minecolonies.coremod.sounds.FarmerSounds;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobFarmer
extends AbstractJob {
    public JobFarmer(CitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Farmer";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.FARMER;
    }

    @NotNull
    public AbstractAISkeleton<JobFarmer> generateAI() {
        return new EntityAIWorkFarmer(this);
    }

    @Override
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? FarmerSounds.Female.offToBed : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? FarmerSounds.Female.badWeather : null;
        }
        return null;
    }

    @Override
    public SoundEvent getMoveAwaySound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? FarmerSounds.Female.hostile : null;
        }
        return null;
    }
}

