/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.sounds.DeliverymanSounds;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobDeliveryman
extends AbstractJob {
    private static final String TAG_CURRENT_TASK = "currentTask";
    private static final String TAG_RETURNING = "returning";
    private LinkedList<IToken<?>> taskQueue = new LinkedList();
    private boolean returning;

    public JobDeliveryman(CitizenData entity) {
        super(entity);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.taskQueue.clear();
        if (compound.func_74764_b(TAG_CURRENT_TASK)) {
            NBTTagList queuItems = compound.func_150295_c(TAG_CURRENT_TASK, 10);
            NBTUtils.streamCompound(queuItems).map(tokenCompound -> (IToken)StandardFactoryController.getInstance().deserialize((NBTTagCompound)tokenCompound)).forEach(this.taskQueue::add);
        }
        this.returning = false;
        if (compound.func_74764_b(TAG_RETURNING)) {
            this.returning = compound.func_74767_n(TAG_RETURNING);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Deliveryman";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.DELIVERYMAN;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList queuList = this.taskQueue.stream().map(iToken -> StandardFactoryController.getInstance().serialize(iToken)).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a(TAG_CURRENT_TASK, (NBTBase)queuList);
        compound.func_74757_a(TAG_RETURNING, this.returning);
    }

    @NotNull
    public AbstractAISkeleton<JobDeliveryman> generateAI() {
        return new EntityAIWorkDeliveryman(this);
    }

    @Override
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? DeliverymanSounds.Female.offToBed : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? DeliverymanSounds.Female.badWeather : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getMoveAwaySound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? DeliverymanSounds.Female.hostile : null;
        }
        return null;
    }

    public boolean hasTask() {
        return !this.taskQueue.isEmpty() || this.returning;
    }

    public IRequest<Delivery> getCurrentTask() {
        if (this.taskQueue.isEmpty()) {
            return null;
        }
        return this.getColony().getRequestManager().getRequestForToken(this.taskQueue.peekFirst());
    }

    public void addRequest(@NotNull IToken<?> token) {
        this.taskQueue.add(token);
    }

    public void finishRequest(boolean successful) {
        if (this.taskQueue.isEmpty()) {
            return;
        }
        this.setReturning(true);
        IToken<?> current = this.taskQueue.removeFirst();
        this.getColony().getRequestManager().updateRequestState(current, successful ? RequestState.COMPLETED : RequestState.CANCELLED);
    }

    public void onTaskDeletion(@NotNull IToken<?> token) {
        if (this.taskQueue.contains(token)) {
            if (this.taskQueue.peek().equals(token)) {
                this.setReturning(true);
            }
            this.taskQueue.remove(token);
        }
    }

    public List<IToken<?>> getTaskQueue() {
        return ImmutableList.copyOf(this.taskQueue);
    }

    public boolean getReturning() {
        return this.returning;
    }

    public void setReturning(boolean returning) {
        this.returning = returning;
    }
}

