/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.builder.EntityAIStructureBuilder;
import com.minecolonies.coremod.sounds.BuilderSounds;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobBuilder
extends AbstractJobStructure {
    private static final String TAG_WORK_ORDER = "workorder";
    private int workOrderId;

    public JobBuilder(CitizenData entity) {
        super(entity);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_WORK_ORDER)) {
            this.workOrderId = compound.func_74762_e(TAG_WORK_ORDER);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Builder";
    }

    @Override
    @NotNull
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.BUILDER;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.workOrderId != 0) {
            compound.func_74768_a(TAG_WORK_ORDER, this.workOrderId);
        }
    }

    @NotNull
    public AbstractAISkeleton<JobBuilder> generateAI() {
        return new EntityAIStructureBuilder(this);
    }

    @Override
    @Nullable
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BuilderSounds.Female.offToBed : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BuilderSounds.Female.badWeather : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getMoveAwaySound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? BuilderSounds.Female.hostile : null;
        }
        return null;
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public boolean hasWorkOrder() {
        return this.workOrderId != 0;
    }

    public int getWorkInterval() {
        return 1;
    }

    public void complete() {
        this.getWorkOrder().onCompleted(this.getCitizen().getColony());
        this.getCitizen().getColony().getWorkManager().removeWorkOrder(this.workOrderId);
        this.setWorkOrder(null);
        this.setStructure(null);
        this.getColony().getStatsManager().incrementStatistic("huts");
    }

    public WorkOrderBuildDecoration getWorkOrder() {
        return this.getColony().getWorkManager().getWorkOrder(this.workOrderId, WorkOrderBuildDecoration.class);
    }

    private void resetNeededItems() {
        AbstractBuildingWorker workerBuilding = this.getCitizen().getWorkBuilding();
        if (workerBuilding instanceof BuildingBuilder) {
            ((BuildingBuilder)workerBuilding).resetNeededResources();
        }
    }

    public void setWorkOrder(@Nullable WorkOrderBuildDecoration order) {
        if (order == null) {
            this.workOrderId = 0;
            this.resetNeededItems();
        } else {
            this.workOrderId = order.getID();
        }
    }
}

