/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.jobs.JobBaker;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.jobs.JobChickenHerder;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.colony.jobs.JobFisherman;
import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.jobs.JobPlaceholder;
import com.minecolonies.coremod.colony.jobs.JobShepherd;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import com.minecolonies.coremod.colony.jobs.JobSwineHerder;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJob {
    private static final String TAG_TYPE = "type";
    private static final String TAG_ASYNC_REQUESTS = "asyncRequests";
    private static final String MAPPING_PLACEHOLDER = "Placeholder";
    private static final String MAPPING_BUILDER = "Builder";
    private static final String MAPPING_DELIVERY = "Deliveryman";
    private static final String MAPPING_MINER = "Miner";
    private static final String MAPPING_LUMBERJACK = "Lumberjack";
    private static final String MAPPING_FARMER = "Farmer";
    private static final String MAPPING_FISHERMAN = "Fisherman";
    private static final String MAPPING_TOWER_GUARD = "GuardTower";
    private static final String MAPPING_BAKER = "Baker";
    private static final String MAPPING_COOK = "Cook";
    private static final String MAPPING_SHEPHERD = "Shepherd";
    private static final String MAPPING_COWBOY = "Cowboy";
    private static final String MAPPING_SWINE_HERDER = "SwineHerder";
    private static final String MAPPING_CHICKEN_HERDER = "ChickenHerder";
    private static final String MAPPING_SMELTER = "Smelter";
    private static final int TASK_PRIORITY = 3;
    @NotNull
    private static final Map<String, Class<? extends AbstractJob>> nameToClassMap = new HashMap<String, Class<? extends AbstractJob>>();
    @NotNull
    private static final Map<Class<? extends AbstractJob>, String> classToNameMap = new HashMap<Class<? extends AbstractJob>, String>();
    private final CitizenData citizen;
    private String nameTag = "";
    private final Set<IToken<?>> asyncRequests = new HashSet();
    private boolean searchedForFoodToday;

    public AbstractJob(CitizenData entity) {
        this.citizen = entity;
    }

    private static void addMapping(String name, @NotNull Class<? extends AbstractJob> jobClass) {
        if (nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Job class mapping");
        }
        try {
            if (jobClass.getDeclaredConstructor(CitizenData.class) != null) {
                nameToClassMap.put(name, jobClass);
                classToNameMap.put(jobClass, name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Job class mapping", exception);
        }
    }

    @Nullable
    public static AbstractJob createFromNBT(CitizenData citizen, @NotNull NBTTagCompound compound) {
        AbstractJob job = null;
        Class<? extends AbstractJob> oclass = null;
        try {
            oclass = nameToClassMap.get(compound.func_74779_i(TAG_TYPE));
            if (oclass != null) {
                Constructor<? extends AbstractJob> constructor = oclass.getDeclaredConstructor(CitizenData.class);
                job = constructor.newInstance(citizen);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (job != null) {
            try {
                job.readFromNBT(compound);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("A Job %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i(TAG_TYPE), oclass.getName()), (Throwable)ex);
                job = null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Job type '%s' or missing constructor of proper format.", compound.func_74779_i(TAG_TYPE)));
        }
        return job;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.asyncRequests.clear();
        if (compound.func_74764_b(TAG_ASYNC_REQUESTS)) {
            this.asyncRequests.addAll(NBTUtils.streamCompound(compound.func_150295_c(TAG_ASYNC_REQUESTS, 10)).map(StandardFactoryController.getInstance()::deserialize).map(o -> (IToken)o).collect(Collectors.toSet()));
        }
    }

    public abstract String getName();

    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.CITIZEN;
    }

    public Colony getColony() {
        return this.citizen.getColony();
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74778_a(TAG_TYPE, s);
        compound.func_74782_a(TAG_ASYNC_REQUESTS, (NBTBase)this.getAsyncRequests().stream().map(StandardFactoryController.getInstance()::serialize).collect(NBTUtils.toNBTTagList()));
    }

    public Set<IToken<?>> getAsyncRequests() {
        return this.asyncRequests;
    }

    public void addTasks(@NotNull EntityAITasks tasks) {
        AbstractAISkeleton<? extends AbstractJob> aiTask = this.generateAI();
        if (aiTask != null) {
            tasks.func_75776_a(3, aiTask);
        }
    }

    public abstract AbstractAISkeleton<? extends AbstractJob> generateAI();

    public boolean hasCheckedForFoodToday() {
        return this.searchedForFoodToday;
    }

    public void setCheckedForFood() {
        this.searchedForFoodToday = true;
    }

    public String getNameTagDescription() {
        return this.nameTag;
    }

    public final void setNameTag(String nameTag) {
        this.nameTag = nameTag;
    }

    public SoundEvent getBedTimeSound() {
        return null;
    }

    public SoundEvent getBadWeatherSound() {
        return null;
    }

    public SoundEvent getMoveAwaySound() {
        return null;
    }

    public void triggerDeathAchievement(DamageSource source, EntityCitizen citizen) {
    }

    public boolean onStackPickUp(@NotNull ItemStack pickedUpStack) {
        if (this.getCitizen().getWorkBuilding() != null && this.getCitizen().getWorkBuilding().overruleNextOpenRequestOfCitizenWithStack(this.getCitizen(), pickedUpStack.func_77946_l())) {
            return true;
        }
        return this.getCitizen().getHomeBuilding() != null && this.getCitizen().getHomeBuilding().overruleNextOpenRequestOfCitizenWithStack(this.getCitizen(), pickedUpStack.func_77946_l());
    }

    public CitizenData getCitizen() {
        return this.citizen;
    }

    public void onWakeUp() {
        this.searchedForFoodToday = false;
    }

    static {
        AbstractJob.addMapping(MAPPING_PLACEHOLDER, JobPlaceholder.class);
        AbstractJob.addMapping(MAPPING_BUILDER, JobBuilder.class);
        AbstractJob.addMapping(MAPPING_DELIVERY, JobDeliveryman.class);
        AbstractJob.addMapping(MAPPING_MINER, JobMiner.class);
        AbstractJob.addMapping(MAPPING_LUMBERJACK, JobLumberjack.class);
        AbstractJob.addMapping(MAPPING_FARMER, JobFarmer.class);
        AbstractJob.addMapping(MAPPING_FISHERMAN, JobFisherman.class);
        AbstractJob.addMapping(MAPPING_TOWER_GUARD, JobGuard.class);
        AbstractJob.addMapping(MAPPING_BAKER, JobBaker.class);
        AbstractJob.addMapping(MAPPING_COOK, JobCook.class);
        AbstractJob.addMapping(MAPPING_SHEPHERD, JobShepherd.class);
        AbstractJob.addMapping(MAPPING_COWBOY, JobCowboy.class);
        AbstractJob.addMapping(MAPPING_SWINE_HERDER, JobSwineHerder.class);
        AbstractJob.addMapping(MAPPING_CHICKEN_HERDER, JobChickenHerder.class);
        AbstractJob.addMapping(MAPPING_SMELTER, JobSmelter.class);
    }
}

