/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingView
implements IRequester {
    private final ColonyView colony;
    @NotNull
    private final BlockPos location;
    private final HashMap<IToken<?>, Integer> requestsByCitizen = new HashMap();
    private int buildingLevel = 0;
    private int buildingMaxLevel = 0;
    private int buildingDmPrio = 1;
    private int workOrderLevel = 0;
    private HashMap<Integer, Collection<IToken<?>>> citizensByRequests = new HashMap();

    protected AbstractBuildingView(ColonyView c, @NotNull BlockPos l) {
        this.colony = c;
        this.location = new BlockPos((Vec3i)l);
    }

    @NotNull
    public BlockPos getID() {
        return this.location;
    }

    @NotNull
    public BlockPos getLocation() {
        return this.location;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    public int getBuildingMaxLevel() {
        return this.buildingMaxLevel;
    }

    public boolean isBuildingMaxLevel() {
        return this.buildingLevel >= this.buildingMaxLevel;
    }

    public int getCurrentWorkOrderLevel() {
        return this.workOrderLevel;
    }

    public boolean hasWorkOrder() {
        return this.workOrderLevel != 0;
    }

    public boolean isBuilding() {
        return this.workOrderLevel != 0 && this.workOrderLevel > this.buildingLevel;
    }

    public boolean isRepairing() {
        return this.workOrderLevel != 0 && this.workOrderLevel == this.buildingLevel;
    }

    public void openGui(boolean shouldOpenInv) {
        if (shouldOpenInv) {
            MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.getID()));
        } else {
            Window window = this.getWindow();
            if (window != null) {
                window.open();
            }
        }
    }

    @Nullable
    public Window getWindow() {
        return null;
    }

    public void deserialize(@NotNull ByteBuf buf) {
        this.buildingLevel = buf.readInt();
        this.buildingMaxLevel = buf.readInt();
        this.buildingDmPrio = buf.readInt();
        this.workOrderLevel = buf.readInt();
        this.loadRequestSystemFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    private void loadRequestSystemFromNBT(NBTTagCompound compound) {
        this.citizensByRequests.clear();
        if (compound.func_74764_b("CitizenRequestAssignments")) {
            NBTTagList citizensByRequestList = compound.func_150295_c("CitizenRequestAssignments", 10);
            NBTUtils.streamCompound(citizensByRequestList).forEach(cbrc -> AbstractBuilding.processIntegerKeyTokenList(cbrc, this.citizensByRequests));
        }
        this.requestsByCitizen.clear();
        this.citizensByRequests.keySet().forEach(citizen -> this.citizensByRequests.get(citizen).forEach(requestToken -> this.requestsByCitizen.put((IToken<?>)requestToken, (Integer)citizen)));
    }

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull CitizenDataView citizenData, Class<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).iterator());
    }

    public ImmutableList<IRequest> getOpenRequests(@NotNull CitizenDataView data) {
        if (!this.citizensByRequests.containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.citizensByRequests.get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    public ColonyView getColony() {
        return this.colony;
    }

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull CitizenDataView citizenData, Class<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).filter(filter).iterator());
    }

    @Override
    public IToken<?> getRequesterId() {
        return null;
    }

    @Override
    @NotNull
    public ILocation getRequesterLocation() {
        return null;
    }

    @Override
    @NotNull
    public void onRequestComplete(@NotNull IToken<?> token) {
    }

    @Override
    @NotNull
    public void onRequestCancelled(@NotNull IToken<?> token) {
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IToken<?> token) {
        if (!this.requestsByCitizen.containsKey(token)) {
            return new TextComponentString("<UNKNOWN>");
        }
        return new TextComponentString(this.getColony().getCitizen(this.requestsByCitizen.get(token)).getName());
    }

    public int getBuildingDmPrio() {
        return this.buildingDmPrio;
    }
}

