/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.blocks.BlockHutDeliveryman;
import com.minecolonies.coremod.blocks.BlockHutWareHouse;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.WindowWareHouseBuilding;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHut;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BuildingWareHouse
extends AbstractBuilding {
    private static final String WAREHOUSE = "WareHouse";
    private static final String TAG_DELIVERYMAN = "Deliveryman";
    private static final String TAG_STORAGE = "tagStorage";
    private static final List<Vec3d> registeredDeliverymen = new ArrayList<Vec3d>();
    private static final int MAX_LEVEL = 5;
    private static final int MAX_STORAGE_UPGRADE = 3;
    private TileEntityWareHouse tileEntity;
    private int storageUpgrade = 0;

    public BuildingWareHouse(Colony c, BlockPos l) {
        super(c, l);
    }

    public boolean registerWithWareHouse(BuildingDeliveryman buildingWorker) {
        if (registeredDeliverymen.contains(new Vec3d((Vec3i)buildingWorker.getID()))) {
            return true;
        }
        if (registeredDeliverymen.size() >= this.getBuildingLevel()) {
            if (!registeredDeliverymen.isEmpty()) {
                this.checkForRegisteredDeliverymen();
            }
            return false;
        }
        registeredDeliverymen.add(new Vec3d((Vec3i)buildingWorker.getID()));
        return true;
    }

    private void checkForRegisteredDeliverymen() {
        ArrayList<Vec3d> registeredDeliverymenCopy = new ArrayList<Vec3d>(registeredDeliverymen);
        for (Vec3d pos : registeredDeliverymenCopy) {
            Colony colony = this.getColony();
            if (colony == null || colony.getWorld() == null || colony.getWorld().func_180495_p(new BlockPos(pos)) instanceof BlockHutDeliveryman && !colony.isCoordInColony(colony.getWorld(), new BlockPos(pos))) continue;
            registeredDeliverymen.remove(pos);
        }
    }

    public boolean canAccessWareHouse(BuildingDeliveryman buildingWorker) {
        return registeredDeliverymen.contains(new Vec3d((Vec3i)buildingWorker.getID()));
    }

    public List<Vec3d> getRegisteredDeliverymen() {
        return new ArrayList<Vec3d>(Collections.unmodifiableList(registeredDeliverymen));
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        registeredDeliverymen.clear();
        NBTTagList deliverymanTagList = compound.func_150295_c(TAG_DELIVERYMAN, 10);
        for (int i = 0; i < deliverymanTagList.func_74745_c(); ++i) {
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)deliverymanTagList.func_150305_b(i));
            if (this.getColony() == null || !(this.getColony().getBuildingManager().getBuilding(pos) instanceof AbstractBuildingWorker) || registeredDeliverymen.contains(new Vec3d((Vec3i)pos))) continue;
            registeredDeliverymen.add(new Vec3d((Vec3i)pos));
        }
        this.storageUpgrade = compound.func_74762_e(TAG_STORAGE);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return WAREHOUSE;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList levelTagList = new NBTTagList();
        for (Vec3d deliverymanBuilding : registeredDeliverymen) {
            levelTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)new BlockPos(deliverymanBuilding)));
        }
        compound.func_74782_a(TAG_DELIVERYMAN, (NBTBase)levelTagList);
        compound.func_74768_a(TAG_STORAGE, this.storageUpgrade);
    }

    @Override
    public TileEntityWareHouse getTileEntity() {
        TileEntity te;
        Colony colony = this.getColony();
        if ((this.tileEntity == null || this.tileEntity.func_145837_r()) && colony != null && colony.getWorld() != null && this.getLocation() != null && colony.getWorld().func_180495_p(this.getLocation()) != null && colony.getWorld().func_180495_p(this.getLocation()).func_177230_c() instanceof BlockHutWareHouse && (te = this.getColony().getWorld().func_175625_s(this.getLocation())) instanceof TileEntityWareHouse) {
            this.tileEntity = (TileEntityWareHouse)te;
            if (this.tileEntity.getBuilding() == null) {
                this.tileEntity.setColony(colony);
                this.tileEntity.setBuilding(this);
            }
        }
        return this.tileEntity;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.storageUpgrade < 3);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if ((block instanceof BlockContainer || block instanceof BlockMinecoloniesRack) && world != null) {
            TileEntity entity = this.getColony().getWorld().func_175625_s(pos);
            if (entity instanceof TileEntityChest) {
                BuildingWareHouse.handleBuildingOverChest(pos, (TileEntityChest)entity, world);
            }
            this.addContainerPosition(pos);
        }
    }

    public static void handleBuildingOverChest(@NotNull BlockPos pos, TileEntityChest chest, World world) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        int size = chest.getSingleChestHandler().getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = chest.getSingleChestHandler().getStackInSlot(slot);
            if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                inventory.add(stack.func_77946_l());
            }
            chest.getSingleChestHandler().extractItem(slot, Integer.MAX_VALUE, false);
        }
        world.func_180501_a(pos, ModBlocks.blockRack.func_176223_P(), 3);
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityRack) {
            for (ItemStack stack : inventory) {
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                InventoryUtils.addItemStackToItemHandler((IItemHandler)((TileEntityRack)entity).getInventory(), stack);
            }
        }
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> getResolvers() {
        ImmutableCollection<IRequestResolver<?>> supers = super.getResolvers();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(supers);
        builder.add((Object)new WarehouseRequestResolver(this.getRequester().getRequesterLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    public void upgradeContainers(World world) {
        if (this.storageUpgrade < 3) {
            for (BlockPos pos : this.getAdditionalCountainers()) {
                TileEntity entity = world.func_175625_s(pos);
                if (!(entity instanceof TileEntityRack)) continue;
                ((TileEntityRack)entity).upgradeItemStorage();
            }
            ++this.storageUpgrade;
        }
        this.markDirty();
    }

    public static class View
    extends AbstractBuildingHut.View {
        private boolean allowUpgrade = true;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowWareHouseBuilding(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.allowUpgrade = buf.readBoolean();
        }

        public boolean canUpgradeStorage() {
            return this.allowUpgrade;
        }
    }
}

