/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingSmeltery
extends AbstractBuildingWorker {
    private static final String SMELTERY_DESC = "Smeltery";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int STUFF_TO_KEEP = 10;
    private static final String TAG_POS = "pos";
    private static final String TAG_FURNACES = "furnaces";
    private final List<BlockPos> furnaces = new ArrayList<BlockPos>();

    public BuildingSmeltery(Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(ColonyManager.getCompatabilityManager()::isOre, Integer.MAX_VALUE);
        this.keepX.put(TileEntityFurnace::func_145954_b, Integer.MAX_VALUE);
        this.keepX.put(stack -> ItemStackUtils.isEmpty(stack) == false && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemArmor), 10);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SMELTERY_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobSmelter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SMELTERY_DESC;
    }

    public List<BlockPos> getFurnaces() {
        return new ArrayList<BlockPos>(this.furnaces);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList furnacesTagList = new NBTTagList();
        for (BlockPos entry : this.furnaces) {
            NBTTagCompound furnaceCompound = new NBTTagCompound();
            furnaceCompound.func_74782_a(TAG_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)entry));
            furnacesTagList.func_74742_a((NBTBase)furnaceCompound);
        }
        compound.func_74782_a(TAG_FURNACES, (NBTBase)furnacesTagList);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList furnaceTagList = compound.func_150295_c(TAG_FURNACES, 10);
        for (int i = 0; i < furnaceTagList.func_74745_c(); ++i) {
            this.furnaces.add(NBTUtil.func_186861_c((NBTTagCompound)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS)));
        }
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof BlockFurnace && !this.furnaces.contains(pos)) {
            this.furnaces.add(pos);
        }
        this.markDirty();
    }

    public int ingotMultiplier(int citizenLevel, Random random) {
        switch (this.getBuildingLevel()) {
            case 1: {
                return random.nextInt(100 - citizenLevel) == 0 ? 2 : 1;
            }
            case 2: {
                return random.nextInt(100 - citizenLevel * 2) == 2 ? 2 : 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return random.nextInt(100 - citizenLevel) == 0 ? 3 : 2;
            }
        }
        return 1;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingSmeltery.SMELTERY_DESC);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }
    }
}

