/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutLumberjack;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.entity.EntityCitizen;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;

public class BuildingLumberjack
extends AbstractBuildingWorker {
    private static final String TAG_SAPLINGS = "saplings";
    private static final String TAG_CUT = "shouldCut";
    private static final ItemStack SAPLING_STACK = new ItemStack(Blocks.field_150345_g);
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String LUMBERJACK = "Lumberjack";
    private final Map<ItemStorage, Boolean> treesToFell = new LinkedHashMap<ItemStorage, Boolean>();

    public BuildingLumberjack(Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), 1);
        this.checkTreesToFell();
    }

    @Override
    public Map<Predicate<ItemStack>, Integer> getRequiredItemsAndAmount() {
        Map<Predicate<ItemStack>, Integer> tempKeep = super.getRequiredItemsAndAmount();
        EntityCitizen mainWorker = this.getMainWorkerEntity();
        if (mainWorker == null) {
            return tempKeep;
        }
        int invSIze = mainWorker.getInventoryCitizen().func_70302_i_();
        int keptStacks = 0;
        for (int i = 0; i < invSIze; ++i) {
            ItemStack stack = mainWorker.getInventoryCitizen().func_70301_a(i);
            if (ItemStackUtils.isEmpty(stack).booleanValue() || stack.func_77973_b() != SAPLING_STACK.func_77973_b()) continue;
            boolean isAlreadyInList = false;
            for (Map.Entry<Predicate<ItemStack>, Integer> entry : tempKeep.entrySet()) {
                if (!entry.getKey().test(stack)) continue;
                isAlreadyInList = true;
            }
            if (isAlreadyInList) continue;
            tempKeep.put(arg_0 -> ((ItemStack)stack).func_77969_a(arg_0), 64);
            if (++keptStacks < this.getMaxBuildingLevel() * 2) continue;
            return tempKeep;
        }
        return tempKeep;
    }

    public void setTreeToCut(ItemStack stack, boolean cut) {
        this.treesToFell.put(new ItemStorage(stack), cut);
    }

    public Map<ItemStorage, Boolean> getTreesToCut() {
        return Collections.unmodifiableMap(this.treesToFell);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingLumberjack);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeLumberjackMax);
        }
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobLumberjack(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (this.treesToFell.isEmpty()) {
            NBTTagList saplingTagList = compound.func_150295_c(TAG_SAPLINGS, 10);
            for (int i = 0; i < saplingTagList.func_74745_c(); ++i) {
                NBTTagCompound saplingCompound = saplingTagList.func_150305_b(i);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)saplingCompound);
                boolean cut = saplingCompound.func_74767_n(TAG_CUT);
                this.treesToFell.put(new ItemStorage(stack), cut);
            }
        }
        this.checkTreesToFell();
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList saplingTagList = new NBTTagList();
        for (Map.Entry<ItemStorage, Boolean> entry : this.treesToFell.entrySet()) {
            NBTTagCompound saplingCompound = new NBTTagCompound();
            entry.getKey().getItemStack().func_77955_b(saplingCompound);
            saplingCompound.func_74757_a(TAG_CUT, entry.getValue().booleanValue());
            saplingTagList.func_74742_a((NBTBase)saplingCompound);
        }
        compound.func_74782_a(TAG_SAPLINGS, (NBTBase)saplingTagList);
    }

    @Override
    @NotNull
    public String getJobName() {
        return LUMBERJACK;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.treesToFell.size());
        for (Map.Entry<ItemStorage, Boolean> entry : this.treesToFell.entrySet()) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)entry.getKey().getItemStack());
            buf.writeBoolean(entry.getValue().booleanValue());
        }
    }

    private void checkTreesToFell() {
        if (this.treesToFell.size() != ColonyManager.getCompatabilityManager().getCopyOfSaplings().size()) {
            for (ItemStorage storage : ColonyManager.getCompatabilityManager().getCopyOfSaplings()) {
                if (this.treesToFell.containsKey(storage)) continue;
                this.treesToFell.put(storage, true);
            }
        }
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public final Map<ItemStorage, Boolean> treesToFell = new LinkedHashMap<ItemStorage, Boolean>();

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.treesToFell.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
                if (stack == null || stack.func_77973_b() == null) continue;
                boolean cut = buf.readBoolean();
                this.treesToFell.put(new ItemStorage(stack), cut);
            }
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.CHARISMA;
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutLumberjack(this);
        }
    }
}

