/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHomeBuilding;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHut;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

public class BuildingHome
extends AbstractBuildingHut {
    private static final String TAG_RESIDENTS = "residents";
    private static final String TAG_BEDS = "beds";
    private static final String CITIZEN = "Citizen";
    @NotNull
    private final List<CitizenData> residents = new ArrayList<CitizenData>();
    @NotNull
    private final List<BlockPos> bedList = new ArrayList<BlockPos>();

    public BuildingHome(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        int[] residentIds;
        super.readFromNBT(compound);
        this.residents.clear();
        for (int citizenId : residentIds = compound.func_74759_k(TAG_RESIDENTS)) {
            CitizenData citizen = this.getColony().getCitizenManager().getCitizen(citizenId);
            if (citizen == null) continue;
            this.residents.add(citizen);
            citizen.setHomeBuilding(this);
        }
        NBTTagList bedTagList = compound.func_150295_c(TAG_BEDS, 10);
        for (int i = 0; i < bedTagList.func_74745_c(); ++i) {
            NBTTagCompound bedCompound = bedTagList.func_150305_b(i);
            BlockPos bedPos = NBTUtil.func_186861_c((NBTTagCompound)bedCompound);
            if (this.bedList.contains(bedPos)) continue;
            this.bedList.add(bedPos);
        }
    }

    @Override
    public void onWakeUp() {
        World world = this.getColony().getWorld();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.bedList) {
            IBlockState state = world.func_180495_p(pos);
            IBlockState actualState = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
            if (!(actualState.func_177230_c() instanceof BlockBed) || !((Boolean)actualState.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue() || !((BlockBed.EnumPartType)actualState.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.HEAD)) continue;
            world.func_180501_a(pos, actualState.func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CITIZEN;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (!this.residents.isEmpty()) {
            int[] residentIds = new int[this.residents.size()];
            for (int i = 0; i < this.residents.size(); ++i) {
                residentIds[i] = this.residents.get(i).getId();
            }
            compound.func_74783_a(TAG_RESIDENTS, residentIds);
        }
        if (!this.bedList.isEmpty()) {
            NBTTagList bedTagList = new NBTTagList();
            for (BlockPos pos : this.bedList) {
                bedTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            }
            compound.func_74782_a(TAG_BEDS, (NBTBase)bedTagList);
        }
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block == Blocks.field_150324_C && !this.bedList.contains(pos)) {
            this.bedList.add(pos);
        }
    }

    @Override
    public void onDestroyed() {
        this.residents.stream().filter(Objects::nonNull).forEach(citizen -> citizen.setHomeBuilding(null));
        this.residents.clear();
        super.onDestroyed();
    }

    @Override
    public void removeCitizen(@NotNull CitizenData citizen) {
        if (this.residents.contains(citizen)) {
            citizen.setHomeBuilding(null);
            this.residents.remove(citizen);
            this.markDirty();
        }
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.residents.size() < this.getMaxInhabitants() && this.getColony() != null && !this.getColony().isManualHousing()) {
            this.addHomelessCitizens();
        }
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    private void addHomelessCitizens() {
        for (CitizenData citizen : this.getColony().getCitizenManager().getCitizens()) {
            if (citizen.getHomeBuilding() instanceof BuildingHome && citizen.getHomeBuilding().getBuildingLevel() < this.getBuildingLevel()) {
                citizen.getHomeBuilding().removeCitizen(citizen);
            }
            if (citizen.getHomeBuilding() != null) continue;
            this.addResident(citizen);
            if (!this.isFull()) continue;
            break;
        }
    }

    public void addResident(@NotNull CitizenData citizen) {
        this.residents.add(citizen);
        citizen.setHomeBuilding(this);
        this.markDirty();
    }

    public boolean isFull() {
        return this.residents.size() >= this.getMaxInhabitants();
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingColonist);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeColonistMax);
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.residents.size());
        for (CitizenData citizen : this.residents) {
            buf.writeInt(citizen.getId());
        }
    }

    @Override
    public void setBuildingLevel(int level) {
        super.setBuildingLevel(level);
        this.getColony().getCitizenManager().calculateMaxCitizens();
    }

    @NotNull
    public List<BlockPos> getBedList() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    public boolean hasResident(CitizenData citizen) {
        return this.residents.contains(citizen);
    }

    public static class View
    extends AbstractBuildingHut.View {
        @NotNull
        private final List<Integer> residents = new ArrayList<Integer>();

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @NotNull
        public List<Integer> getResidents() {
            return Collections.unmodifiableList(this.residents);
        }

        public void removeResident(int index) {
            this.residents.remove(index);
        }

        public void addResident(int id) {
            this.residents.add(id);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHomeBuilding(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.residents.add(buf.readInt());
            }
        }
    }
}

