/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobCook;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingCook
extends AbstractBuildingWorker {
    private static final String COOK_DESC = "Cook";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_POS = "pos";
    private static final String TAG_FURNACES = "furnaces";
    private static final String TAG_COOKING = "cooking";
    private final List<BlockPos> furnaces = new ArrayList<BlockPos>();
    private boolean isSomethingInOven = true;

    public BuildingCook(Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(ItemStackUtils.ISFOOD, Integer.MAX_VALUE);
        this.keepX.put(ItemStackUtils.ISCOOKABLE, Integer.MAX_VALUE);
        this.keepX.put(TileEntityFurnace::func_145954_b, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobCook(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return COOK_DESC;
    }

    public List<BlockPos> getFurnaces() {
        return new ArrayList<BlockPos>(this.furnaces);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList furnacesTagList = new NBTTagList();
        for (BlockPos entry : this.furnaces) {
            NBTTagCompound furnaceCompound = new NBTTagCompound();
            furnaceCompound.func_74782_a(TAG_POS, (NBTBase)NBTUtil.func_186859_a((BlockPos)entry));
            furnacesTagList.func_74742_a((NBTBase)furnaceCompound);
        }
        compound.func_74782_a(TAG_FURNACES, (NBTBase)furnacesTagList);
        compound.func_74757_a(TAG_COOKING, this.isSomethingInOven);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList furnaceTagList = compound.func_150295_c(TAG_FURNACES, 10);
        for (int i = 0; i < furnaceTagList.func_74745_c(); ++i) {
            this.furnaces.add(NBTUtil.func_186861_c((NBTTagCompound)furnaceTagList.func_150305_b(i).func_74775_l(TAG_POS)));
        }
        this.isSomethingInOven = compound.func_74767_n(TAG_COOKING);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof BlockFurnace && !this.furnaces.contains(pos)) {
            this.furnaces.add(pos);
        }
        this.markDirty();
    }

    public boolean isSomethingInOven() {
        return this.isSomethingInOven;
    }

    public void setIsSomethingInOven(boolean set) {
        this.isSomethingInOven = set;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingCook.COOK_DESC);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.CHARISMA;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }
    }
}

