/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.inventory.InventoryCitizen;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingBuilder
extends AbstractBuildingWorker {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final String BUILDER = "Builder";
    private static final String TAG_RESOURCE_LIST = "resourcesItem";
    private HashMap<String, BuildingBuilderResource> neededResources = new HashMap();

    public BuildingBuilder(Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), 1);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), 1);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), 1);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingBuilder);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeBuilderMax);
        }
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof BlockChest) {
            this.addContainerPosition(pos);
        }
    }

    @Override
    public Map<Predicate<ItemStack>, Integer> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Integer> toKeep = new HashMap<Predicate<ItemStack>, Integer>(this.keepX);
        toKeep.putAll(this.keepX);
        for (BuildingBuilderResource stack : this.neededResources.values()) {
            toKeep.put(arg_0 -> ((ItemStack)stack.getItemStack()).func_77969_a(arg_0), stack.getAmount());
        }
        return toKeep;
    }

    @Override
    public ItemStack transferStack(@NotNull ItemStack stack, @NotNull World world) {
        ItemStack resultStack = super.transferStack(stack, world);
        if (ItemStackUtils.isEmpty(resultStack).booleanValue()) {
            this.markDirty();
        }
        return resultStack;
    }

    @Override
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        ItemStack itemStack = super.forceTransferStack(stack, world);
        if (ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            this.markDirty();
        }
        return itemStack;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobBuilder(citizen);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList neededResTagList = compound.func_150295_c(TAG_RESOURCE_LIST, 10);
        for (int i = 0; i < neededResTagList.func_74745_c(); ++i) {
            NBTTagCompound neededRes = neededResTagList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)neededRes);
            BuildingBuilderResource resource = new BuildingBuilderResource(stack, ItemStackUtils.getSize(stack));
            this.neededResources.put(stack.func_77977_a(), resource);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagList neededResTagList = new NBTTagList();
        for (BuildingBuilderResource resource : this.neededResources.values()) {
            NBTTagCompound neededRes = new NBTTagCompound();
            ItemStack itemStack = new ItemStack(resource.getItem(), resource.getAmount(), resource.getDamageValue());
            itemStack.func_77955_b(neededRes);
            neededResTagList.func_74742_a((NBTBase)neededRes);
        }
        compound.func_74782_a(TAG_RESOURCE_LIST, (NBTBase)neededResTagList);
    }

    @Override
    @NotNull
    public String getJobName() {
        return BUILDER;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        this.updateAvailableResources();
        buf.writeInt(this.neededResources.size());
        for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
            BuildingBuilderResource resource = this.neededResources.get(entry.getKey());
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)resource.getItemStack());
            buf.writeInt(resource.getAvailable());
            buf.writeInt(resource.getAmount());
        }
    }

    private void updateAvailableResources() {
        EntityCitizen builder = this.getMainWorkerEntity();
        InventoryCitizen builderInventory = null;
        if (builder != null) {
            builderInventory = builder.getInventoryCitizen();
        }
        for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
            TileEntityColonyBuilding chestInventory;
            BuildingBuilderResource resource = entry.getValue();
            resource.setAvailable(0);
            if (builderInventory != null) {
                resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)builderInventory), resource.getItem(), resource.getDamageValue()));
            }
            if ((chestInventory = this.getTileEntity()) != null) {
                resource.addAvailable(InventoryUtils.getItemCountInProvider((ICapabilityProvider)chestInventory, resource.getItem(), resource.getDamageValue()));
            }
            if (builder == null) continue;
            for (BlockPos pos : this.getAdditionalCountainers()) {
                TileEntity entity = CompatibilityUtils.getWorld((Entity)builder).func_175625_s(pos);
                if (!(entity instanceof TileEntityChest)) continue;
                resource.addAvailable(InventoryUtils.getItemCountInProvider((ICapabilityProvider)entity, resource.getItem(), resource.getDamageValue()));
            }
        }
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return new HashMap<String, BuildingBuilderResource>(this.neededResources);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        BuildingBuilderResource resource = this.neededResources.get(res.func_77977_a());
        if (resource == null) {
            resource = new BuildingBuilderResource(res, amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.neededResources.put(res.func_77977_a(), resource);
        this.markDirty();
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        int preAmount = 0;
        if (this.neededResources.containsKey(res.func_77977_a())) {
            preAmount = this.neededResources.get(res.func_77977_a()).getAmount();
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(res.func_77977_a());
        } else {
            this.neededResources.get(res.func_77977_a()).setAmount(preAmount - amount);
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap();
        this.markDirty();
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        return this.neededResources.containsKey(stack.func_77977_a());
    }
}

