/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHut;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.EntityCitizen;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingWorker
extends AbstractBuildingHut {
    public static final int WOOD_HUT_LEVEL = 0;
    private static final String TAG_WORKER = "worker";
    private static final String TAG_ID = "workerId";
    private final List<CitizenData> workers = new ArrayList<CitizenData>();

    public AbstractBuildingWorker(@NotNull Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemFood, this.getBuildingLevel() * 2);
    }

    @NotNull
    public abstract AbstractJob createJob(CitizenData var1);

    public CitizenData getMainWorker() {
        if (this.workers.isEmpty()) {
            return null;
        }
        return this.workers.get(0);
    }

    public boolean isItemStackInRequest(@Nullable ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        for (CitizenData data : this.getWorker()) {
            for (IRequest request : this.getOpenRequests(data)) {
                if (!request.getDelivery().func_185136_b(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public List<CitizenData> getWorker() {
        return new ArrayList<CitizenData>(this.workers);
    }

    public void setWorker(CitizenData citizen) {
        if (this.workers.contains(citizen)) {
            return;
        }
        if (citizen != null) {
            EntityCitizen tempCitizen = citizen.getCitizenEntity();
            if (tempCitizen != null) {
                if (!tempCitizen.getLastJob().isEmpty() && !tempCitizen.getLastJob().equals(this.getJobName())) {
                    citizen.resetExperienceAndLevel();
                }
                tempCitizen.setLastJob(this.getJobName());
            }
            this.workers.add(citizen);
            citizen.setWorkBuilding(this);
        }
        this.markDirty();
    }

    @Nullable
    public List<EntityCitizen> getWorkerEntities() {
        ArrayList<EntityCitizen> entities = new ArrayList<EntityCitizen>();
        for (CitizenData data : this.workers) {
            if (data == null || data.getCitizenEntity() == null) continue;
            entities.add(data.getCitizenEntity());
        }
        return entities;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        block4: {
            super.readFromNBT(compound);
            if (compound.func_74764_b(TAG_WORKER)) {
                try {
                    NBTTagList workersTagList = compound.func_150295_c(TAG_WORKER, 10);
                    for (int i = 0; i < workersTagList.func_74745_c(); ++i) {
                        CitizenData data = this.getColony().getCitizenManager().getCitizen(workersTagList.func_150305_b(i).func_74762_e(TAG_ID));
                        if (data == null) continue;
                        data.setWorkBuilding(this);
                        this.workers.add(data);
                    }
                }
                catch (Exception e) {
                    MineColonies.getLogger().warn("Warning: Updating data structures:", (Throwable)e);
                    CitizenData worker = this.getColony().getCitizenManager().getCitizen(compound.func_74762_e(TAG_WORKER));
                    this.workers.add(worker);
                    if (worker == null) break block4;
                    worker.setWorkBuilding(this);
                }
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (!this.workers.isEmpty()) {
            NBTTagList workersTagList = new NBTTagList();
            for (CitizenData data : this.workers) {
                if (data == null) continue;
                NBTTagCompound idCompound = new NBTTagCompound();
                idCompound.func_74768_a(TAG_ID, data.getId());
                workersTagList.func_74742_a((NBTBase)idCompound);
            }
            compound.func_74782_a(TAG_WORKER, (NBTBase)workersTagList);
        }
    }

    @Override
    public void onDestroyed() {
        if (this.hasEnoughWorkers()) {
            this.workers.clear();
        }
        super.onDestroyed();
    }

    @Override
    public void onWakeUp() {
    }

    public boolean hasEnoughWorkers() {
        return !this.workers.isEmpty();
    }

    @Override
    public void removeCitizen(CitizenData citizen) {
        if (this.isWorker(citizen)) {
            citizen.setWorkBuilding(null);
            this.workers.remove(citizen);
        }
        this.markDirty();
    }

    public boolean isWorker(CitizenData citizen) {
        return this.workers.contains(citizen);
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        CitizenData joblessCitizen;
        super.onWorldTick(event);
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(this.hasEnoughWorkers() || this.getBuildingLevel() <= 0 && !(this instanceof BuildingBuilder) || this.getColony().isManualHiring() || (joblessCitizen = this.getColony().getCitizenManager().getJoblessCitizen()) == null)) {
            this.setWorker(joblessCitizen);
        }
    }

    @NotNull
    public abstract String getJobName();

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.workers.size());
        for (CitizenData data : this.workers) {
            buf.writeInt(data == null ? 0 : data.getId());
        }
    }

    public EntityCitizen getMainWorkerEntity() {
        if (this.workers.isEmpty()) {
            return null;
        }
        return this.workers.get(0).getCitizenEntity();
    }

    public int getMaxToolLevel() {
        if (this.getBuildingLevel() >= this.getMaxBuildingLevel()) {
            return 32;
        }
        if (this.getBuildingLevel() <= 0) {
            return 0;
        }
        return this.getBuildingLevel() - 0;
    }

    public static class View
    extends AbstractBuildingHut.View {
        private final List<Integer> workerIDs = new ArrayList<Integer>();

        public View(ColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        public List<Integer> getWorkerId() {
            return new ArrayList<Integer>(this.workerIDs);
        }

        public void addWorkerId(int workerId) {
            this.workerIDs.add(workerId);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int size = buf.readInt();
            this.workerIDs.clear();
            for (int i = 0; i < size; ++i) {
                this.workerIDs.add(buf.readInt());
            }
        }

        @NotNull
        public Skill getPrimarySkill() {
            return Skill.PLACEHOLDER;
        }

        @NotNull
        public Skill getSecondarySkill() {
            return Skill.PLACEHOLDER;
        }

        public void removeWorkerId(int id) {
            for (int i = 0; i < this.workerIDs.size(); ++i) {
                int workerId = this.workerIDs.get(i);
                if (workerId != id) continue;
                this.workerIDs.remove(i);
            }
        }

        public boolean hasEnoughWorkers() {
            return !this.workerIDs.isEmpty();
        }
    }

    public static enum Skill {
        STRENGTH,
        ENDURANCE,
        CHARISMA,
        INTELLIGENCE,
        DEXTERITY,
        PLACEHOLDER;

    }
}

