/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.tileentities.TileEntityRack;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingHut
extends AbstractBuilding {
    public AbstractBuildingHut(@NotNull Colony c, BlockPos l) {
        super(c, l);
    }

    public int getMaxInhabitants() {
        return 1;
    }

    public int getCountOfPredicateInHut(Predicate<ItemStack> predicate, int stop, @NotNull World world) {
        int amount = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.getTileEntity()), predicate);
        if (amount >= stop) {
            return amount;
        }
        for (BlockPos pos : this.getAdditionalCountainers()) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityRack) {
                amount += ((TileEntityRack)entity).getItemCount(predicate);
            } else if (entity instanceof TileEntityChest) {
                amount += InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)((TileEntityChest)entity)), predicate);
            }
            if (amount < stop) continue;
            return amount;
        }
        return amount;
    }

    public static class View
    extends AbstractBuildingView {
        protected View(ColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }
    }
}

