/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutGuardTower;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobGuard;
import com.minecolonies.coremod.entity.EntityCitizen;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingGuards
extends AbstractBuildingWorker {
    public static final int PATROL_DISTANCE = 40;
    private static final String GUARD_TOWER = "GuardTower";
    private static final String TAG_TASK = "TASK";
    private static final String TAG_JOB = "job";
    private static final int GUARD_HUT_MAX_LEVEL = 5;
    private static final int MAX_VISION_BONUS_MULTIPLIER = 3;
    private static final int HEALTH_MULTIPLIER = 2;
    private static final int VISION_BONUS = 5;
    private static final String TAG_ASSIGN = "assign";
    private static final String TAG_RETRIEVE = "retrieve";
    private static final String TAG_PATROL = "patrol";
    private static final String TAG_PATROL_TARGETS = "patrol targets";
    private static final String TAG_TARGET = "target";
    private static final String TAG_GUARD = "guard";
    private boolean assignManually = false;
    private boolean retrieveOnLowHealth = false;
    private boolean patrolManually = false;
    private Task task = Task.GUARD;
    private BlockPos guardPos = this.getID();
    private GuardJob job = null;
    private ArrayList<BlockPos> patrolTargets = new ArrayList();
    private EntityPlayer followPlayer;

    public AbstractBuildingGuards(Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.BOW, 0, this.getMaxToolLevel()), 1);
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.doesItemServeAsWeapon(itemStack), 1);
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.CHEST, 1);
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.HEAD, 1);
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.LEGS, 1);
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.FEET, 1);
    }

    public GuardJob getJob() {
        return this.job;
    }

    public void setJob(GuardJob job) {
        this.job = job;
        this.markDirty();
    }

    public int getPatrolDistance() {
        return this.getBuildingLevel() * 40;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public BlockPos getPlayerToFollow() {
        if (this.task.equals((Object)Task.FOLLOW) && this.followPlayer != null) {
            return this.followPlayer.func_180425_c();
        }
        this.task = Task.GUARD;
        return this.getLocation();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        for (EntityCitizen citizen : this.getWorkerEntities()) {
            if (newLevel <= 3) continue;
            citizen.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SharedMonsterAttributes.field_111267_a.func_111110_b() + (double)this.getBonusHealth());
        }
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingGuard);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeGuardMax);
        }
    }

    public void setPlayerToFollow(EntityPlayer player) {
        this.followPlayer = player;
    }

    private int getBonusHealth() {
        if (this.getBuildingLevel() > 3) {
            return (this.getBuildingLevel() - 3) * 2;
        }
        return 0;
    }

    public void addPatrolTargets(BlockPos target) {
        this.patrolTargets.add(target);
        this.markDirty();
    }

    public void setGuardTarget(BlockPos target) {
        this.guardPos = target;
        this.markDirty();
    }

    public void resetPatrolTargets() {
        this.patrolTargets = new ArrayList();
        this.markDirty();
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.markDirty();
    }

    public EntityPlayer getPlayer() {
        return this.followPlayer;
    }

    @Nullable
    public BlockPos getNextPatrolTarget(BlockPos currentPatrolTarget) {
        if (this.patrolTargets == null || this.patrolTargets.isEmpty()) {
            return null;
        }
        if (currentPatrolTarget == null) {
            return this.patrolTargets.get(0);
        }
        if (this.patrolTargets.contains(currentPatrolTarget)) {
            int index = this.patrolTargets.indexOf(currentPatrolTarget) + 1;
            if (index >= this.patrolTargets.size()) {
                index = 0;
            }
            return this.patrolTargets.get(index);
        }
        return this.patrolTargets.get(0);
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobGuard(citizen);
    }

    @Override
    public void setWorker(CitizenData citizen) {
        if (citizen != null && citizen.getCitizenEntity() != null) {
            citizen.getCitizenEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SharedMonsterAttributes.field_111267_a.func_111110_b() + (double)this.getBonusHealth());
            citizen.getCitizenEntity().func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SharedMonsterAttributes.field_188791_g.func_111110_b() + (double)this.getDefenceBonus());
        }
        super.setWorker(citizen);
    }

    public abstract int getDefenceBonus();

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.task = Task.values()[compound.func_74762_e(TAG_TASK)];
        int jobId = compound.func_74762_e(TAG_JOB);
        this.job = jobId == -1 ? null : GuardJob.values()[jobId];
        this.assignManually = compound.func_74767_n(TAG_ASSIGN);
        this.retrieveOnLowHealth = compound.func_74767_n(TAG_RETRIEVE);
        this.patrolManually = compound.func_74767_n(TAG_PATROL);
        NBTTagList wayPointTagList = compound.func_150295_c(TAG_PATROL_TARGETS, 10);
        for (int i = 0; i < wayPointTagList.func_74745_c(); ++i) {
            NBTTagCompound blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.readFromNBT(blockAtPos, TAG_TARGET);
            this.patrolTargets.add(pos);
        }
        this.guardPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(TAG_GUARD));
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a(TAG_TASK, this.task.ordinal());
        compound.func_74768_a(TAG_JOB, this.job == null ? -1 : this.job.ordinal());
        compound.func_74757_a(TAG_ASSIGN, this.assignManually);
        compound.func_74757_a(TAG_RETRIEVE, this.retrieveOnLowHealth);
        compound.func_74757_a(TAG_PATROL, this.patrolManually);
        NBTTagList wayPointTagList = new NBTTagList();
        for (BlockPos pos : this.patrolTargets) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, TAG_TARGET, pos);
            wayPointTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a(TAG_PATROL_TARGETS, (NBTBase)wayPointTagList);
        compound.func_74782_a(TAG_GUARD, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.guardPos));
    }

    @Override
    @NotNull
    public String getJobName() {
        return GUARD_TOWER;
    }

    @Override
    public void removeCitizen(CitizenData citizen) {
        if (citizen != null && citizen.getCitizenEntity() != null) {
            citizen.getCitizenEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SharedMonsterAttributes.field_111267_a.func_111110_b());
            citizen.getCitizenEntity().func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SharedMonsterAttributes.field_188791_g.func_111110_b());
        }
        super.removeCitizen(citizen);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.assignManually);
        buf.writeBoolean(this.retrieveOnLowHealth);
        buf.writeBoolean(this.patrolManually);
        buf.writeInt(this.task.ordinal());
        buf.writeInt(this.job == null ? -1 : this.job.ordinal());
        buf.writeInt(this.patrolTargets.size());
        for (BlockPos pos : this.patrolTargets) {
            BlockPosUtil.writeToByteBuf(buf, pos);
        }
        BlockPosUtil.writeToByteBuf(buf, this.guardPos);
    }

    public abstract int getOffenceBonus();

    public int getBonusVision() {
        if (this.getBuildingLevel() <= 3) {
            return this.getBuildingLevel() * 5;
        }
        return 15;
    }

    public boolean shallRetrieveOnLowHealth() {
        return this.retrieveOnLowHealth;
    }

    public void setRetrieveOnLowHealth(boolean retrieveOnLowHealth) {
        this.retrieveOnLowHealth = retrieveOnLowHealth;
        this.markDirty();
    }

    public boolean shallPatrolManually() {
        return this.patrolManually;
    }

    public void setPatrolManually(boolean patrolManually) {
        this.patrolManually = patrolManually;
        this.markDirty();
    }

    public BlockPos getGuardPos() {
        return this.guardPos;
    }

    public void setAssignManually(boolean assignManually) {
        this.assignManually = assignManually;
        this.markDirty();
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public boolean assignManually = false;
        public boolean retrieveOnLowHealth = false;
        public boolean patrolManually = false;
        public Task task = Task.GUARD;
        public BlockPos guardPos = this.getID();
        public GuardJob job = null;
        public List<BlockPos> patrolTargets = new ArrayList<BlockPos>();

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutGuardTower(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.assignManually = buf.readBoolean();
            this.retrieveOnLowHealth = buf.readBoolean();
            this.patrolManually = buf.readBoolean();
            this.task = Task.values()[buf.readInt()];
            int jobId = buf.readInt();
            this.job = jobId == -1 ? null : GuardJob.values()[jobId];
            int size = buf.readInt();
            this.patrolTargets = new ArrayList<BlockPos>();
            for (int i = 0; i < size; ++i) {
                this.patrolTargets.add(BlockPosUtil.readFromByteBuf(buf));
            }
            this.guardPos = BlockPosUtil.readFromByteBuf(buf);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            if (GuardJob.KNIGHT.equals((Object)this.job)) {
                return AbstractBuildingWorker.Skill.STRENGTH;
            }
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            if (GuardJob.KNIGHT.equals((Object)this.job)) {
                return AbstractBuildingWorker.Skill.ENDURANCE;
            }
            return AbstractBuildingWorker.Skill.STRENGTH;
        }
    }

    public static enum Task {
        FOLLOW,
        GUARD,
        PATROL;

    }

    public static enum GuardJob {
        KNIGHT,
        RANGER;

    }
}

