/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverProvider;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.blocks.BlockHutBaker;
import com.minecolonies.coremod.blocks.BlockHutBarracks;
import com.minecolonies.coremod.blocks.BlockHutBarracksTower;
import com.minecolonies.coremod.blocks.BlockHutBlacksmith;
import com.minecolonies.coremod.blocks.BlockHutBuilder;
import com.minecolonies.coremod.blocks.BlockHutChickenHerder;
import com.minecolonies.coremod.blocks.BlockHutCitizen;
import com.minecolonies.coremod.blocks.BlockHutCook;
import com.minecolonies.coremod.blocks.BlockHutCowboy;
import com.minecolonies.coremod.blocks.BlockHutDeliveryman;
import com.minecolonies.coremod.blocks.BlockHutFarmer;
import com.minecolonies.coremod.blocks.BlockHutFisherman;
import com.minecolonies.coremod.blocks.BlockHutGuardTower;
import com.minecolonies.coremod.blocks.BlockHutLumberjack;
import com.minecolonies.coremod.blocks.BlockHutMiner;
import com.minecolonies.coremod.blocks.BlockHutShepherd;
import com.minecolonies.coremod.blocks.BlockHutSmeltery;
import com.minecolonies.coremod.blocks.BlockHutStonemason;
import com.minecolonies.coremod.blocks.BlockHutSwineHerder;
import com.minecolonies.coremod.blocks.BlockHutTownHall;
import com.minecolonies.coremod.blocks.BlockHutWareHouse;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.BuildingBaker;
import com.minecolonies.coremod.colony.buildings.BuildingBarracks;
import com.minecolonies.coremod.colony.buildings.BuildingBarracksTower;
import com.minecolonies.coremod.colony.buildings.BuildingBlacksmith;
import com.minecolonies.coremod.colony.buildings.BuildingBuilder;
import com.minecolonies.coremod.colony.buildings.BuildingChickenHerder;
import com.minecolonies.coremod.colony.buildings.BuildingCook;
import com.minecolonies.coremod.colony.buildings.BuildingCowboy;
import com.minecolonies.coremod.colony.buildings.BuildingDeliveryman;
import com.minecolonies.coremod.colony.buildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.BuildingFisherman;
import com.minecolonies.coremod.colony.buildings.BuildingGuardTower;
import com.minecolonies.coremod.colony.buildings.BuildingHome;
import com.minecolonies.coremod.colony.buildings.BuildingLumberjack;
import com.minecolonies.coremod.colony.buildings.BuildingMiner;
import com.minecolonies.coremod.colony.buildings.BuildingShepherd;
import com.minecolonies.coremod.colony.buildings.BuildingSmeltery;
import com.minecolonies.coremod.colony.buildings.BuildingStonemason;
import com.minecolonies.coremod.colony.buildings.BuildingSwineHerder;
import com.minecolonies.coremod.colony.buildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.views.BuildingBuilderView;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.inventory.api.CombinedItemHandler;
import com.minecolonies.coremod.tileentities.TileEntityColonyBuilding;
import com.minecolonies.coremod.util.BuildingUtils;
import com.minecolonies.coremod.util.ColonyUtils;
import com.minecolonies.coremod.util.StructureWrapper;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilding
implements IRequestResolverProvider,
IRequester,
ICapabilityProvider {
    protected static final int CONST_DEFAULT_MAX_BUILDING_LEVEL = 5;
    public static final int NO_WORK_ORDER = 0;
    private static final int MAX_PRIO = 10;
    @NotNull
    private static final Map<String, Class<?>> nameToClassMap = new TreeMap();
    @NotNull
    private static final Map<Class<?>, String> classToNameMap = new HashMap();
    @NotNull
    private static final Map<Class<?>, Class<?>> blockClassToBuildingClassMap = new HashMap();
    @NotNull
    private static final Map<Integer, Class<?>> classNameHashToViewClassMap = new HashMap();
    protected final Map<Predicate<ItemStack>, Integer> keepX = new HashMap<Predicate<ItemStack>, Integer>();
    private final List<BlockPos> containerList = new ArrayList<BlockPos>();
    private final BlockPos location;
    @NotNull
    private final Colony colony;
    @NotNull
    private final Map<TypeToken, Collection<IToken<?>>> openRequests = new HashMap();
    private final HashMap<Integer, Collection<IToken<?>>> citizensByRequests = new HashMap();
    private final HashMap<Integer, Collection<IToken<?>>> citizensByCompletedRequests = new HashMap();
    private final HashMap<IToken<?>, Integer> requestsByCitizen = new HashMap();
    private IRequester requester;
    private TileEntityColonyBuilding tileEntity;
    private int buildingLevel = 0;
    private int rotation = 0;
    private boolean isMirrored = false;
    private String style = "wooden";
    private boolean dirty = false;
    private int cornerX1;
    private int cornerX2;
    private int cornerZ1;
    private int cornerZ2;
    private int pickUpPriority = 1;
    private boolean beingGathered = false;
    private int height;

    protected AbstractBuilding(@NotNull Colony colony, BlockPos pos) {
        this.location = pos;
        this.colony = colony;
        this.requester = (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
    }

    private static void addMapping(String name, @NotNull Class<? extends AbstractBuilding> buildingClass, @NotNull Class<? extends AbstractBuildingView> viewClass, @NotNull Class<? extends AbstractBlockHut<?>> parentBlock) {
        int buildingHashCode = buildingClass.getName().hashCode();
        if (nameToClassMap.containsKey(name) || classNameHashToViewClassMap.containsKey(buildingHashCode)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding AbstractBuilding class mapping");
        }
        try {
            if (buildingClass.getDeclaredConstructor(Colony.class, BlockPos.class) != null) {
                nameToClassMap.put(name, buildingClass);
                classToNameMap.put(buildingClass, name);
                classNameHashToViewClassMap.put(buildingHashCode, viewClass);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding AbstractBuilding class mapping", exception);
        }
        if (blockClassToBuildingClassMap.containsKey(parentBlock)) {
            throw new IllegalArgumentException("AbstractBuilding type '" + name + "' uses TileEntity '" + parentBlock.getClass().getName() + "' which is already in use.");
        }
        blockClassToBuildingClassMap.put(parentBlock, buildingClass);
    }

    @Nullable
    public static AbstractBuilding createFromNBT(Colony colony, @NotNull NBTTagCompound compound) {
        AbstractBuilding building = null;
        Class<?> oclass = null;
        try {
            oclass = nameToClassMap.get(compound.func_74779_i("type"));
            if (oclass != null) {
                BlockPos pos = BlockPosUtil.readFromNBT(compound, "location");
                Constructor<?> constructor = oclass.getDeclaredConstructor(Colony.class, BlockPos.class);
                building = (AbstractBuilding)constructor.newInstance(colony, pos);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error((Object)exception);
        }
        if (building == null) {
            Log.getLogger().warn(String.format("Unknown Building type '%s' or missing constructor of proper format.", compound.func_74779_i("type")));
            return null;
        }
        try {
            building.readFromNBT(compound);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A Building %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.func_74779_i("type"), oclass.getName()), (Throwable)ex);
            building = null;
        }
        return building;
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        StructureName newStructureName;
        this.buildingLevel = compound.func_74762_e("level");
        this.rotation = compound.func_74762_e("rotation");
        this.style = compound.func_74779_i("style");
        String md5 = compound.func_74779_i("schematicMD5");
        int testLevel = this.buildingLevel == 0 ? 1 : this.buildingLevel;
        StructureName sn = new StructureName("schematics", this.style, this.getSchematicName() + testLevel);
        if (!Structures.hasMD5(sn) && (newStructureName = Structures.getStructureNameByMD5(md5)) != null && newStructureName.getPrefix().equals(sn.getPrefix()) && newStructureName.getSchematic().equals(sn.getSchematic())) {
            this.style = newStructureName.getStyle();
            Log.getLogger().warn("AbstractBuilding.readFromNBT: " + sn + " have been moved to " + newStructureName);
        }
        if (this.style.isEmpty()) {
            Log.getLogger().warn("Loaded empty style, setting to wooden");
            this.style = "wooden";
        }
        NBTTagList containerTagList = compound.func_150295_c("Containers", 10);
        for (int i = 0; i < containerTagList.func_74745_c(); ++i) {
            NBTTagCompound containerCompound = containerTagList.func_150305_b(i);
            this.containerList.add(NBTUtil.func_186861_c((NBTTagCompound)containerCompound));
        }
        this.isMirrored = compound.func_74767_n("mirror");
        if (compound.func_74764_b("corner1")) {
            this.cornerX1 = compound.func_74762_e("corner1");
            this.cornerX2 = compound.func_74762_e("corner2");
            this.cornerZ1 = compound.func_74762_e("corner3");
            this.cornerZ2 = compound.func_74762_e("corner4");
        }
        if (compound.func_74764_b("height")) {
            this.height = compound.func_74762_e("height");
        }
        this.loadRequestSystemFromNBT(compound);
        if (compound.func_74764_b("prio")) {
            this.pickUpPriority = compound.func_74762_e("prio");
        }
    }

    public abstract String getSchematicName();

    private void loadRequestSystemFromNBT(NBTTagCompound compound) {
        this.requester = compound.func_74764_b("Requestor") ? (IRequester)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("Requestor")) : (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        this.openRequests.clear();
        if (compound.func_74764_b("OpenRequests")) {
            NBTTagList requests = compound.func_150295_c("OpenRequests", 10);
            NBTUtils.streamCompound(requests).forEach(orc -> {
                Class<?> clazz;
                try {
                    clazz = Class.forName(orc.func_74779_i("Token"));
                }
                catch (ClassNotFoundException e) {
                    Log.getLogger().error("Missing request type from game: " + orc.func_74779_i("Token"), (Throwable)e);
                    return;
                }
                NBTTagList assigned = orc.func_150295_c("Assignments", 10);
                Collection tokens = NBTUtils.streamCompound(assigned).map(tc -> (IToken)StandardFactoryController.getInstance().deserialize((NBTTagCompound)tc)).collect(Collectors.toList());
                this.openRequests.put(TypeToken.of(clazz), tokens);
            });
        }
        this.citizensByRequests.clear();
        if (compound.func_74764_b("CitizenRequestAssignments")) {
            NBTTagList citizensByRequestList = compound.func_150295_c("CitizenRequestAssignments", 10);
            NBTUtils.streamCompound(citizensByRequestList).forEach(cbrc -> AbstractBuilding.processIntegerKeyTokenList(cbrc, this.citizensByRequests));
        }
        this.citizensByCompletedRequests.clear();
        if (compound.func_74764_b("CitizenRequestCompletedAssignments")) {
            NBTTagList citizensByCompletedRequestList = compound.func_150295_c("CitizenRequestCompletedAssignments", 10);
            NBTUtils.streamCompound(citizensByCompletedRequestList).forEach(cbrc -> AbstractBuilding.processIntegerKeyTokenList(cbrc, this.citizensByCompletedRequests));
        }
        this.requestsByCitizen.clear();
        this.citizensByRequests.keySet().forEach(citizen -> this.citizensByRequests.get(citizen).forEach(requestToken -> this.requestsByCitizen.put((IToken<?>)requestToken, (Integer)citizen)));
    }

    public static void processIntegerKeyTokenList(NBTTagCompound compound, Map<Integer, Collection<IToken<?>>> outputMap) {
        Integer key = compound.func_74762_e("Token");
        NBTTagList assignments = compound.func_150295_c("Assignments", 10);
        Collection tokens = NBTUtils.streamCompound(assignments).map(tc -> (IToken)StandardFactoryController.getInstance().deserialize((NBTTagCompound)tc)).collect(Collectors.toList());
        outputMap.put(key, tokens);
    }

    @Nullable
    public static AbstractBuilding create(Colony colony, @NotNull TileEntityColonyBuilding parent) {
        AbstractBuilding building = null;
        try {
            Class<?> oclass = blockClassToBuildingClassMap.get(parent.func_145838_q().getClass());
            if (oclass == null) {
                Log.getLogger().error(String.format("TileEntity %s does not have an associated Building.", ((Object)((Object)parent)).getClass().getName()));
                return null;
            }
            BlockPos loc = parent.getPosition();
            Constructor<?> constructor = oclass.getDeclaredConstructor(Colony.class, BlockPos.class);
            building = (AbstractBuilding)constructor.newInstance(colony, loc);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error(String.format("Unknown Building type '%s' or missing constructor of proper format.", ((Object)((Object)parent)).getClass().getName()), (Throwable)exception);
        }
        if (building != null && parent.func_145831_w() != null) {
            WorkOrderBuild workOrder = new WorkOrderBuild(building, 1);
            StructureWrapper wrapper = new StructureWrapper(parent.func_145831_w(), workOrder.getStructureName());
            Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(building.getLocation(), parent.func_145831_w(), wrapper, workOrder.getRotation(parent.func_145831_w()), workOrder.isMirrored());
            building.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
            building.setHeight(wrapper.getHeight());
            ConstructionTapeHelper.placeConstructionTape(building.getLocation(), corners, parent.func_145831_w());
        }
        return building;
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public void setCorners(int x1, int x2, int z1, int z2) {
        this.cornerX1 = x1;
        this.cornerX2 = x2;
        this.cornerZ1 = z1;
        this.cornerZ2 = z2;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Nullable
    public static AbstractBuildingView createBuildingView(ColonyView colony, BlockPos id, @NotNull ByteBuf buf) {
        AbstractBuildingView view = null;
        Class<?> oclass = null;
        try {
            int typeHash = buf.readInt();
            oclass = classNameHashToViewClassMap.get(typeHash);
            if (oclass != null) {
                Constructor<?> constructor = oclass.getDeclaredConstructor(ColonyView.class, BlockPos.class);
                view = (AbstractBuildingView)constructor.newInstance(colony, id);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            Log.getLogger().error((Object)exception);
        }
        if (view == null) {
            Log.getLogger().warn("Unknown AbstractBuilding type, missing View subclass, or missing constructor of proper format.");
            return null;
        }
        try {
            view.deserialize(buf);
        }
        catch (IndexOutOfBoundsException ex) {
            Log.getLogger().error(String.format("A AbstractBuilding View (%s) has thrown an exception during deserializing, its state cannot be restored. Report this to the mod author", oclass.getName()), (Throwable)ex);
            return null;
        }
        return view;
    }

    public void onWakeUp() {
    }

    public boolean isMatchingBlock(@NotNull Block block) {
        Class<?> c = blockClassToBuildingClassMap.get(block.getClass());
        return this.getClass().equals(c);
    }

    public void writeToNBT(@NotNull NBTTagCompound compound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        compound.func_74778_a("type", s);
        BlockPosUtil.writeToNBT(compound, "location", this.location);
        StructureName structureName = new StructureName("schematics", this.style, this.getSchematicName() + this.buildingLevel);
        if (Structures.hasMD5(structureName)) {
            compound.func_74778_a("schematicMD5", Structures.getMD5(structureName.toString()));
        }
        compound.func_74768_a("level", this.buildingLevel);
        compound.func_74768_a("rotation", this.rotation);
        compound.func_74778_a("style", this.style);
        NBTTagList containerTagList = new NBTTagList();
        for (BlockPos pos : this.containerList) {
            containerTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a("Containers", (NBTBase)containerTagList);
        compound.func_74757_a("mirror", this.isMirrored);
        compound.func_74768_a("corner1", this.cornerX1);
        compound.func_74768_a("corner2", this.cornerX2);
        compound.func_74768_a("corner3", this.cornerZ1);
        compound.func_74768_a("corner4", this.cornerZ2);
        compound.func_74768_a("height", this.height);
        this.writeRequestSystemToNBT(compound);
        compound.func_74768_a("prio", this.pickUpPriority);
    }

    private void writeRequestSystemToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Requestor", (NBTBase)StandardFactoryController.getInstance().serialize(this.requester));
        compound.func_74782_a("OpenRequests", (NBTBase)this.openRequests.keySet().stream().map(clazz -> {
            NBTTagCompound requestTypeCompound = new NBTTagCompound();
            requestTypeCompound.func_74778_a("Token", clazz.getRawType().getName());
            requestTypeCompound.func_74782_a("Assignments", (NBTBase)this.openRequests.get(clazz).stream().map(token -> StandardFactoryController.getInstance().serialize(token)).collect(NBTUtils.toNBTTagList()));
            return requestTypeCompound;
        }).collect(NBTUtils.toNBTTagList()));
        compound.func_74782_a("CitizenRequestAssignments", (NBTBase)AbstractBuilding.writeIntegerKeyTokenListToNBT(this.citizensByRequests));
        compound.func_74782_a("CitizenRequestCompletedAssignments", (NBTBase)AbstractBuilding.writeIntegerKeyTokenListToNBT(this.citizensByCompletedRequests));
    }

    private static NBTTagList writeIntegerKeyTokenListToNBT(Map<Integer, Collection<IToken<?>>> input) {
        return input.keySet().stream().map(key -> {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Token", key.intValue());
            compound.func_74782_a("Assignments", (NBTBase)((Collection)input.get(key)).stream().map(token -> StandardFactoryController.getInstance().serialize(token)).collect(NBTUtils.toNBTTagList()));
            return compound;
        }).collect(NBTUtils.toNBTTagList());
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void clearDirty() {
        this.dirty = false;
    }

    public final void destroy() {
        this.onDestroyed();
        this.colony.getBuildingManager().removeBuilding(this, this.colony.getPackageManager().getSubscribers());
    }

    public void onDestroyed() {
        TileEntityColonyBuilding tileEntityNew = this.getTileEntity();
        World world = this.colony.getWorld();
        Block block = world.func_180495_p(this.location).func_177230_c();
        if (tileEntityNew != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)this.location, (IInventory)tileEntityNew);
            world.func_175666_e(this.location, block);
        }
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), world);
    }

    public TileEntityColonyBuilding getTileEntity() {
        TileEntity te;
        if ((this.tileEntity == null || this.tileEntity.func_145837_r()) && this.colony != null && this.colony.getWorld() != null && this.getLocation() != null && this.colony.getWorld().func_180495_p(this.getLocation()) != null && this.colony.getWorld().func_180495_p(this.getLocation()).func_177230_c() instanceof AbstractBlockHut && (te = this.getColony().getWorld().func_175625_s(this.location)) instanceof TileEntityColonyBuilding) {
            this.tileEntity = (TileEntityColonyBuilding)te;
            if (this.tileEntity.getBuilding() == null) {
                this.tileEntity.setColony(this.colony);
                this.tileEntity.setBuilding(this);
            }
        }
        return this.tileEntity;
    }

    public Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> getCorners() {
        return new Tuple((Object)new Tuple((Object)this.cornerX1, (Object)this.cornerX2), (Object)new Tuple((Object)this.cornerZ1, (Object)this.cornerZ2));
    }

    @NotNull
    public Colony getColony() {
        return this.colony;
    }

    public void setTileEntity(TileEntityColonyBuilding te) {
        this.tileEntity = te;
    }

    public void deconstruct() {
        for (int x = this.cornerX1; x < this.cornerX2; ++x) {
            for (int z = this.cornerZ1; z < this.cornerZ2; ++z) {
                for (int y = this.getLocation().func_177956_o() - 1; y < this.getLocation().func_177956_o() + this.height; ++y) {
                    this.getColony().getWorld().func_175655_b(new BlockPos(x, y, z), false);
                }
            }
        }
    }

    public void removeCitizen(CitizenData citizen) {
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    public void requestUpgrade(EntityPlayer player) {
        if (this.buildingLevel < this.getMaxBuildingLevel()) {
            this.requestWorkOrder(this.buildingLevel + 1);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.worker.noUpgrade", new Object[0]));
        }
    }

    public abstract int getMaxBuildingLevel();

    protected void requestWorkOrder(int level) {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return;
        }
        this.colony.getWorkManager().addWorkOrder(new WorkOrderBuild(this, level));
        LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.workOrderAdded", new Object[0]);
        this.markDirty();
    }

    public BlockPos getID() {
        return this.location;
    }

    public final void markDirty() {
        this.dirty = true;
        if (this.colony != null) {
            this.colony.getBuildingManager().markBuildingsDirty();
        }
    }

    public boolean hasWorkOrder() {
        return this.getCurrentWorkOrderLevel() != 0;
    }

    private int getCurrentWorkOrderLevel() {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            return o.getUpgradeLevel();
        }
        return 0;
    }

    public void requestRepair() {
        if (this.buildingLevel > 0) {
            this.requestWorkOrder(this.buildingLevel);
        }
    }

    public void removeWorkOrder() {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getBuildingLocation().equals((Object)this.getID())) continue;
            this.colony.getWorkManager().removeWorkOrder(o.getID());
            this.markDirty();
            return;
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public int getHeight() {
        return this.height;
    }

    public void onUpgradeComplete(int newLevel) {
        WorkOrderBuild workOrder = new WorkOrderBuild(this, newLevel);
        StructureWrapper wrapper = new StructureWrapper(this.colony.getWorld(), workOrder.getStructureName());
        Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> corners = ColonyUtils.calculateCorners(this.getLocation(), this.colony.getWorld(), wrapper, workOrder.getRotation(this.colony.getWorld()), workOrder.isMirrored());
        this.height = wrapper.getHeight();
        this.setCorners((Integer)((Tuple)corners.func_76341_a()).func_76341_a(), (Integer)((Tuple)corners.func_76341_a()).func_76340_b(), (Integer)((Tuple)corners.func_76340_b()).func_76341_a(), (Integer)((Tuple)corners.func_76340_b()).func_76340_b());
    }

    public void serializeToView(@NotNull ByteBuf buf) {
        buf.writeInt(this.getClass().getName().hashCode());
        buf.writeInt(this.getBuildingLevel());
        buf.writeInt(this.getMaxBuildingLevel());
        buf.writeInt(this.getPickUpPriority());
        buf.writeInt(this.getCurrentWorkOrderLevel());
        NBTTagCompound requestSystemCompound = new NBTTagCompound();
        this.writeRequestSystemToNBT(requestSystemCompound);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)requestSystemCompound);
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    public void setBuildingLevel(int level) {
        if (level > this.getMaxBuildingLevel()) {
            return;
        }
        this.buildingLevel = level;
        this.markDirty();
        ColonyManager.markDirty();
    }

    public int getPickUpPriority() {
        return this.pickUpPriority;
    }

    public boolean isMirrored() {
        return this.isMirrored;
    }

    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof BlockContainer || block instanceof BlockMinecoloniesRack) {
            this.addContainerPosition(pos);
        }
    }

    public void addContainerPosition(@NotNull BlockPos pos) {
        if (!this.containerList.contains(pos)) {
            this.containerList.add(pos);
        }
    }

    public void removeContainerPosition(BlockPos pos) {
        this.containerList.remove(pos);
    }

    public List<BlockPos> getAdditionalCountainers() {
        return new ArrayList<BlockPos>(this.containerList);
    }

    public void alterPickUpPriority(int value) {
        this.pickUpPriority = this.pickUpPriority + value < 1 ? 1 : (this.pickUpPriority + value > 10 ? 10 : (this.pickUpPriority += value));
    }

    public boolean isBeingGathered() {
        return this.beingGathered;
    }

    public void setBeingGathered(boolean gathering) {
        this.beingGathered = gathering;
    }

    public AxisAlignedBB getTargetableArea(World world) {
        return BuildingUtils.getTargetAbleArea(world, this);
    }

    public int hashCode() {
        return (int)(31L * this.getID().func_177986_g());
    }

    public boolean equals(Object o) {
        return o instanceof AbstractBuilding && ((AbstractBuilding)o).getID().equals((Object)this.getID());
    }

    public ItemStack transferStack(@NotNull ItemStack stack, @NotNull World world) {
        if (this.tileEntity == null || InventoryUtils.isProviderFull((ICapabilityProvider)this.tileEntity)) {
            Iterator<BlockPos> posIterator = this.containerList.iterator();
            ItemStack resultStack = stack.func_77946_l();
            while (posIterator.hasNext() && !ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                BlockPos pos = posIterator.next();
                TileEntity tempTileEntity = world.func_175625_s(pos);
                if (!(tempTileEntity instanceof TileEntityChest) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                resultStack = InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)tempTileEntity, stack);
            }
            return resultStack;
        }
        return InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)this.tileEntity, stack);
    }

    public boolean buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept) {
        for (Map.Entry<Predicate<ItemStack>, Integer> entry : this.getRequiredItemsAndAmount().entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            ItemStorage kept = ItemStorage.getItemStackOfListMatchingPredicate(localAlreadyKept, entry.getKey());
            if (kept != null) {
                if (kept.getAmount() >= entry.getValue()) {
                    return false;
                }
                localAlreadyKept.remove(kept);
                kept.setAmount(kept.getAmount() + ItemStackUtils.getSize(stack));
                localAlreadyKept.add(kept);
                return true;
            }
            localAlreadyKept.add(new ItemStorage(stack));
            return true;
        }
        return false;
    }

    public Map<Predicate<ItemStack>, Integer> getRequiredItemsAndAmount() {
        return this.keepX;
    }

    @Nullable
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        if (this.tileEntity == null) {
            for (BlockPos pos : this.containerList) {
                TileEntity tempTileEntity = world.func_175625_s(pos);
                if (!(tempTileEntity instanceof TileEntityChest) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                return this.forceItemStackToProvider((ICapabilityProvider)tempTileEntity, stack);
            }
        } else {
            return this.forceItemStackToProvider((ICapabilityProvider)this.tileEntity, stack);
        }
        return stack;
    }

    @Nullable
    private ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack) {
        ArrayList localAlreadyKept = new ArrayList();
        return InventoryUtils.forceItemStackToProvider(provider, itemStack, stack -> EntityAIWorkDeliveryman.workerRequiresItem(this, stack, localAlreadyKept));
    }

    public void setMirror() {
        this.isMirrored = !this.isMirrored;
    }

    public <R extends IRequestable> IToken<?> createRequest(@NotNull CitizenData citizenData, @NotNull R requested) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        this.addRequestToMaps(citizenData.getId(), requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    private void addRequestToMaps(@NotNull Integer citizenId, @NotNull IToken<?> requestToken, @NotNull TypeToken<?> requested) {
        if (!this.openRequests.containsKey(requested)) {
            this.openRequests.put(requested, new ArrayList());
        }
        this.openRequests.get(requested).add(requestToken);
        this.requestsByCitizen.put(requestToken, citizenId);
        if (!this.citizensByRequests.containsKey(citizenId)) {
            this.citizensByRequests.put(citizenId, new ArrayList());
        }
        this.citizensByRequests.get(citizenId).add(requestToken);
    }

    public boolean hasWorkerOpenRequests(@NotNull CitizenData citizen) {
        return !this.getOpenRequests(citizen).isEmpty();
    }

    public ImmutableList<IRequest> getOpenRequests(@NotNull CitizenData data) {
        if (!this.citizensByRequests.containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.citizensByRequests.get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    public boolean hasWorkerOpenRequestsFiltered(@NotNull CitizenData citizen, @NotNull Predicate<IRequest> selectionPredicate) {
        return this.getOpenRequests(citizen).stream().anyMatch(selectionPredicate);
    }

    public <R> boolean hasWorkerOpenRequestsOfType(@NotNull CitizenData citizenData, TypeToken<R> requestType) {
        return !this.getOpenRequestsOfType(citizenData, requestType).isEmpty();
    }

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull CitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).iterator());
    }

    public boolean hasCitizenCompletedRequests(@NotNull CitizenData data) {
        return !this.getCompletedRequests(data).isEmpty();
    }

    public ImmutableList<IRequest> getCompletedRequests(@NotNull CitizenData data) {
        if (!this.citizensByCompletedRequests.containsKey(data.getId())) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.citizensByCompletedRequests.get(data.getId()).stream().map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfType(@NotNull CitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).iterator());
    }

    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfTypeFiltered(@NotNull CitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).filter(filter).iterator());
    }

    public void markRequestAsAccepted(@NotNull CitizenData data, @NotNull IToken<?> token) {
        if (!this.citizensByCompletedRequests.containsKey(data.getId()) || !this.citizensByCompletedRequests.get(data.getId()).contains(token)) {
            throw new IllegalArgumentException("The given token " + token + " is not known as a completed request waiting for acceptance by the citizen.");
        }
        this.citizensByCompletedRequests.get(data.getId()).remove(token);
        if (this.citizensByCompletedRequests.get(data.getId()).isEmpty()) {
            this.citizensByCompletedRequests.remove(data.getId());
        }
        this.getColony().getRequestManager().updateRequestState(token, RequestState.RECEIVED);
        this.markDirty();
    }

    public void cancelAllRequestsOfCitizen(@NotNull CitizenData data) {
        this.getOpenRequests(data).forEach(request -> {
            this.getColony().getRequestManager().updateRequestState((IToken<?>)request.getToken(), RequestState.CANCELLED);
            if (this.openRequests.containsKey(request.getRequest().getClass())) {
                if (this.openRequests.get(request.getRequest().getClass()).isEmpty()) {
                    this.openRequests.remove(request.getRequest().getClass());
                } else {
                    this.openRequests.get(request.getRequest().getClass()).remove(request.getToken());
                }
            }
            this.requestsByCitizen.remove(request.getToken());
        });
        this.getCompletedRequests(data).forEach(request -> this.getColony().getRequestManager().updateRequestState((IToken<?>)request.getToken(), RequestState.RECEIVED));
        if (this.citizensByRequests.containsKey(data.getId())) {
            this.citizensByRequests.remove(data.getId());
        }
        if (this.citizensByCompletedRequests.containsKey(data.getId())) {
            this.citizensByCompletedRequests.remove(data.getId());
        }
        this.markDirty();
    }

    public void overruleNextOpenRequestWithStack(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return;
        }
        for (int citizenId : this.citizensByRequests.keySet()) {
            IRequest target;
            CitizenData data = this.getColony().getCitizenManager().getCitizen(citizenId);
            if (data == null || (target = (IRequest)this.getOpenRequestsOfTypeFiltered(data, TypeToken.of(IDeliverable.class), request -> ((IDeliverable)request.getRequest()).matches(stack)).stream().findFirst().orElse(null)) == null) continue;
            this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getToken(), stack.func_77946_l());
            return;
        }
    }

    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull CitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> {
            Set<TypeToken> requestTypes = ReflectionUtils.getSuperClasses(request.getRequestType());
            return requestTypes.contains(requestType);
        }).map(request -> request).filter(filter).iterator());
    }

    public boolean overruleNextOpenRequestOfCitizenWithStack(@NotNull CitizenData citizenData, @NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        IRequest target = this.getOpenRequestsOfTypeFiltered(citizenData, TypeToken.of(IDeliverable.class), request -> ((IDeliverable)request.getRequest()).matches(stack)).stream().findFirst().orElse(null);
        if (target == null) {
            return false;
        }
        this.getColony().getRequestManager().overruleRequest((IToken<?>)target.getToken(), stack.func_77946_l());
        return true;
    }

    @Override
    public IToken<?> getRequesterId() {
        return this.getToken();
    }

    @Override
    public IToken<?> getToken() {
        return this.requester.getRequesterId();
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> getResolvers() {
        return ImmutableList.of((Object)new BuildingRequestResolver(this.getRequester().getRequesterLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
    }

    public IRequester getRequester() {
        return this.requester;
    }

    @Override
    @NotNull
    public ILocation getRequesterLocation() {
        return this.getRequester().getRequesterLocation();
    }

    @Override
    public void onRequestComplete(@NotNull IToken<?> token) {
        Integer citizenThatRequested = this.requestsByCitizen.remove(token);
        this.citizensByRequests.get(citizenThatRequested).remove(token);
        if (this.citizensByRequests.get(citizenThatRequested).isEmpty()) {
            this.citizensByRequests.remove(citizenThatRequested);
        }
        IRequest requestThatCompleted = this.getColony().getRequestManager().getRequestForToken(token);
        this.openRequests.get(TypeToken.of(requestThatCompleted.getRequest().getClass())).remove(token);
        if (this.openRequests.get(TypeToken.of(requestThatCompleted.getRequest().getClass())).isEmpty()) {
            this.openRequests.remove(TypeToken.of(requestThatCompleted.getRequest().getClass()));
        }
        if (!this.citizensByCompletedRequests.containsKey(citizenThatRequested)) {
            this.citizensByCompletedRequests.put(citizenThatRequested, new ArrayList());
        }
        this.citizensByCompletedRequests.get(citizenThatRequested).add(token);
        this.markDirty();
    }

    @Override
    public void onRequestCancelled(@NotNull IToken<?> token) {
        Integer citizenThatRequested = this.requestsByCitizen.remove(token);
        this.citizensByRequests.get(citizenThatRequested).remove(token);
        if (this.citizensByRequests.get(citizenThatRequested).isEmpty()) {
            this.citizensByRequests.remove(citizenThatRequested);
        }
        IRequest requestThatCompleted = this.getColony().getRequestManager().getRequestForToken(token);
        this.openRequests.get(TypeToken.of(requestThatCompleted.getRequest().getClass())).remove(token);
        if (this.openRequests.get(TypeToken.of(requestThatCompleted.getRequest().getClass())).isEmpty()) {
            this.openRequests.remove(TypeToken.of(requestThatCompleted.getRequest().getClass()));
        }
        if (this.getColony().getCitizenManager().getCitizen(citizenThatRequested) != null) {
            this.getColony().getCitizenManager().getCitizen(citizenThatRequested).onRequestCancelled(token);
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public ITextComponent getDisplayName(@NotNull IToken<?> token) {
        if (!this.requestsByCitizen.containsKey(token)) {
            return new TextComponentString("<UNKNOWN>");
        }
        Integer citizenData = this.requestsByCitizen.get(token);
        return new TextComponentString(this.getSchematicName() + " " + this.getColony().getCitizenManager().getCitizen(citizenData).getName());
    }

    public Optional<CitizenData> getCitizenForRequest(@NotNull IToken token) {
        if (!this.requestsByCitizen.containsKey(token) || this.getColony() == null) {
            return Optional.empty();
        }
        int citizenID = this.requestsByCitizen.get(token);
        return Optional.of(this.getColony().getCitizenManager().getCitizen(citizenID));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null) {
            HashSet<TileEntityColonyBuilding> providers = new HashSet<TileEntityColonyBuilding>();
            providers.add(this.getTileEntity());
            providers.addAll(this.getAdditionalCountainers().stream().map(arg_0 -> ((World)this.getTileEntity().func_145831_w()).func_175625_s(arg_0)).filter(entity -> !(entity instanceof TileEntityFurnace)).collect(Collectors.toSet()));
            providers.removeIf(Objects::isNull);
            Set<IItemHandlerModifiable> modifiables = providers.stream().flatMap(provider -> InventoryUtils.getItemHandlersFromProvider(provider).stream()).filter(handler -> handler instanceof IItemHandlerModifiable).map(handler -> (IItemHandlerModifiable)handler).collect(Collectors.toSet());
            return (T)new CombinedItemHandler(this.getSchematicName(), modifiables.toArray(new IItemHandlerModifiable[0]));
        }
        return null;
    }

    static {
        AbstractBuilding.addMapping("Baker", BuildingBaker.class, BuildingBaker.View.class, BlockHutBaker.class);
        AbstractBuilding.addMapping("Blacksmith", BuildingBlacksmith.class, BuildingBlacksmith.View.class, BlockHutBlacksmith.class);
        AbstractBuilding.addMapping("Builder", BuildingBuilder.class, BuildingBuilderView.class, BlockHutBuilder.class);
        AbstractBuilding.addMapping("Home", BuildingHome.class, BuildingHome.View.class, BlockHutCitizen.class);
        AbstractBuilding.addMapping("Farmer", BuildingFarmer.class, BuildingFarmer.View.class, BlockHutFarmer.class);
        AbstractBuilding.addMapping("Lumberjack", BuildingLumberjack.class, BuildingLumberjack.View.class, BlockHutLumberjack.class);
        AbstractBuilding.addMapping("Miner", BuildingMiner.class, BuildingMiner.View.class, BlockHutMiner.class);
        AbstractBuilding.addMapping("Stonemason", BuildingStonemason.class, BuildingStonemason.View.class, BlockHutStonemason.class);
        AbstractBuilding.addMapping("TownHall", BuildingTownHall.class, BuildingTownHall.View.class, BlockHutTownHall.class);
        AbstractBuilding.addMapping("Deliveryman", BuildingDeliveryman.class, BuildingDeliveryman.View.class, BlockHutDeliveryman.class);
        AbstractBuilding.addMapping("Fisherman", BuildingFisherman.class, BuildingFisherman.View.class, BlockHutFisherman.class);
        AbstractBuilding.addMapping("GuardTower", BuildingGuardTower.class, BuildingGuardTower.View.class, BlockHutGuardTower.class);
        AbstractBuilding.addMapping("WareHouse", BuildingWareHouse.class, BuildingWareHouse.View.class, BlockHutWareHouse.class);
        AbstractBuilding.addMapping("Cook", BuildingCook.class, BuildingCook.View.class, BlockHutCook.class);
        AbstractBuilding.addMapping("Barracks", BuildingBarracks.class, BuildingBarracks.View.class, BlockHutBarracks.class);
        AbstractBuilding.addMapping("BarracksTower", BuildingBarracksTower.class, BuildingBarracksTower.View.class, BlockHutBarracksTower.class);
        AbstractBuilding.addMapping("Shepherd", BuildingShepherd.class, BuildingShepherd.View.class, BlockHutShepherd.class);
        AbstractBuilding.addMapping("Cowboy", BuildingCowboy.class, BuildingCowboy.View.class, BlockHutCowboy.class);
        AbstractBuilding.addMapping("SwingHerder", BuildingSwineHerder.class, BuildingSwineHerder.View.class, BlockHutSwineHerder.class);
        AbstractBuilding.addMapping("ChickenHerder", BuildingChickenHerder.class, BuildingChickenHerder.View.class, BlockHutChickenHerder.class);
        AbstractBuilding.addMapping("Smeltery", BuildingSmeltery.class, BuildingSmeltery.View.class, BlockHutSmeltery.class);
    }
}

