/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.StructureName;
import com.minecolonies.coremod.colony.workorders.AbstractWorkOrder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.structures.helpers.Structure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public final class Structures {
    public static final String SCHEMATIC_EXTENSION = ".nbt";
    public static final String SCHEMATICS_PREFIX = "schematics";
    public static final String SCHEMATICS_CACHE = "cache";
    public static final String SCHEMATICS_SCAN = "scans";
    public static final String SCHEMATICS_ASSET_PATH = "/assets/minecolonies/";
    public static final String SCHEMATICS_SEPARATOR = "/";
    private static final int MAX_TOTAL_SIZE = Short.MAX_VALUE;
    @NotNull
    private static Map<String, Map<String, Map<String, String>>> schematicsMap = new HashMap<String, Map<String, Map<String, String>>>();
    @NotNull
    private static Map<String, String> md5Map = new HashMap<String, String>();
    private static boolean dirty = false;
    private static boolean allowPlayerSchematics = false;

    private Structures() {
    }

    public static void init() {
        Structures.loadStyleMaps();
    }

    private static void loadStyleMaps() {
        File cacheSchematicFolder;
        File schematicsFolder;
        if (!Configurations.Gameplay.ignoreSchematicsFromJar) {
            Structures.loadStyleMapsJar();
        }
        if ((schematicsFolder = MineColonies.proxy.getSchematicsFolder()) != null) {
            Log.getLogger().info("Load additionnal huts or decorations from " + schematicsFolder + SCHEMATICS_SEPARATOR + SCHEMATICS_PREFIX);
            Structures.checkDirectory(schematicsFolder.toPath().resolve(SCHEMATICS_PREFIX).toFile());
            Structures.loadSchematicsForPrefix(schematicsFolder.toPath(), SCHEMATICS_PREFIX);
        }
        if ((cacheSchematicFolder = Structure.getCachedSchematicsFolder()) != null) {
            Structures.checkDirectory(cacheSchematicFolder);
            Log.getLogger().info("Load cached schematic from " + cacheSchematicFolder + SCHEMATICS_SEPARATOR + SCHEMATICS_CACHE);
            Structures.checkDirectory(cacheSchematicFolder.toPath().resolve(SCHEMATICS_CACHE).toFile());
            Structures.loadSchematicsForPrefix(cacheSchematicFolder.toPath(), SCHEMATICS_CACHE);
        }
        if (md5Map.size() == 0) {
            Log.getLogger().error("Error loading StructureProxy directory. Things will break!");
        }
    }

    private static void loadStyleMapsJar() {
        URI uri = null;
        try {
            uri = ColonyManager.class.getResource(SCHEMATICS_ASSET_PATH).toURI();
        }
        catch (URISyntaxException e) {
            Log.getLogger().error("loadStyleMaps : ", (Throwable)e);
            return;
        }
        if ("jar".equals(uri.getScheme())) {
            try (FileSystem fileSystem = FileSystems.getFileSystem(uri);){
                Path basePath = fileSystem.getPath(SCHEMATICS_ASSET_PATH, new String[0]);
                Log.getLogger().info("Load huts or decorations from jar");
                Structures.loadSchematicsForPrefix(basePath, SCHEMATICS_PREFIX);
            }
            catch (IOException | FileSystemNotFoundException e1) {
                try (FileSystem fileSystem2 = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    Path basePath = fileSystem2.getPath(SCHEMATICS_ASSET_PATH, new String[0]);
                    Log.getLogger().info("Load huts or decorations from jar");
                    Structures.loadSchematicsForPrefix(basePath, SCHEMATICS_PREFIX);
                }
                catch (IOException e2) {
                    Log.getLogger().warn("loadStyleMaps: Could not load the schematics from the jar.", (Throwable)e2);
                }
            }
        } else {
            Path basePath = Paths.get(uri);
            Log.getLogger().info("Load huts or decorations from uri");
            Structures.loadSchematicsForPrefix(basePath, SCHEMATICS_PREFIX);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void loadScannedStyleMaps() {
        if (!allowPlayerSchematics && FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        schematicsMap.remove(SCHEMATICS_SCAN);
        File schematicsFolder = Structure.getClientSchematicsFolder();
        Structures.checkDirectory(schematicsFolder.toPath().resolve(SCHEMATICS_SCAN).toFile());
        Structures.loadSchematicsForPrefix(schematicsFolder.toPath(), SCHEMATICS_SCAN);
    }

    private static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }

    private static void loadSchematicsForPrefix(@NotNull Path basePath, @NotNull String prefix) {
        try (Stream<Path> walk = Files.walk(basePath.resolve(prefix), new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (!path.toString().endsWith(SCHEMATIC_EXTENSION)) continue;
                String relativePath = path.toString().substring(basePath.toString().length()).split("\\.nbt")[0];
                if (!SCHEMATICS_SEPARATOR.equals(path.getFileSystem().getSeparator())) {
                    relativePath = relativePath.replace(path.getFileSystem().getSeparator(), SCHEMATICS_SEPARATOR);
                }
                if (relativePath.startsWith(SCHEMATICS_SEPARATOR)) {
                    relativePath = relativePath.substring(1);
                }
                StructureName structureName = new StructureName(relativePath);
                String md5 = Structure.calculateMD5(Structure.getStream(relativePath));
                if (md5 == null) {
                    Log.getLogger().error("Structures: " + structureName + " with md5 null.");
                    continue;
                }
                if (!Structures.isSchematicSizeValid(structureName.toString())) continue;
                md5Map.put(structureName.toString(), md5);
                if (!MineColonies.isClient()) continue;
                Structures.addSchematic(structureName);
            }
        }
        catch (IOException e) {
            Log.getLogger().warn("loadSchematicsForPrefix: Could not load schematics from " + basePath.resolve(prefix), (Throwable)e);
        }
    }

    private static boolean isSchematicSizeValid(@NotNull String structureName) {
        int maxSize = 32763;
        byte[] data = Structure.getStreamAsByteArray(Structure.getStream(structureName));
        byte[] compressed = Structure.compress(data);
        if (compressed != null && compressed.length > 32763) {
            Log.getLogger().warn("Structure " + structureName + " is " + compressed.length + " bytes when compress, maximum allowed is " + 32763 + " bytes.");
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static void addSchematic(@NotNull StructureName structureName) {
        Map<String, Map<String, String>> sectionMap;
        if (structureName.getPrefix().equals(SCHEMATICS_CACHE)) {
            return;
        }
        if (!schematicsMap.containsKey(structureName.getSection())) {
            schematicsMap.put(structureName.getSection(), new HashMap());
        }
        if (!(sectionMap = schematicsMap.get(structureName.getSection())).containsKey(structureName.getStyle())) {
            sectionMap.put(structureName.getStyle(), new TreeMap());
        }
        Map<String, String> styleMap = sectionMap.get(structureName.getStyle());
        styleMap.put(structureName.getSchematic(), structureName.toString());
    }

    public static boolean isDirty() {
        return dirty;
    }

    public static void clearDirty() {
        dirty = false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPlayerSchematicsAllowed() {
        return allowPlayerSchematics;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setAllowPlayerSchematics(boolean allowed) {
        allowPlayerSchematics = allowed;
    }

    @SideOnly(value=Side.CLIENT)
    public static StructureName renameScannedStructure(@NotNull StructureName structureName, @NotNull String name) {
        if (!SCHEMATICS_SCAN.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Renamed failed: Invalid name " + structureName);
            return null;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Renamed failed: No MD5 hash found for " + structureName);
            return null;
        }
        StructureName newStructureName = new StructureName("scans/" + name);
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Renamed failed: File already exist " + newStructureName);
            return null;
        }
        File structureFile = Structure.getClientSchematicsFolder().toPath().resolve(structureName.toString() + SCHEMATIC_EXTENSION).toFile();
        File newStructureFile = Structure.getClientSchematicsFolder().toPath().resolve(newStructureName.toString() + SCHEMATIC_EXTENSION).toFile();
        Structures.checkDirectory(newStructureFile.getParentFile());
        if (structureFile.renameTo(newStructureFile)) {
            String md5 = Structures.getMD5(structureName.toString());
            md5Map.put(newStructureName.toString(), md5);
            md5Map.remove(structureName.toString());
            Log.getLogger().info("Structure " + structureName + " have been renamed " + newStructureName);
            return newStructureName;
        }
        Log.getLogger().warn("Failed to rename structure from " + structureName + " to " + newStructureName);
        Log.getLogger().warn("Failed to rename structure from " + structureFile + " to " + newStructureFile);
        return null;
    }

    public static boolean hasMD5(@NotNull StructureName structureName) {
        return Structures.hasMD5(structureName.toString());
    }

    public static String getMD5(@NotNull String structureName) {
        if (!md5Map.containsKey(structureName)) {
            return null;
        }
        return md5Map.get(structureName);
    }

    public static boolean hasMD5(@NotNull String structureName) {
        return md5Map.containsKey(structureName);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean deleteScannedStructure(@NotNull StructureName structureName) {
        if (!SCHEMATICS_SCAN.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Delete failed: Invalid name " + structureName);
            return false;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Delete failed: No MD5 hash found for " + structureName);
            return false;
        }
        File structureFile = Structure.getClientSchematicsFolder().toPath().resolve(structureName.toString() + SCHEMATIC_EXTENSION).toFile();
        if (structureFile.delete()) {
            md5Map.remove(structureName.toString());
            Log.getLogger().info("Structures: " + structureName + " deleted successfully");
            return true;
        }
        Log.getLogger().warn("Failed to delete structure " + structureName);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static List<String> getSections() {
        ArrayList<String> list = new ArrayList<String>(schematicsMap.keySet());
        Collections.sort(list);
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static List<String> getStylesFor(String section) {
        if (schematicsMap.containsKey(section)) {
            Map<String, Map<String, String>> sectionMap = schematicsMap.get(section);
            ArrayList<String> list = new ArrayList<String>(sectionMap.keySet());
            Collections.sort(list);
            return list;
        }
        return new ArrayList<String>();
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public static List<String> getSchematicsFor(String section, String style) {
        Map<String, Map<String, String>> sectionMap;
        if (schematicsMap.containsKey(section) && (sectionMap = schematicsMap.get(section)).containsKey(style)) {
            ArrayList<String> list = new ArrayList<String>(sectionMap.get(style).values());
            Collections.sort(list);
            return list;
        }
        return new ArrayList<String>();
    }

    public static StructureName getStructureNameByMD5(String md5) {
        if (md5 != null) {
            for (Map.Entry<String, String> md5Entry : md5Map.entrySet()) {
                if (!md5Entry.getValue().equals(md5)) continue;
                return new StructureName(md5Entry.getKey());
            }
        }
        return null;
    }

    public static Map<String, String> getMD5s() {
        return md5Map;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setMD5s(Map<String, String> md5s) {
        schematicsMap.entrySet().removeIf(entry -> !((String)entry.getKey()).equals(SCHEMATICS_SCAN));
        for (Map.Entry<String, String> md5 : md5s.entrySet()) {
            StructureName sn = new StructureName(md5.getKey());
            if (sn.getSection().equals(SCHEMATICS_SCAN)) continue;
            md5Map.put(md5.getKey(), md5.getValue());
            Structures.addSchematic(sn);
        }
    }

    public static boolean handleSaveSchematicMessage(byte[] bytes) {
        block16: {
            if (!Structures.canStoreNewSchematic()) {
                Log.getLogger().warn("Could not store schematic in cache");
                return false;
            }
            String md5 = Structure.calculateMD5(bytes);
            if (md5 != null) {
                Log.getLogger().info("Structures.handleSaveSchematicMessage: received new schematic md5:" + md5);
                File schematicsFolder = Structure.getCachedSchematicsFolder();
                File schematicFile = schematicsFolder.toPath().resolve("cache/" + md5 + SCHEMATIC_EXTENSION).toFile();
                Structures.checkDirectory(schematicFile.getParentFile());
                try (FileOutputStream outputstream = new FileOutputStream(schematicFile);){
                    ((OutputStream)outputstream).write(bytes);
                    Structures.addMD5ToCache(md5);
                    break block16;
                }
                catch (IOException e) {
                    Log.getLogger().warn("Exception while trying to save a schematic.", (Throwable)e);
                    return false;
                }
            }
            Log.getLogger().info("Structures.handleSaveSchematicMessage: Could not calculate the MD5 hash");
            return false;
        }
        ColonyManager.setSchematicDownloaded(true);
        return true;
    }

    private static boolean canStoreNewSchematic() {
        if (MineColonies.isClient()) {
            return true;
        }
        if (!Configurations.Gameplay.allowPlayerSchematics) {
            return false;
        }
        Set<String> md5Set = Structures.getCachedMD5s();
        if (md5Set.size() < Configurations.Gameplay.maxCachedSchematics) {
            return true;
        }
        int countInUseStructures = 0;
        for (Colony c : ColonyManager.getColonies()) {
            for (AbstractWorkOrder workOrder : c.getWorkManager().getWorkOrders().values()) {
                String schematicName;
                if (!(workOrder instanceof WorkOrderBuildDecoration) || !md5Set.contains(schematicName = ((WorkOrderBuildDecoration)workOrder).getStructureName())) continue;
                md5Set.remove(schematicName);
                ++countInUseStructures;
            }
        }
        Iterator<String> iterator = md5Set.iterator();
        while (iterator.hasNext() && md5Set.size() + countInUseStructures >= Configurations.Gameplay.maxCachedSchematics) {
            StructureName sn = new StructureName(iterator.next());
            if (!Structures.deleteCachedStructure(sn)) continue;
            iterator.remove();
        }
        return md5Set.size() + countInUseStructures < Configurations.Gameplay.maxCachedSchematics;
    }

    public static void addMD5ToCache(@NotNull String md5) {
        Structures.markDirty();
        md5Map.put("cache/" + md5, md5);
    }

    private static Set<String> getCachedMD5s() {
        HashSet<String> md5Set = new HashSet<String>();
        for (Map.Entry<String, String> md5 : md5Map.entrySet()) {
            StructureName sn = new StructureName(md5.getKey());
            if (!sn.getSection().equals(SCHEMATICS_CACHE)) continue;
            md5Set.add(md5.getKey());
        }
        return md5Set;
    }

    private static boolean deleteCachedStructure(@NotNull StructureName structureName) {
        if (!SCHEMATICS_CACHE.equals(structureName.getPrefix())) {
            Log.getLogger().warn("Delete failed: Invalid name " + structureName);
            return false;
        }
        if (!Structures.hasMD5(structureName)) {
            Log.getLogger().warn("Delete failed: No MD5 hash found for " + structureName);
            return false;
        }
        File structureFile = MineColonies.proxy.getSchematicsFolder().toPath().resolve(structureName.toString() + SCHEMATIC_EXTENSION).toFile();
        if (structureFile.delete()) {
            md5Map.remove(structureName.toString());
            return true;
        }
        Log.getLogger().warn("Failed to delete structure " + structureName);
        return false;
    }

    private static void markDirty() {
        dirty = true;
    }
}

