/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.io.Files;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.compatibility.CompatabilityManager;
import com.minecolonies.api.compatibility.ICompatabilityManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.blocks.AbstractBlockHut;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import com.minecolonies.coremod.colony.ColonyManagerWorldAccess;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.Structures;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.util.AchievementUtils;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServerMulti;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager {
    private static final String TAG_NEW_COLONIES = "amountOfColonies";
    public static final String FILENAME_MINECOLONIES_PATH = "minecolonies";
    private static final String FILENAME_MINECOLONIES = "colonies.dat";
    private static final String FILENAME_MINECOLONIES_BACKUP = "colonies-%s.zip";
    public static final String FILENAME_COLONY = "colony%d.dat";
    private static final DamageSource CONSOLE_DAMAGE_SOURCE = new DamageSource("Console");
    @NotNull
    private static final ColonyList<Colony> colonies = new ColonyList();
    @NotNull
    private static final Map<Integer, List<Colony>> coloniesByWorld = new HashMap<Integer, List<Colony>>();
    @NotNull
    private static final ColonyList<ColonyView> colonyViews = new ColonyList();
    private static final int BUFFER = 10;
    private static int numWorldsLoaded;
    private static boolean saveNeeded;
    private static boolean schematicDownloaded;
    private static volatile UUID serverUUID;
    private static final ICompatabilityManager compatabilityManager;

    private ColonyManager() {
    }

    @NotNull
    public static Colony createColony(@NotNull World w, BlockPos pos, @NotNull EntityPlayer player, @NotNull String style) {
        Colony colony = colonies.create(w, pos);
        colony.setStyle(style);
        ColonyManager.addColonyByWorld(colony);
        String colonyName = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.defaultName", player.getDisplayNameString());
        colony.setName(colonyName);
        colony.getPermissions().setPlayerRank(player.func_146103_bH().getId(), Rank.OWNER, w);
        colony.getStatsManager().triggerAchievement(ModAchievements.achievementGetSupply);
        colony.getStatsManager().triggerAchievement(ModAchievements.achievementTownhall);
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.func_70005_c_()));
        ColonyManager.markDirty();
        return colony;
    }

    private static void addColonyByWorld(Colony colony) {
        if (colony.getDimension() >= 0) {
            coloniesByWorld.computeIfAbsent(colony.getDimension(), ArrayList::new).add(colony);
        }
    }

    public static void markDirty() {
        saveNeeded = true;
    }

    public static void deleteColony(int id, boolean canDestroy) {
        try {
            Colony colony = ColonyManager.getColony(id);
            HashSet<World> colonyWorlds = new HashSet<World>();
            Log.getLogger().info("Removing citizens for " + id);
            for (CitizenData citizenData : new ArrayList<CitizenData>(colony.getCitizenManager().getCitizens())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                EntityCitizen entityCitizen = citizenData.getCitizenEntity();
                if (entityCitizen == null) continue;
                World world = entityCitizen.func_130014_f_();
                citizenData.getCitizenEntity().func_70645_a(CONSOLE_DAMAGE_SOURCE);
                colonyWorlds.add(world);
            }
            if (canDestroy) {
                Log.getLogger().info("Removing buildings for " + id);
                for (AbstractBuilding building : new ArrayList<AbstractBuilding>(colony.getBuildingManager().getBuildings().values())) {
                    BlockPos location = building.getLocation();
                    Log.getLogger().info("Delete Building at " + location);
                    building.deconstruct();
                    building.destroy();
                    for (World world : colonyWorlds) {
                        if (!(world.func_180495_p(location).func_177230_c() instanceof AbstractBlockHut)) continue;
                        Log.getLogger().info("Found Block, deleting " + world.func_180495_p(location).func_177230_c());
                        world.func_175698_g(location);
                    }
                }
            }
            MinecraftForge.EVENT_BUS.unregister((Object)colony.getEventHandler());
            Log.getLogger().info("Deleting colony: " + colony.getID());
            colonies.remove(id);
            coloniesByWorld.get(colony.getDimension()).remove(colony);
            Log.getLogger().info("Done with " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        File file = new File(saveDir, String.format(FILENAME_COLONY, id));
        file.delete();
        ColonyManager.markDirty();
    }

    public static Colony getColony(int id) {
        return colonies.get(id);
    }

    public static void syncAllColoniesAchievements() {
        colonies.forEach(AchievementUtils::syncAchievements);
    }

    public static AbstractBuilding getBuilding(@NotNull World w, @NotNull BlockPos pos) {
        AbstractBuilding building;
        Colony colony = ColonyManager.getColony(w, pos);
        if (colony != null && (building = colony.getBuildingManager().getBuilding(pos)) != null) {
            return building;
        }
        for (Colony otherColony : ColonyManager.getColonies(w)) {
            AbstractBuilding building2 = otherColony.getBuildingManager().getBuilding(pos);
            if (building2 == null) continue;
            return building2;
        }
        return null;
    }

    public static Colony getColony(@NotNull World w, @NotNull BlockPos pos) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.field_73011_w.getDimension());
        if (coloniesInWorld == null) {
            return null;
        }
        for (Colony c : coloniesInWorld) {
            if (!c.isCoordInColony(w, pos)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    public static List<Colony> getColonies(@NotNull World w) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.field_73011_w.getDimension());
        if (coloniesInWorld == null) {
            return Collections.emptyList();
        }
        return coloniesInWorld;
    }

    @NotNull
    public static List<Colony> getColonies() {
        return colonies.getCopyAsList();
    }

    @NotNull
    public static List<Colony> getColoniesAbandonedSince(int abandonedSince) {
        ArrayList<Colony> sortedList = new ArrayList<Colony>();
        for (Colony colony : colonies.getCopyAsList()) {
            if (colony.getLastContactInHours() < abandonedSince) continue;
            sortedList.add(colony);
        }
        return sortedList;
    }

    public static AbstractBuildingView getBuildingView(BlockPos pos) {
        for (ColonyView colony : colonyViews) {
            AbstractBuildingView building = colony.getBuilding(pos);
            if (building == null) continue;
            return building;
        }
        return null;
    }

    @Nullable
    public static IColony getIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getColonyView(w, pos) : ColonyManager.getColony(w, pos);
    }

    private static ColonyView getColonyView(@NotNull World w, @NotNull BlockPos pos) {
        for (ColonyView c : colonyViews) {
            if (!c.isCoordInColony(w, pos)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static IColony getClosestIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getClosestColonyView(w, pos) : ColonyManager.getClosestColony(w, pos);
    }

    @Nullable
    public static ColonyView getClosestColonyView(@NotNull World w, @NotNull BlockPos pos) {
        ColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (ColonyView c : colonyViews) {
            long dist;
            if (c.getDimension() != w.field_73011_w.getDimension() || c.getCenter() == null || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    public static Colony getClosestColony(@NotNull World w, @NotNull BlockPos pos) {
        Colony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (Colony c : ColonyManager.getColonies(w)) {
            long dist;
            if (c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, @NotNull EntityPlayer owner) {
        return ColonyManager.getIColonyByOwner(w, w.field_72995_K ? owner.func_110124_au() : owner.func_146103_bH().getId());
    }

    @Nullable
    public static IColony getIColonyByOwner(@NotNull World w, UUID owner) {
        return w.field_72995_K ? ColonyManager.getColonyViewByOwner(owner) : ColonyManager.getColonyByOwner(owner);
    }

    private static IColony getColonyViewByOwner(UUID owner) {
        for (ColonyView c : colonyViews) {
            Player p = c.getPlayers().get(owner);
            if (p == null || !p.getRank().equals((Object)Rank.OWNER)) continue;
            return c;
        }
        return null;
    }

    @Nullable
    private static IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        return colonies.stream().filter(c -> owner.equals(c.getPermissions().getOwner())).findFirst().orElse(null);
    }

    public static int getMinimumDistanceBetweenTownHalls() {
        return 2 * Configurations.Gameplay.workingRangeTownHall + Configurations.Gameplay.townHallPadding;
    }

    public static void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        for (Colony c : colonies) {
            c.onServerTick(event);
        }
        if (saveNeeded) {
            ColonyManager.saveColonies();
        }
    }

    private static void saveColonies() {
        NBTTagCompound compound = new NBTTagCompound();
        ColonyManager.writeToNBT(compound);
        File file = ColonyManager.getSaveLocation();
        ColonyManager.saveNBTToPath(file, compound);
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        for (Colony colony : colonies) {
            ColonyManager.saveNBTToPath(new File(saveDir, String.format(FILENAME_COLONY, colony.getID())), colony.getColonyTag());
        }
        saveNeeded = false;
    }

    public static void writeToNBT(@NotNull NBTTagCompound compound) {
        if (serverUUID != null) {
            compound.func_186854_a("uuid", serverUUID);
        }
        NBTTagCompound compCompound = new NBTTagCompound();
        compatabilityManager.writeToNBT(compCompound);
        compound.func_74782_a("compatabilityManager", (NBTBase)compCompound);
        compound.func_74768_a(TAG_NEW_COLONIES, colonies.size());
    }

    @NotNull
    private static File getSaveLocation() {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        return new File(saveDir, FILENAME_MINECOLONIES);
    }

    public static void saveNBTToPath(@Nullable File file, @NotNull NBTTagCompound compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.func_74793_a((NBTTagCompound)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e == null && !colonyViews.isEmpty()) {
            colonyViews.clear();
        }
    }

    public static void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        ColonyManager.getColonies(event.world).forEach(c -> c.onWorldTick(event));
    }

    public static void onWorldLoad(@NotNull World world) {
        if (!world.field_72995_K && !(world instanceof WorldServerMulti)) {
            if (numWorldsLoaded == 0) {
                if (!ColonyManager.backupColonyData()) {
                    MineColonies.getLogger().error("Failed to save colonies.dat backup!");
                }
                Structures.init();
                File file = ColonyManager.getSaveLocation();
                NBTTagCompound data = ColonyManager.loadNBTFromPath(file);
                if (data != null) {
                    ColonyManager.readFromNBT(data, world);
                    if (data.func_74764_b(TAG_NEW_COLONIES)) {
                        int size = data.func_74762_e(TAG_NEW_COLONIES);
                        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
                        for (int colonyId = 0; colonyId <= size; ++colonyId) {
                            NBTTagCompound colonyData = ColonyManager.loadNBTFromPath(new File(saveDir, String.format(FILENAME_COLONY, colonyId)));
                            if (colonyData == null) continue;
                            Colony colony = Colony.loadColony(colonyData, world);
                            colonies.add(colony);
                            ColonyManager.addColonyByWorld(colony);
                        }
                    }
                    Log.getLogger().info(String.format("Loaded %d colonies", colonies.size()));
                }
                if (serverUUID == null) {
                    serverUUID = UUID.randomUUID();
                    Log.getLogger().info(String.format("New Server UUID %s", serverUUID));
                    ColonyManager.markDirty();
                } else {
                    Log.getLogger().info(String.format("Server UUID %s", serverUUID));
                }
            }
            ++numWorldsLoaded;
            for (Colony c : ColonyManager.getColonies(world)) {
                c.onWorldLoad(world);
            }
            world.func_72954_a((IWorldEventListener)new ColonyManagerWorldAccess());
        }
    }

    public static boolean backupColonyData() {
        if (numWorldsLoaded > 0 && saveNeeded) {
            ColonyManager.saveColonies();
        }
        try (FileOutputStream fos = new FileOutputStream(ColonyManager.getBackupSaveLocation(new Date()));){
            File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int i = 0; i < colonies.size() + 10; ++i) {
                File file = new File(saveDir, String.format(FILENAME_COLONY, i));
                if (!file.exists()) continue;
                ColonyManager.addToZipFile(String.format(FILENAME_COLONY, i), zos, saveDir);
            }
            ColonyManager.addToZipFile(ColonyManager.getSaveLocation().getName(), zos, saveDir);
            zos.close();
            fos.close();
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to backup colony data, please contact an administrator");
            return false;
        }
        return true;
    }

    public static void addToZipFile(String fileName, ZipOutputStream zos, File folder) {
        File file = new File(folder, fileName);
        try (FileInputStream fis = new FileInputStream(file);){
            zos.putNextEntry(new ZipEntry(fileName));
            Files.copy((File)file, (OutputStream)zos);
            fis.close();
        }
        catch (Exception e) {
            Log.getLogger().warn("Error packing " + fileName + " into the zip.");
        }
    }

    private static NBTTagCompound loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading ColonyManger", (Throwable)exception);
        }
        return null;
    }

    public static void readFromNBT(@NotNull NBTTagCompound compound, @NotNull World world) {
        if (!compound.func_74764_b(TAG_NEW_COLONIES)) {
            NBTTagList colonyTags = compound.func_150295_c("colonies", 10);
            for (int i = 0; i < colonyTags.func_74745_c(); ++i) {
                Colony colony = Colony.loadColony(colonyTags.func_150305_b(i), world);
                colonies.add(colony);
                ColonyManager.addColonyByWorld(colony);
            }
        }
        if (compound.func_186855_b("uuid")) {
            serverUUID = compound.func_186857_a("uuid");
        }
        if (compound.func_74764_b("compatabilityManager")) {
            compatabilityManager.readFromNBT(compound.func_74775_l("compatabilityManager"));
        }
        compatabilityManager.discover(world);
        Log.getLogger().info(String.format("Loaded %d colonies", colonies.size()));
    }

    @NotNull
    private static File getBackupSaveLocation(Date date) {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        return new File(saveDir, String.format(FILENAME_MINECOLONIES_BACKUP, new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(date)));
    }

    public static UUID getServerUUID() {
        return serverUUID;
    }

    public static void setServerUUID(UUID uuid) {
        serverUUID = uuid;
    }

    public static void onWorldUnload(@NotNull World world) {
        if (!world.field_72995_K && !(world instanceof WorldServerMulti)) {
            if (world.field_73011_w.getDimension() == 0) {
                ColonyManager.saveColonies();
            }
            for (Colony c : ColonyManager.getColonies(world)) {
                c.onWorldUnload(world);
            }
            if (--numWorldsLoaded == 0) {
                colonies.clear();
                coloniesByWorld.clear();
            }
        }
    }

    @Nullable
    public static IMessage handleColonyViewMessage(int colonyId, @NotNull ByteBuf colonyData, @NotNull World world, boolean isNewSubscription) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            colonyViews.add(view);
        }
        return view.handleColonyViewMessage(colonyData, world, isNewSubscription);
    }

    public static ColonyView getColonyView(int id) {
        return colonyViews.get(id);
    }

    public static IMessage handlePermissionsViewMessage(int colonyID, @NotNull ByteBuf data) {
        ColonyView view = ColonyManager.getColonyView(colonyID);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID));
            return null;
        }
        return view.handlePermissionsViewMessage(data);
    }

    public static IMessage handleColonyViewCitizensMessage(int colonyId, int citizenId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            return null;
        }
        return view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    public static IMessage handleColonyViewWorkOrderMessage(int colonyId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            return null;
        }
        return view.handleColonyViewWorkOrderMessage(buf);
    }

    public static IMessage handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
        return null;
    }

    public static IMessage handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyBuildingViewMessage(buildingId, buf);
        }
        Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId));
        return null;
    }

    public static IMessage handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
        return null;
    }

    public static IMessage handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
        return null;
    }

    public static boolean isSchematicDownloaded() {
        return schematicDownloaded;
    }

    public static void setSchematicDownloaded(boolean downloaded) {
        schematicDownloaded = downloaded;
    }

    public static boolean isCoordinateInAnyColony(@NotNull World world, BlockPos pos) {
        for (ColonyView c : colonyViews) {
            long dist;
            if (c.getDimension() != world.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= (long)(Configurations.Gameplay.workingRangeTownHall + Configurations.Gameplay.townHallPadding + 10)) continue;
            return true;
        }
        return false;
    }

    public static ICompatabilityManager getCompatabilityManager() {
        return compatabilityManager;
    }

    static {
        schematicDownloaded = false;
        serverUUID = null;
        compatabilityManager = new CompatabilityManager();
    }
}

