/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.WorkManager;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.managers.BarbarianManager;
import com.minecolonies.coremod.colony.managers.BuildingManager;
import com.minecolonies.coremod.colony.managers.CitizenManager;
import com.minecolonies.coremod.colony.managers.ColonyPackageManager;
import com.minecolonies.coremod.colony.managers.IBarbarianManager;
import com.minecolonies.coremod.colony.managers.IBuildingManager;
import com.minecolonies.coremod.colony.managers.ICitizenManager;
import com.minecolonies.coremod.colony.managers.IColonyPackageManager;
import com.minecolonies.coremod.colony.managers.IStatisticAchievementManager;
import com.minecolonies.coremod.colony.managers.StatisticAchievementManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.coremod.entity.ai.mobs.util.MobEventsUtils;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.coremod.permissions.ColonyPermissionEventHandler;
import com.minecolonies.coremod.util.ServerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colony
implements IColony {
    private String style = "wooden";
    private final int id;
    private final int dimensionId;
    private final Map<BlockPos, IBlockState> wayPoints = new HashMap<BlockPos, IBlockState>();
    private final WorkManager workManager = new WorkManager(this);
    private final IBuildingManager buildingManager = new BuildingManager(this);
    private final ICitizenManager citizenManager = new CitizenManager(this);
    private final IStatisticAchievementManager statsManager = new StatisticAchievementManager(this);
    private final IBarbarianManager barbarianManager = new BarbarianManager(this);
    private final IColonyPackageManager packageManager = new ColonyPackageManager(this);
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final ColonyPermissionEventHandler eventHandler;
    private boolean canColonyBeAutoDeleted = true;
    private boolean isDay = true;
    @Nullable
    private World world = null;
    private boolean manualHiring = false;
    private boolean manualHousing = false;
    private String name = "ERROR(Wasn't placed by player)";
    private BlockPos center;
    @NotNull
    private Permissions permissions;
    private double overallHappiness = 5.0;
    private IRequestManager requestManager;
    private NBTTagCompound colonyTag;
    private boolean isDirty = false;

    Colony(int id, @NotNull World w, BlockPos c) {
        this(id, w);
        this.center = c;
        this.world = w;
        this.permissions = new Permissions(this);
        this.requestManager = new StandardRequestManager(this);
    }

    protected Colony(int id, World world) {
        this.id = id;
        this.dimensionId = world.field_73011_w.getDimension();
        this.world = world;
        this.permissions = new Permissions(this);
        this.eventHandler = new ColonyPermissionEventHandler(this);
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        for (String s : Configurations.Gameplay.freeToInteractBlocks) {
            Block block = Block.func_149684_b((String)s);
            if (block == null) {
                BlockPos pos = BlockPosUtil.getBlockPosOfString(s);
                if (pos == null) continue;
                this.freePositions.add(pos);
                continue;
            }
            this.freeBlocks.add(block);
        }
    }

    @NotNull
    public static Colony loadColony(@NotNull NBTTagCompound compound, @NotNull World world) {
        int id = compound.func_74762_e("id");
        Colony c = new Colony(id, world);
        c.name = compound.func_74779_i("name");
        c.center = BlockPosUtil.readFromNBT(compound, "center");
        c.setRequestManager();
        c.readFromNBT(compound);
        return c;
    }

    private void setRequestManager() {
        this.requestManager = new StandardRequestManager(this);
    }

    private void readFromNBT(@NotNull NBTTagCompound compound) {
        this.manualHiring = compound.func_74767_n("manualHiring");
        this.permissions.loadPermissions(compound);
        if (compound.func_74764_b("citizenManager")) {
            this.citizenManager.readFromNBT(compound.func_74775_l("citizenManager"));
        } else {
            this.citizenManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("buildingManager")) {
            this.buildingManager.readFromNBT(compound.func_74775_l("buildingManager"));
        } else {
            this.buildingManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("statsManager")) {
            this.statsManager.readFromNBT(compound.func_74775_l("statsManager"));
        } else {
            this.statsManager.readFromNBT(compound);
        }
        this.workManager.readFromNBT(compound.func_74775_l("work"));
        NBTTagList wayPointTagList = compound.func_150295_c("waypoints", 10);
        for (int i = 0; i < wayPointTagList.func_74745_c(); ++i) {
            NBTTagCompound blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.readFromNBT(blockAtPos, "waypoints");
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)blockAtPos);
            this.wayPoints.put(pos, state);
        }
        NBTTagList freeBlockTagList = compound.func_150295_c("freeBlocks", 8);
        for (int i = 0; i < freeBlockTagList.func_74745_c(); ++i) {
            this.freeBlocks.add(Block.func_149684_b((String)freeBlockTagList.func_150307_f(i)));
        }
        NBTTagList freePositionTagList = compound.func_150295_c("freePositions", 10);
        for (int i = 0; i < freePositionTagList.func_74745_c(); ++i) {
            NBTTagCompound blockTag = freePositionTagList.func_150305_b(i);
            BlockPos block = BlockPosUtil.readFromNBT(blockTag, "freePositions");
            this.freePositions.add(block);
        }
        this.overallHappiness = compound.func_74769_h("happiness");
        this.packageManager.setLastContactInHours(compound.func_74762_e("abandoned"));
        this.manualHousing = compound.func_74767_n("manualHousing");
        if (compound.func_74764_b("requestManager")) {
            this.requestManager.deserializeNBT((NBTBase)compound.func_74775_l("requestManager"));
        }
        if (compound.func_74764_b("style")) {
            this.style = compound.func_74779_i("style");
        }
        if (compound.func_74764_b("raidable")) {
            this.barbarianManager.setCanHaveBarbEvents(compound.func_74767_n("raidable"));
        } else {
            this.barbarianManager.setCanHaveBarbEvents(true);
        }
        this.canColonyBeAutoDeleted = compound.func_74764_b("autoDelete") ? compound.func_74767_n("autoDelete") : true;
        this.colonyTag = compound;
    }

    public ColonyPermissionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    protected void writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a("id", this.id);
        compound.func_74768_a("dimension", this.dimensionId);
        compound.func_74778_a("name", this.name);
        BlockPosUtil.writeToNBT(compound, "center", this.center);
        compound.func_74757_a("manualHiring", this.manualHiring);
        this.permissions.savePermissions(compound);
        NBTTagCompound buildingCompound = new NBTTagCompound();
        this.buildingManager.writeToNBT(buildingCompound);
        compound.func_74782_a("buildingManager", (NBTBase)buildingCompound);
        NBTTagCompound citizenCompound = new NBTTagCompound();
        this.citizenManager.writeToNBT(citizenCompound);
        compound.func_74782_a("citizenManager", (NBTBase)citizenCompound);
        NBTTagCompound statsCompound = new NBTTagCompound();
        this.statsManager.writeToNBT(statsCompound);
        compound.func_74782_a("statsManager", (NBTBase)statsCompound);
        NBTTagCompound workManagerCompound = new NBTTagCompound();
        this.workManager.writeToNBT(workManagerCompound);
        compound.func_74782_a("work", (NBTBase)workManagerCompound);
        NBTTagList wayPointTagList = new NBTTagList();
        for (Map.Entry<BlockPos, IBlockState> entry : this.wayPoints.entrySet()) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, "waypoints", entry.getKey());
            NBTUtil.func_190009_a((NBTTagCompound)wayPointCompound, (IBlockState)entry.getValue());
            wayPointTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a("waypoints", (NBTBase)wayPointTagList);
        NBTTagList freeBlocksTagList = new NBTTagList();
        for (Block block : this.freeBlocks) {
            freeBlocksTagList.func_74742_a((NBTBase)new NBTTagString(block.getRegistryName().toString()));
        }
        compound.func_74782_a("freeBlocks", (NBTBase)freeBlocksTagList);
        NBTTagList nBTTagList = new NBTTagList();
        for (BlockPos pos : this.freePositions) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, "freePositions", pos);
            nBTTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a("freePositions", (NBTBase)nBTTagList);
        compound.func_74780_a("happiness", this.overallHappiness);
        compound.func_74768_a("abandoned", this.packageManager.getLastContactInHours());
        compound.func_74757_a("manualHousing", this.manualHousing);
        compound.func_74782_a("requestManager", this.getRequestManager().serializeNBT());
        compound.func_74778_a("style", this.style);
        compound.func_74757_a("raidable", this.barbarianManager.canHaveBarbEvents());
        compound.func_74757_a("autoDelete", this.canColonyBeAutoDeleted);
        this.colonyTag = compound;
    }

    public int getDimension() {
        return this.dimensionId;
    }

    public void onWorldLoad(@NotNull World w) {
        if (w.field_73011_w.getDimension() == this.dimensionId) {
            this.world = w;
        }
    }

    public void onWorldUnload(@NotNull World w) {
        if (!w.equals(this.world)) {
            return;
        }
        this.world = null;
    }

    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        this.buildingManager.tick(event);
        this.getRequestManager().func_73660_a();
        if (event.phase == TickEvent.Phase.END) {
            this.packageManager.updateSubscribers();
        }
    }

    @NotNull
    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public Set<BlockPos> getFreePositions() {
        return new HashSet<BlockPos>(this.freePositions);
    }

    public Set<Block> getFreeBlocks() {
        return new HashSet<Block>(this.freeBlocks);
    }

    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
        this.markDirty();
    }

    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
        this.markDirty();
    }

    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
        this.markDirty();
    }

    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
        this.markDirty();
    }

    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.world != this.getWorld()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.buildingManager.cleanUpBuildings(event);
            this.citizenManager.onWorldTick(event);
            if (Colony.shallUpdate(this.world, 20) && event.world.func_175659_aa() != EnumDifficulty.PEACEFUL && Configurations.Gameplay.doBarbariansSpawn && this.barbarianManager.canHaveBarbEvents()) {
                if (!this.world.func_73046_m().func_184103_al().func_181057_v().stream().filter(this.permissions::isSubscriber).collect(Collectors.toList()).isEmpty() && MobEventsUtils.isItTimeToRaid(event.world, this)) {
                    MobEventsUtils.barbarianEvent(event.world, this);
                }
            }
        }
        this.buildingManager.onWorldTick(event);
        if (this.isDay && !this.world.func_72935_r()) {
            this.isDay = false;
            this.citizenManager.checkCitizensForHappiness();
        } else if (!this.isDay && this.world.func_72935_r()) {
            this.isDay = true;
        }
        this.updateWayPoints();
        this.workManager.onWorldTick(event);
        if (this.isDirty && Colony.shallUpdate(this.world, 100)) {
            this.isDirty = false;
            File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
            ColonyManager.saveNBTToPath(new File(saveDir, String.format("colony%d.dat", this.getID())), this.getColonyTag());
        }
    }

    public static boolean shallUpdate(World world, int averageTicks) {
        return world.func_72820_D() % (long)(world.field_73012_v.nextInt(averageTicks * 2) + 1) == 0L;
    }

    public boolean areAllColonyChunksLoaded(@NotNull TickEvent.WorldTickEvent event) {
        int distanceFromCenter = Configurations.Gameplay.workingRangeTownHall + 48 + 15;
        for (int x = -distanceFromCenter; x <= distanceFromCenter; x += 16) {
            for (int z = -distanceFromCenter; z <= distanceFromCenter; z += 16) {
                if (event.world.func_175667_e(new BlockPos(this.getCenter().func_177958_n() + x, 1, this.getCenter().func_177952_p() + z))) continue;
                return false;
            }
        }
        return true;
    }

    private void updateWayPoints() {
        int stopAt;
        Object[] entries;
        Object obj;
        Random rand = new Random();
        if (rand.nextInt(100) <= 1 && this.wayPoints.size() > 0 && (obj = (entries = this.wayPoints.entrySet().toArray())[stopAt = rand.nextInt(entries.length)]) instanceof Map.Entry && ((Map.Entry)obj).getKey() instanceof BlockPos && ((Map.Entry)obj).getValue() instanceof IBlockState) {
            BlockPos key = (BlockPos)((Map.Entry)obj).getKey();
            IBlockState value = (IBlockState)((Map.Entry)obj).getValue();
            if (this.world != null && this.world.func_180495_p(key).func_177230_c() != value.func_177230_c()) {
                this.wayPoints.remove(key);
                this.markDirty();
            }
        }
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
        this.markDirty();
    }

    @Override
    @NotNull
    public Permissions getPermissions() {
        return this.permissions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCoordInColony(@NotNull World w, @NotNull BlockPos pos) {
        if (!w.equals(this.getWorld())) return false;
        BlockPos blockPos = new BlockPos(pos.func_177958_n(), this.center.func_177956_o(), pos.func_177952_p());
        if (!((double)BlockPosUtil.getDistanceSquared(this.center, blockPos) <= MathUtils.square(Configurations.Gameplay.workingRangeTownHall))) return false;
        return true;
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.buildingManager.hasTownHall();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.buildingManager.hasWarehouse();
    }

    @Override
    public int getLastContactInHours() {
        return this.packageManager.getLastContactInHours();
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public boolean hasWillRaidTonight() {
        return this.barbarianManager.willRaidTonight();
    }

    @Override
    public boolean isCanHaveBarbEvents() {
        return this.barbarianManager.canHaveBarbEvents();
    }

    @Override
    public boolean isHasRaidBeenCalculated() {
        return this.barbarianManager.hasRaidBeenCalculated();
    }

    @Override
    public void markDirty() {
        this.packageManager.setDirty();
        this.colonyTag = null;
        this.isDirty = true;
    }

    @Override
    public boolean canBeAutoDeleted() {
        return this.canColonyBeAutoDeleted;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.buildingManager.getBuilding(pos);
    }

    public void increaseOverallHappiness(double amount) {
        this.overallHappiness = Math.min(this.overallHappiness + Math.abs(amount), 10.0);
        this.markDirty();
    }

    public void decreaseOverallHappiness(double amount) {
        this.overallHappiness = Math.max(this.overallHappiness - Math.abs(amount), 1.0);
        this.markDirty();
    }

    @NotNull
    public List<EntityPlayer> getMessageEntityPlayers() {
        return ServerUtils.getPlayersFromUUID(this.world, this.getPermissions().getMessagePlayers());
    }

    public boolean isManualHiring() {
        return this.manualHiring;
    }

    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
        this.markDirty();
    }

    public boolean isManualHousing() {
        return this.manualHousing;
    }

    public void setManualHousing(boolean manualHousing) {
        this.manualHousing = manualHousing;
        this.markDirty();
    }

    public void removeWorkOrderInView(int orderId) {
        for (EntityPlayerMP player : this.packageManager.getSubscribers()) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveWorkOrderMessage(this, orderId), player);
        }
    }

    public void onBuildingUpgradeComplete(@NotNull AbstractBuilding building, int level) {
        building.onUpgradeComplete(level);
        this.markDirty();
    }

    public void addWayPoint(BlockPos point, IBlockState block) {
        this.wayPoints.put(point, block);
        this.markDirty();
    }

    @NotNull
    public List<BlockPos> getWayPoints(@NotNull BlockPos position, @NotNull BlockPos target) {
        ArrayList<BlockPos> tempWayPoints = new ArrayList<BlockPos>();
        tempWayPoints.addAll(this.wayPoints.keySet());
        tempWayPoints.addAll(this.buildingManager.getBuildings().keySet());
        double maxX = Math.max(position.func_177958_n(), target.func_177958_n());
        double maxZ = Math.max(position.func_177952_p(), target.func_177952_p());
        double minX = Math.min(position.func_177958_n(), target.func_177958_n());
        double minZ = Math.min(position.func_177952_p(), target.func_177952_p());
        Iterator iterator = tempWayPoints.iterator();
        while (iterator.hasNext()) {
            BlockPos p = (BlockPos)iterator.next();
            int x = p.func_177958_n();
            int z = p.func_177952_p();
            if (!((double)x < minX || (double)x > maxX || (double)z < minZ) && !((double)z > maxZ)) continue;
            iterator.remove();
        }
        return tempWayPoints;
    }

    public double getOverallHappiness() {
        return this.overallHappiness;
    }

    public Map<BlockPos, IBlockState> getWayPoints() {
        return new HashMap<BlockPos, IBlockState>(this.wayPoints);
    }

    public void setCanBeAutoDeleted(Boolean canBeDeleted) {
        this.canColonyBeAutoDeleted = canBeDeleted;
        this.markDirty();
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public IBuildingManager getBuildingManager() {
        return this.buildingManager;
    }

    public ICitizenManager getCitizenManager() {
        return this.citizenManager;
    }

    public IStatisticAchievementManager getStatsManager() {
        return this.statsManager;
    }

    public IBarbarianManager getBarbManager() {
        return this.barbarianManager;
    }

    public IColonyPackageManager getPackageManager() {
        return this.packageManager;
    }

    public NBTTagCompound getColonyTag() {
        if (this.colonyTag == null) {
            this.writeToNBT(new NBTTagCompound());
        }
        return this.colonyTag;
    }
}

