/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.EntityFishHook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

public class RenderFishHook
extends Render<EntityFishHook> {
    private static final ResourceLocation texture = new ResourceLocation("textures/particle/particles.png");

    public RenderFishHook(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void doRender(@NotNull EntityFishHook entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.func_180548_c(entity);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_179114_b((float)((float)(180.0 - (double)this.field_76990_c.field_78735_i)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        vertexBuffer.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0625, 0.1875).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_181662_b(0.5, -0.5, 0.0).func_187315_a(0.125, 0.1875).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_181662_b(0.5, 0.5, 0.0).func_187315_a(0.125, 0.125).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuffer.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0625, 0.125).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        EntityCitizen citizen = entity.getCitizen();
        if (citizen == null) {
            for (Object citizenX : CompatibilityUtils.getWorld(entity).func_72872_a(EntityCitizen.class, entity.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0))) {
                if (!((EntityCitizen)((Object)citizenX)).getModelID().textureBase.contains("Fisherman")) continue;
                citizen = (EntityCitizen)((Object)citizenX);
                break;
            }
        }
        if (citizen != null) {
            double orientation = citizen.func_70678_g(partialTicks);
            double finalOrientation = Math.sin(Math.sqrt(orientation) * Math.PI);
            Vec3d Vec3d2 = new Vec3d(-0.36, 0.03, 0.35);
            Vec3d2.func_178789_a((float)(-((double)citizen.field_70127_C + ((double)citizen.field_70125_A - (double)citizen.field_70127_C) * (double)partialTicks) * Math.PI / 180.0));
            Vec3d2.func_178785_b((float)(-((double)citizen.field_70126_B + ((double)citizen.field_70177_z - (double)citizen.field_70126_B) * (double)partialTicks) * Math.PI / 180.0));
            Vec3d2.func_178785_b((float)(finalOrientation * 0.5));
            Vec3d2.func_178789_a((float)(-finalOrientation * 0.7));
            double thirdPersonOffset = ((double)citizen.field_70760_ar + ((double)citizen.field_70761_aq - (double)citizen.field_70760_ar) * (double)partialTicks) * Math.PI / 180.0;
            double correctedPosX = citizen.field_70169_q + (citizen.field_70165_t - citizen.field_70169_q) * (double)partialTicks - (double)MathHelper.func_76134_b((float)((float)thirdPersonOffset)) * 0.35 - (double)MathHelper.func_76126_a((float)((float)thirdPersonOffset)) * 0.8;
            double correctedPosY = citizen.field_70167_r + (double)citizen.func_70047_e() + (citizen.field_70163_u - citizen.field_70167_r) * (double)partialTicks - 0.45;
            double correctedPosZ = citizen.field_70166_s + (citizen.field_70161_v - citizen.field_70166_s) * (double)partialTicks - (double)MathHelper.func_76126_a((float)((float)thirdPersonOffset)) * 0.35 + (double)MathHelper.func_76134_b((float)((float)thirdPersonOffset)) * 0.8;
            double eyeHeight = citizen.func_70093_af() ? -0.1875 : 0.0;
            double distX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
            double distY = entity.field_70163_u + 0.25;
            double distZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
            double correctionX = correctedPosX - distX;
            double correctionY = correctedPosY - distY + eyeHeight;
            double correctionZ = correctedPosZ - distZ;
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            vertexBuffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            for (int l = 0; l <= 16; ++l) {
                double var = (double)l / 16.0;
                vertexBuffer.func_181662_b(x + correctionX * var, y + correctionY * (var * var + var) * 0.5 + 0.25, z + correctionZ * var).func_181669_b(0, 0, 0, 255).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }
    }

    @NotNull
    protected ResourceLocation getEntityTexture(EntityFishHook entity) {
        return RenderFishHook.getTexture();
    }

    @NotNull
    private static ResourceLocation getTexture() {
        return texture;
    }
}

