/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.colony.buildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.network.messages.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.UpgradeWarehouseMessage;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowWareHouseBuilding
extends AbstractWindowBuilding<BuildingWareHouse.View> {
    private static final String HUT_BUILDER_RESOURCE_SUFFIX = ":gui/windowhutwarehouse.xml";
    private static final String RESOURCE_NAME = "resourceName";
    private static final String RESOURCE_AVAILABLE_NEEDED = "resourceAvailableNeeded";
    private static final String RESOURCE_MISSING = "resourceMissing";
    private static final String RESOURCE_ADD = "resourceAdd";
    private static final String RESOURCE_QUANTITY_MISSING = "resourceQuantity";
    private static final String RESOURCE_ICON = "resourceIcon";
    private static final int RED = Color.getByName("red", 0);
    private static final int DARKGREEN = Color.getByName("darkgreen", 0);
    private static final int BLACK = Color.getByName("black", 0);
    private boolean allowMoreStorageUpgrades = false;

    public WindowWareHouseBuilding(BuildingWareHouse.View building) {
        super(building, "minecolonies:gui/windowhutwarehouse.xml");
        this.registerButton(RESOURCE_ADD, this::transferItems);
        if (building.isBuildingMaxLevel() && building.canUpgradeStorage()) {
            this.allowMoreStorageUpgrades = true;
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateResourcePane();
        MineColonies.getNetwork().sendToServer((IMessage)new MarkBuildingDirtyMessage(this.building));
    }

    private void updateResourcePane() {
        BuildingBuilderResource resource = new BuildingBuilderResource(new ItemStack(Blocks.field_150475_bE, 1), 1);
        InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
        boolean isCreative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
        int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), resource.getItem(), resource.getDamageValue());
        resource.setPlayerAmount(amountToSet);
        Label resourceLabel = this.findPaneOfTypeByID(RESOURCE_NAME, Label.class);
        Label resourceMissingLabel = this.findPaneOfTypeByID(RESOURCE_MISSING, Label.class);
        Label neededLabel = this.findPaneOfTypeByID(RESOURCE_AVAILABLE_NEEDED, Label.class);
        Button addButton = this.findPaneOfTypeByID(RESOURCE_ADD, Button.class);
        BuildingBuilderResource.RessourceAvailability availability = resource.getAvailabilityStatus();
        if (!this.allowMoreStorageUpgrades) {
            availability = BuildingBuilderResource.RessourceAvailability.NOT_NEEDED;
        }
        switch (availability) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColor(RED, RED);
                resourceMissingLabel.setColor(RED, RED);
                neededLabel.setColor(RED, RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColor(RED, RED);
                resourceMissingLabel.setColor(RED, RED);
                neededLabel.setColor(RED, RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColor(DARKGREEN, DARKGREEN);
                resourceMissingLabel.setColor(DARKGREEN, DARKGREEN);
                neededLabel.setColor(DARKGREEN, DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColor(BLACK, BLACK);
                resourceMissingLabel.setColor(BLACK, BLACK);
                neededLabel.setColor(BLACK, BLACK);
            }
        }
        resourceLabel.setLabelText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setLabelText(Integer.toString(missing));
        } else {
            resourceMissingLabel.setLabelText("");
        }
        neededLabel.setLabelText(Integer.toString(resource.getAvailable()) + " / " + Integer.toString(resource.getAmount()));
        this.findPaneOfTypeByID(RESOURCE_QUANTITY_MISSING, Label.class).setLabelText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        this.findPaneOfTypeByID(RESOURCE_ICON, ItemIcon.class).setItem(new ItemStack(resource.getItem(), 1, resource.getDamageValue()));
    }

    private void transferItems() {
        MineColonies.getNetwork().sendToServer((IMessage)new UpgradeWarehouseMessage(this.building));
        this.allowMoreStorageUpgrades = false;
        this.updateResourcePane();
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.buildingWareHouse";
    }
}

