/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.network.messages.GuardScepterMessage;
import com.minecolonies.coremod.network.messages.GuardTaskMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutGuardTower
extends AbstractWindowWorkerBuilding<AbstractBuildingGuards.View> {
    private static final String LIST_LEVELS = "positions";
    private static final String PAGE_ACTIONS = "levelActions";
    private static final String BUTTON_JOB = "job";
    private static final String BUTTON_ASSIGNMENT_MODE = "assign";
    private static final String BUTTON_PATROL_MODE = "patrol";
    private static final String BUTTON_RETRIEVAL_MODE = "retrieve";
    private static final String BUTTON_TASK_PATROL = "patrolling";
    private static final String BUTTON_TASK_FOLLOW = "following";
    private static final String BUTTON_TASK_GUARD = "guarding";
    private static final String BUTTON_SET_TARGET = "setTarget";
    private static final String VIEW_PAGES = "pages";
    private static final String AUTO = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.modeA", new Object[0]);
    private static final String MANUAL = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.modeM", new Object[0]);
    private static final String ON = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOn", new Object[0]);
    private static final String OFF = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOff", new Object[0]);
    private static final String HUT_GUARD_TOWER_RESOURCE_SUFFIX = ":gui/windowhutguardtower.xml";
    private final Button buttonTaskPatrol;
    private final Button buttonTaskFollow;
    private final Button buttonTaskGuard;
    private final Button buttonSetTarget;
    private boolean assignManually = false;
    private boolean retrieveOnLowHealth = false;
    private boolean patrolManually = false;
    private AbstractBuildingGuards.Task task = AbstractBuildingGuards.Task.GUARD;
    private AbstractBuildingGuards.GuardJob job = null;
    private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
    private ScrollingList patrolList;

    public WindowHutGuardTower(AbstractBuildingGuards.View building) {
        super(building, "minecolonies:gui/windowhutguardtower.xml");
        this.pullInfoFromHut();
        this.registerButton(BUTTON_JOB, this::switchJob);
        this.registerButton(BUTTON_ASSIGNMENT_MODE, this::switchAssignmentMode);
        this.registerButton(BUTTON_PATROL_MODE, this::switchPatrolMode);
        this.registerButton(BUTTON_RETRIEVAL_MODE, this::switchRetrievalMode);
        this.registerButton(BUTTON_TASK_PATROL, this::switchTask);
        this.registerButton(BUTTON_TASK_FOLLOW, this::switchTask);
        this.registerButton(BUTTON_TASK_GUARD, this::switchTask);
        this.registerButton(BUTTON_SET_TARGET, this::setTarget);
        this.buttonTaskPatrol = this.findPaneOfTypeByID(BUTTON_TASK_PATROL, Button.class);
        this.buttonTaskFollow = this.findPaneOfTypeByID(BUTTON_TASK_FOLLOW, Button.class);
        this.buttonTaskGuard = this.findPaneOfTypeByID(BUTTON_TASK_GUARD, Button.class);
        this.buttonSetTarget = this.findPaneOfTypeByID(BUTTON_SET_TARGET, Button.class);
        this.handleButtons();
    }

    private void pullInfoFromHut() {
        this.assignManually = ((AbstractBuildingGuards.View)this.building).assignManually;
        this.patrolManually = ((AbstractBuildingGuards.View)this.building).patrolManually;
        this.retrieveOnLowHealth = ((AbstractBuildingGuards.View)this.building).retrieveOnLowHealth;
        this.task = ((AbstractBuildingGuards.View)this.building).task;
        this.job = ((AbstractBuildingGuards.View)this.building).job;
        this.patrolTargets = ((AbstractBuildingGuards.View)this.building).patrolTargets;
    }

    private void handleButtons() {
        Button buttonJob = this.findPaneOfTypeByID(BUTTON_JOB, Button.class);
        if (this.job != null) {
            if (this.job.equals((Object)AbstractBuildingGuards.GuardJob.KNIGHT)) {
                buttonJob.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.knight", new Object[0]));
            } else {
                buttonJob.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.ranger", new Object[0]));
            }
        }
        buttonJob.setEnabled(this.assignManually);
        this.findPaneOfTypeByID(BUTTON_ASSIGNMENT_MODE, Button.class).setLabel(this.assignManually ? MANUAL : AUTO);
        this.findPaneOfTypeByID(BUTTON_PATROL_MODE, Button.class).setLabel(this.patrolManually ? MANUAL : AUTO);
        this.findPaneOfTypeByID(BUTTON_RETRIEVAL_MODE, Button.class).setLabel(this.retrieveOnLowHealth ? ON : OFF);
        if (this.task.equals((Object)AbstractBuildingGuards.Task.PATROL)) {
            if (this.patrolManually) {
                this.buttonSetTarget.setEnabled(true);
                this.buttonSetTarget.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.targetPatrol", new Object[0]));
            } else {
                this.buttonSetTarget.setEnabled(false);
            }
            this.buttonTaskPatrol.setEnabled(false);
        } else if (this.task.equals((Object)AbstractBuildingGuards.Task.FOLLOW)) {
            this.buttonTaskFollow.setEnabled(false);
            this.buttonSetTarget.hide();
        } else if (this.task.equals((Object)AbstractBuildingGuards.Task.GUARD)) {
            this.buttonSetTarget.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.targetGuard", new Object[0]));
            this.buttonTaskGuard.setEnabled(false);
        }
    }

    private void switchTask(Button button) {
        if (button.getID().contains(BUTTON_PATROL_MODE)) {
            ((AbstractBuildingGuards.View)this.building).task = AbstractBuildingGuards.Task.PATROL;
            this.buttonTaskPatrol.setEnabled(false);
            this.buttonTaskFollow.setEnabled(true);
            this.buttonTaskGuard.setEnabled(true);
            this.buttonSetTarget.show();
        } else if (button.getID().contains("follow")) {
            ((AbstractBuildingGuards.View)this.building).task = AbstractBuildingGuards.Task.FOLLOW;
            this.buttonTaskFollow.setEnabled(false);
            this.buttonTaskPatrol.setEnabled(true);
            this.buttonTaskGuard.setEnabled(true);
            this.buttonSetTarget.hide();
        } else {
            ((AbstractBuildingGuards.View)this.building).task = AbstractBuildingGuards.Task.GUARD;
            this.buttonTaskGuard.setEnabled(false);
            this.buttonTaskPatrol.setEnabled(true);
            this.buttonTaskFollow.setEnabled(true);
            this.buttonSetTarget.show();
        }
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void sendChangesToServer() {
        int ordinal = ((AbstractBuildingGuards.View)this.building).job == null ? -1 : this.job.ordinal();
        MineColonies.getNetwork().sendToServer((IMessage)new GuardTaskMessage((AbstractBuildingGuards.View)this.building, ordinal, this.assignManually, this.patrolManually, this.retrieveOnLowHealth, this.task.ordinal()));
    }

    private void setTarget() {
        EntityPlayerSP player = this.mc.field_71439_g;
        int emptySlot = player.field_71071_by.func_70447_i();
        this.pullInfoFromHut();
        if (emptySlot == -1) {
            LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.gui.workerHuts.noSpace", new Object[0]);
        }
        if (this.patrolManually && this.task.equals((Object)AbstractBuildingGuards.Task.PATROL)) {
            this.givePlayerScepter(AbstractBuildingGuards.Task.PATROL);
            LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.job.guard.tool.taskPatrol", new Object[0]);
        } else if (this.task.equals((Object)AbstractBuildingGuards.Task.GUARD)) {
            this.givePlayerScepter(AbstractBuildingGuards.Task.GUARD);
            LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.job.guard.tool.taskGuard", new Object[0]);
        }
        this.window.close();
    }

    private void givePlayerScepter(AbstractBuildingGuards.Task localTask) {
        MineColonies.getNetwork().sendToServer((IMessage)new GuardScepterMessage(localTask.ordinal(), ((AbstractBuildingGuards.View)this.building).getID()));
    }

    private void switchRetrievalMode() {
        ((AbstractBuildingGuards.View)this.building).retrieveOnLowHealth = !((AbstractBuildingGuards.View)this.building).retrieveOnLowHealth;
        this.pullInfoFromHut();
        this.sendChangesToServer();
        this.findPaneOfTypeByID(BUTTON_RETRIEVAL_MODE, Button.class).setLabel(this.retrieveOnLowHealth ? ON : OFF);
    }

    private void switchPatrolMode() {
        ((AbstractBuildingGuards.View)this.building).patrolManually = !((AbstractBuildingGuards.View)this.building).patrolManually;
        this.pullInfoFromHut();
        this.sendChangesToServer();
        this.handleButtons();
    }

    private void switchJob() {
        ((AbstractBuildingGuards.View)this.building).job = ((AbstractBuildingGuards.View)this.building).job == null ? AbstractBuildingGuards.GuardJob.RANGER : (((AbstractBuildingGuards.View)this.building).job.equals((Object)AbstractBuildingGuards.GuardJob.KNIGHT) ? AbstractBuildingGuards.GuardJob.RANGER : AbstractBuildingGuards.GuardJob.KNIGHT);
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void switchAssignmentMode() {
        ((AbstractBuildingGuards.View)this.building).assignManually = !((AbstractBuildingGuards.View)this.building).assignManually;
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.patrolList = this.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class);
        if (this.task.equals((Object)AbstractBuildingGuards.Task.PATROL)) {
            this.patrolList.setDataProvider(new ScrollingList.DataProvider(){

                @Override
                public int getElementCount() {
                    return WindowHutGuardTower.this.patrolTargets.size();
                }

                @Override
                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = (BlockPos)WindowHutGuardTower.this.patrolTargets.get(index);
                    rowPane.findPaneOfTypeByID("position", Label.class).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            });
        } else if (this.task.equals((Object)AbstractBuildingGuards.Task.GUARD)) {
            this.patrolList.setDataProvider(new ScrollingList.DataProvider(){

                @Override
                public int getElementCount() {
                    return 1;
                }

                @Override
                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = ((AbstractBuildingGuards.View)WindowHutGuardTower.this.building).guardPos;
                    rowPane.findPaneOfTypeByID("position", Label.class).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            });
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.GuardTower";
    }

    @Override
    public void onUpdate() {
        String currentPage;
        super.onUpdate();
        this.pullInfoFromHut();
        this.handleButtons();
        if (!this.task.equals((Object)AbstractBuildingGuards.Task.PATROL)) {
            this.patrolList.hide();
        }
        if ((currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID()).equals(PAGE_ACTIONS)) {
            this.pullInfoFromHut();
            this.window.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class).refreshElementPanes();
        }
    }
}

