/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.views.BuildingBuilderView;
import com.minecolonies.coremod.network.messages.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.TransferItemsRequestMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowHutBuilder
extends AbstractWindowWorkerBuilding<BuildingBuilderView> {
    private static final String HUT_BUILDER_RESOURCE_SUFFIX = ":gui/windowhutbuilder.xml";
    private static final String LIST_RESOURCES = "resources";
    private static final String PAGE_RESOURCES = "resourceActions";
    private static final String VIEW_PAGES = "pages";
    private static final String RESOURCE_NAME = "resourceName";
    private static final String RESOURCE_AVAILABLE_NEEDED = "resourceAvailableNeeded";
    private static final String RESOURCE_MISSING = "resourceMissing";
    private static final String RESOURCE_ADD = "resourceAdd";
    private static final String RESOURCE_ID = "resourceId";
    private static final String RESOURCE_QUANTITY_MISSING = "resourceQuantity";
    private static final String RESOURCE_ICON = "resourceIcon";
    private static final int RED = Color.getByName("red", 0);
    private static final int DARKGREEN = Color.getByName("darkgreen", 0);
    private static final int BLACK = Color.getByName("black", 0);
    private final BuildingBuilderView builder;
    @NotNull
    private final List<BuildingBuilderResource> resources = new ArrayList<BuildingBuilderResource>();

    public WindowHutBuilder(BuildingBuilderView building) {
        super(building, "minecolonies:gui/windowhutbuilder.xml");
        this.builder = building;
        this.pullResourcesFromHut();
        this.registerButton(RESOURCE_ADD, this::transferItems);
    }

    private void pullResourcesFromHut() {
        AbstractBuildingView newView = this.builder.getColony().getBuilding(this.builder.getID());
        if (newView instanceof BuildingBuilderView) {
            BuildingBuilderView updatedView = (BuildingBuilderView)newView;
            InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
            boolean isCreative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
            this.resources.clear();
            this.resources.addAll(updatedView.getResources().values());
            for (BuildingBuilderResource resource : this.resources) {
                int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), resource.getItem(), resource.getDamageValue());
                resource.setPlayerAmount(amountToSet);
            }
            this.resources.sort(new BuildingBuilderResource.ResourceComparator());
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.pullResourcesFromHut();
        ScrollingList resourceList = this.findPaneOfTypeByID(LIST_RESOURCES, ScrollingList.class);
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutBuilder.this.resources.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                WindowHutBuilder.this.updateResourcePane(index, rowPane);
            }
        });
        MineColonies.getNetwork().sendToServer((IMessage)new MarkBuildingDirtyMessage(this.building));
    }

    private void updateResourcePane(int index, @NotNull Pane rowPane) {
        BuildingBuilderResource resource = this.resources.get(index);
        Label resourceLabel = rowPane.findPaneOfTypeByID(RESOURCE_NAME, Label.class);
        Label resourceMissingLabel = rowPane.findPaneOfTypeByID(RESOURCE_MISSING, Label.class);
        Label neededLabel = rowPane.findPaneOfTypeByID(RESOURCE_AVAILABLE_NEEDED, Label.class);
        Button addButton = rowPane.findPaneOfTypeByID(RESOURCE_ADD, Button.class);
        switch (resource.getAvailabilityStatus()) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColor(RED, RED);
                resourceMissingLabel.setColor(RED, RED);
                neededLabel.setColor(RED, RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColor(RED, RED);
                resourceMissingLabel.setColor(RED, RED);
                neededLabel.setColor(RED, RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColor(DARKGREEN, DARKGREEN);
                resourceMissingLabel.setColor(DARKGREEN, DARKGREEN);
                neededLabel.setColor(DARKGREEN, DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColor(BLACK, BLACK);
                resourceMissingLabel.setColor(BLACK, BLACK);
                neededLabel.setColor(BLACK, BLACK);
            }
        }
        int buttonX = rowPane.getWidth() - addButton.getWidth() - (rowPane.getHeight() - addButton.getHeight()) / 2;
        int buttonY = rowPane.getHeight() - addButton.getHeight() - 2;
        addButton.setPosition(buttonX, buttonY);
        resourceLabel.setLabelText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setLabelText(Integer.toString(missing));
        } else {
            resourceMissingLabel.setLabelText("");
        }
        neededLabel.setLabelText(Integer.toString(resource.getAvailable()) + " / " + Integer.toString(resource.getAmount()));
        rowPane.findPaneOfTypeByID(RESOURCE_ID, Label.class).setLabelText(Integer.toString(index));
        rowPane.findPaneOfTypeByID(RESOURCE_QUANTITY_MISSING, Label.class).setLabelText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        rowPane.findPaneOfTypeByID(RESOURCE_ICON, ItemIcon.class).setItem(new ItemStack(resource.getItem(), 1, resource.getDamageValue()));
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.buildersHut";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        String currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID();
        if (currentPage.equals(PAGE_RESOURCES)) {
            this.pullResourcesFromHut();
            this.window.findPaneOfTypeByID(LIST_RESOURCES, ScrollingList.class).refreshElementPanes();
        }
    }

    private void transferItems(@NotNull Button button) {
        View pane = button.getParent();
        Label idLabel = pane.findPaneOfTypeByID(RESOURCE_ID, Label.class);
        int index = Integer.parseInt(idLabel.getLabelText());
        BuildingBuilderResource res = this.resources.get(index);
        if (res == null) {
            Log.getLogger().warn("WindowHutBuilder.transferItems: Error - Could not find the resource.");
        } else {
            ItemStack itemStack = new ItemStack(res.getItem(), 1, res.getDamageValue());
            Label quantityLabel = pane.findPaneOfTypeByID(RESOURCE_QUANTITY_MISSING, Label.class);
            int quantity = Integer.parseInt(quantityLabel.getLabelText());
            MineColonies.getNetwork().sendToServer((IMessage)new TransferItemsRequestMessage(this.building, itemStack, quantity, true));
        }
    }
}

