/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Alignment;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.Image;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowRequestDetail;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.TransferItemsToCitizenRequestMessage;
import com.minecolonies.coremod.network.messages.UpdateRequestStateMessage;
import com.minecolonies.coremod.util.ExperienceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowCitizen
extends AbstractWindowSkeleton {
    private static final String INVENTORY_BUTTON_ID = "inventory";
    private static final String CITIZEN_RESOURCE_SUFFIX = ":gui/windowcitizen.xml";
    private static final String STRENGTH = "strength";
    private static final String ENDURANCE = "endurance";
    private static final String CHARISMA = "charisma";
    private static final String INTELLIGENCE = "intelligence";
    private static final String DEXTERITY = "dexterity";
    private static final String REQUEST_FULLFIL = "fulfill";
    private static final String REQUEST_CANCEL = "cancel";
    private static final String POSITION_STRING = "x: %d - y: %d - z: %d";
    private static final int XP_HEIGHT = 5;
    private static final int LEFT_BORDER_X = 10;
    private static final int LEFT_BORDER_Y = 10;
    private static final int XP_BAR_ICON_COLUMN = 0;
    private static final int XP_BAR_ICON_COLUMN_END = 172;
    private static final int XP_BAR_ICON_COLUMN_END_WIDTH = 10;
    private static final int XP_BAR_ICON_END_OFFSET = 90;
    private static final int XP_BAR_WIDTH = 91;
    private static final int XP_BAR_EMPTY_ROW = 64;
    private static final int XP_BAR_FULL_ROW = 69;
    private static final int EMPTY_HEART_ICON_ROW_POS = 16;
    private static final int FULL_HEART_ICON_ROW_POS = 53;
    private static final int HALF_HEART_ICON_ROW_POS = 62;
    private static final int HEART_ICON_COLUMN = 0;
    private static final int HEART_ICON_HEIGHT_WIDTH = 9;
    private static final int HEART_ICON_POS_X = 10;
    private static final int HEART_ICON_OFFSET_X = 10;
    private static final int HEART_ICON_POS_Y = 10;
    private static final int SATURATION_ICON_POS_Y = 10;
    private static final int SATURATION_ICON_COLUMN = 27;
    private static final int SATURATION_ICON_HEIGHT_WIDTH = 9;
    private static final int SATURATION_ICON_POS_X = 10;
    private static final int SATURATION_ICON_OFFSET_X = 10;
    private static final String WINDOW_ID_NAME = "name";
    private static final String WINDOW_ID_XP = "xpLabel";
    private static final String WINDOW_ID_XPBAR = "xpBar";
    private static final String WINDOW_ID_HEALTHBAR = "healthBar";
    private static final int EMPTY_SATURATION_ITEM_ROW_POS = 16;
    private static final int FULL_SATURATION_ITEM_ROW_POS = 52;
    private static final int HALF_SATURATION_ITEM_ROW_POS = 61;
    private static final String WINDOW_ID_SATURATION_BAR = "saturationBar";
    private static final String WINDOW_ID_GENDER = "gender";
    private static final String WINDOW_ID_LIST_REQUESTS = "requests";
    private static final String LIST_ELEMENT_ID_REQUEST_STACK = "requestStack";
    private static final String DELIVERY_IMAGE = "deliveryImage";
    private static final String BUTTON_REQUESTS = "requestsTitle";
    private static final String BUTTON_BACK = "back";
    private static final String VIEW_PAGES = "pages";
    private static final String FEMALE_SOURCE = "minecolonies:textures/gui/citizen/colonist_wax_female_smaller.png";
    private static final String REQUEST_DETAIL = "detail";
    private static final String REQUEST_SHORT_DETAIL = "shortDetail";
    private static final String REQUESTER = "requester";
    private static final int LIFE_COUNT_DIVIDER = 30;
    private final CitizenDataView citizen;
    private final ScrollingList resourceList;
    private final InventoryPlayer inventory;
    private final boolean isCreative;
    private int lifeCount;

    public WindowCitizen(CitizenDataView citizen) {
        super("minecolonies:gui/windowcitizen.xml");
        this.inventory = this.mc.field_71439_g.field_71071_by;
        this.isCreative = this.mc.field_71439_g.field_71075_bZ.field_75098_d;
        this.lifeCount = 0;
        this.citizen = citizen;
        this.resourceList = this.findPaneOfTypeByID(WINDOW_ID_LIST_REQUESTS, ScrollingList.class);
    }

    private static String getNicePositionString(BlockPos pos) {
        return String.format(POSITION_STRING, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!GuiScreen.func_146272_n()) {
            ++this.lifeCount;
        }
    }

    @Override
    public void onOpened() {
        this.findPaneOfTypeByID(WINDOW_ID_NAME, Label.class).setLabelText(this.citizen.getName());
        this.createHealthBar();
        this.createSaturationBar();
        this.createXpBar();
        this.createSkillContent();
        this.resourceList.setDataProvider(() -> this.getOpenRequestsOfCitizen().size(), (index, rowPane) -> {
            ImmutableList<IRequest> openRequests = this.getOpenRequestsOfCitizen();
            if (index < 0 || index >= openRequests.size()) {
                return;
            }
            IRequest request = (IRequest)openRequests.get(index);
            ItemIcon exampleStackDisplay = rowPane.findPaneOfTypeByID(LIST_ELEMENT_ID_REQUEST_STACK, ItemIcon.class);
            List<ItemStack> displayStacks = request.getDisplayStacks();
            if (!displayStacks.isEmpty()) {
                exampleStackDisplay.setItem(displayStacks.get(this.lifeCount / 30 % displayStacks.size()));
            } else {
                Image logo = this.findPaneOfTypeByID(DELIVERY_IMAGE, Image.class);
                logo.setVisible(true);
                logo.setImage(request.getDisplayIcon());
            }
            rowPane.findPaneOfTypeByID(REQUESTER, Label.class).setLabelText(request.getRequester().getDisplayName((IToken<?>)request.getToken()).func_150254_d());
            rowPane.findPaneOfTypeByID(REQUEST_SHORT_DETAIL, Label.class).setLabelText(request.getShortDisplayString().func_150254_d().replace("\u00a7f", ""));
            request.getRequestOfType(IDeliverable.class).ifPresent(requestRequest -> {
                if (!this.isCreative) {
                    if (!InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.inventory), requestRequest::matches)) {
                        rowPane.findPaneOfTypeByID(REQUEST_FULLFIL, ButtonImage.class).hide();
                    }
                }
            });
        });
        if (this.citizen.isFemale()) {
            this.findPaneOfTypeByID(WINDOW_ID_GENDER, Image.class).setImage(FEMALE_SOURCE);
        }
    }

    private void createHealthBar() {
        int heartPos;
        Image heart;
        this.findPaneOfTypeByID(WINDOW_ID_HEALTHBAR, View.class).setAlignment(Alignment.MIDDLE_RIGHT);
        int i = 0;
        while ((double)i < this.citizen.getMaxHealth() / 2.0) {
            heart = new Image();
            heart.setImage(Gui.field_110324_m, 16, 0, 9, 9, false);
            heart.setPosition(i * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_HEALTHBAR, View.class).addChild(heart);
            ++i;
        }
        for (heartPos = 0; heartPos < (int)this.citizen.getHealth() / 2; ++heartPos) {
            heart = new Image();
            heart.setImage(Gui.field_110324_m, 53, 0, 9, 9, false);
            heart.setPosition(heartPos * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_HEALTHBAR, View.class).addChild(heart);
        }
        if (this.citizen.getHealth() / 2.0 % 1.0 > 0.0) {
            heart = new Image();
            heart.setImage(Gui.field_110324_m, 62, 0, 9, 9, false);
            heart.setPosition(heartPos * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_HEALTHBAR, View.class).addChild(heart);
        }
    }

    private void createSaturationBar() {
        int saturationPos;
        Image saturation;
        this.findPaneOfTypeByID(WINDOW_ID_SATURATION_BAR, View.class).setAlignment(Alignment.MIDDLE_RIGHT);
        for (int i = 0; i < 10; ++i) {
            saturation = new Image();
            saturation.setImage(Gui.field_110324_m, 16, 27, 9, 9, false);
            saturation.setPosition(i * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_SATURATION_BAR, View.class).addChild(saturation);
        }
        for (saturationPos = 0; saturationPos < (int)this.citizen.getSaturation(); ++saturationPos) {
            saturation = new Image();
            saturation.setImage(Gui.field_110324_m, 52, 27, 9, 9, false);
            saturation.setPosition(saturationPos * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_SATURATION_BAR, View.class).addChild(saturation);
        }
        if (this.citizen.getSaturation() / 2.0 % 1.0 > 0.0) {
            saturation = new Image();
            saturation.setImage(Gui.field_110324_m, 61, 27, 9, 9, false);
            saturation.setPosition(saturationPos * 10 + 10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_SATURATION_BAR, View.class).addChild(saturation);
        }
    }

    private void createXpBar() {
        double experienceRatio = ExperienceUtils.getPercentOfLevelCompleted(this.citizen.getExperience(), this.citizen.getLevel());
        this.findPaneOfTypeByID(WINDOW_ID_XP, Label.class).setLabelText(Integer.toString(this.citizen.getLevel()));
        Image xpBar = new Image();
        xpBar.setImage(Gui.field_110324_m, 0, 64, 91, 5, false);
        xpBar.setPosition(10, 10);
        Image xpBar2 = new Image();
        xpBar2.setImage(Gui.field_110324_m, 172, 64, 10, 5, false);
        xpBar2.setPosition(100, 10);
        this.findPaneOfTypeByID(WINDOW_ID_XPBAR, View.class).addChild(xpBar);
        this.findPaneOfTypeByID(WINDOW_ID_XPBAR, View.class).addChild(xpBar2);
        if (experienceRatio > 0.0) {
            Image xpBarFull = new Image();
            xpBarFull.setImage(Gui.field_110324_m, 0, 69, (int)experienceRatio, 5, false);
            xpBarFull.setPosition(10, 10);
            this.findPaneOfTypeByID(WINDOW_ID_XPBAR, View.class).addChild(xpBarFull);
        }
    }

    private void createSkillContent() {
        this.findPaneOfTypeByID(STRENGTH, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.strength", this.citizen.getStrength()));
        this.findPaneOfTypeByID(ENDURANCE, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.endurance", this.citizen.getEndurance()));
        this.findPaneOfTypeByID(CHARISMA, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.charisma", this.citizen.getCharisma()));
        this.findPaneOfTypeByID(INTELLIGENCE, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.intelligence", this.citizen.getIntelligence()));
        this.findPaneOfTypeByID(DEXTERITY, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.citizen.skills.dexterity", this.citizen.getDexterity()));
    }

    private ImmutableList<IRequest> getOpenRequestsOfCitizen() {
        ArrayList<IRequest> requests = new ArrayList<IRequest>();
        if (this.citizen.getWorkBuilding() != null) {
            requests.addAll((Collection<IRequest>)this.getOpenRequestsOfCitizenFromBuilding(this.citizen.getWorkBuilding()));
        }
        if (this.citizen.getHomeBuilding() != null && !this.citizen.getHomeBuilding().equals((Object)this.citizen.getWorkBuilding())) {
            requests.addAll((Collection<IRequest>)this.getOpenRequestsOfCitizenFromBuilding(this.citizen.getHomeBuilding()));
        }
        BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        requests.sort(Comparator.comparing(request -> request.getRequester().getDeliveryLocation().getInDimensionLocation().func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p())).thenComparingInt(request -> request.getToken().hashCode()));
        return ImmutableList.copyOf(requests);
    }

    private ImmutableList<IRequest> getOpenRequestsOfCitizenFromBuilding(BlockPos buildingPos) {
        ColonyView colonyView = ColonyManager.getClosestColonyView((World)FMLClientHandler.instance().getWorldClient(), buildingPos);
        if (colonyView == null) {
            return ImmutableList.of();
        }
        AbstractBuildingView building = colonyView.getBuilding(buildingPos);
        return building.getOpenRequests(this.citizen);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "requestsTitle": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
                break;
            }
            case "back": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
                break;
            }
            case "inventory": {
                MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(this.citizen.getName(), this.citizen.getEntityId()));
                break;
            }
            case "detail": {
                this.detailedClicked(button);
                break;
            }
            case "cancel": {
                this.cancel(button);
                break;
            }
            case "fulfill": {
                this.fulfill(button);
                break;
            }
        }
    }

    private void detailedClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequestsOfCitizen().size() > row) {
            WindowRequestDetail window = new WindowRequestDetail(this.citizen, (IRequest)this.getOpenRequestsOfCitizen().get(row), this.citizen.getColonyId());
            window.open();
        }
    }

    private void cancel(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequestsOfCitizen().size() > row && row >= 0) {
            IRequest request = (IRequest)this.getOpenRequestsOfCitizen().get(row);
            MineColonies.getNetwork().sendToServer((IMessage)new UpdateRequestStateMessage(this.citizen.getColonyId(), (IToken<?>)request.getToken(), RequestState.CANCELLED, null));
        }
    }

    private void fulfill(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane(button);
        if (this.getOpenRequestsOfCitizen().size() > row && row >= 0) {
            button.disable();
            IRequest tRequest = (IRequest)this.getOpenRequestsOfCitizen().get(row);
            if (!(tRequest.getRequest() instanceof IDeliverable)) {
                return;
            }
            IRequest request = tRequest;
            Predicate<ItemStack> requestPredicate = stack -> ((IDeliverable)request.getRequest()).matches((ItemStack)stack);
            int amount = ((IDeliverable)request.getRequest()).getCount();
            int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate);
            if (!this.isCreative && count <= 0) {
                return;
            }
            ItemStack itemStack = this.isCreative ? (ItemStack)request.getDisplayStacks().stream().findFirst().orElse(null) : this.inventory.func_70301_a(InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.inventory), requestPredicate));
            MineColonies.getNetwork().sendToServer((IMessage)new TransferItemsToCitizenRequestMessage(this.citizen, itemStack, this.isCreative ? amount : count, this.citizen.getColonyId()));
            MineColonies.getNetwork().sendToServer((IMessage)new UpdateRequestStateMessage(this.citizen.getColonyId(), (IToken<?>)request.getToken(), RequestState.OVERRULED, itemStack));
        }
    }
}

