/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHut;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.OpenInventoryMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowBuilding<B extends AbstractBuildingHut.View>
extends AbstractWindowSkeleton {
    private static final String LABEL_BUILDINGTYPE = "type";
    private static final String BUTTON_BUILD = "build";
    private static final String BUTTON_REPAIR = "repair";
    private static final String BUTTON_INVENTORY = "inventory";
    private static final String LABEL_BUILDING_NAME = "name";
    private static final String BUTTON_PREVPAGE = "prevPage";
    private static final String BUTTON_NEXTPAGE = "nextPage";
    private static final String VIEW_PAGES = "pages";
    private static final String PAGE_ACTIONS = "pageActions";
    protected final B building;
    private final SwitchView switchView;
    private final Label title;
    private final Button buttonPrevPage;
    private final Button buttonNextPage;
    private final Button buttonBuild;
    private final Button buttonRepair;

    public AbstractWindowBuilding(B building, String resource) {
        super(resource);
        this.building = building;
        this.registerButton(BUTTON_BUILD, this::buildClicked);
        this.registerButton(BUTTON_REPAIR, this::repairClicked);
        this.registerButton(BUTTON_INVENTORY, this::inventoryClicked);
        this.switchView = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class);
        this.title = this.findPaneOfTypeByID(LABEL_BUILDING_NAME, Label.class);
        this.buttonNextPage = this.findPaneOfTypeByID(BUTTON_NEXTPAGE, Button.class);
        this.buttonPrevPage = this.findPaneOfTypeByID(BUTTON_PREVPAGE, Button.class);
        this.buttonBuild = this.findPaneOfTypeByID(BUTTON_BUILD, Button.class);
        this.buttonRepair = this.findPaneOfTypeByID(BUTTON_REPAIR, Button.class);
    }

    private void buildClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuildingView)this.building, 0));
    }

    private void repairClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuildingView)this.building, 1));
    }

    private void inventoryClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage(((AbstractBuildingView)this.building).getID()));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.switchView == null || this.switchView.getCurrentView().getID().equals(PAGE_ACTIONS)) {
            AbstractBuildingView buildingView = ((AbstractBuildingView)this.building).getColony().getBuilding(((AbstractBuildingView)this.building).getID());
            if (this.buttonPrevPage != null) {
                this.buttonPrevPage.disable();
                this.buttonPrevPage.hide();
            }
            if (this.title != null) {
                this.title.setLabelText(LanguageHandler.format(this.getBuildingName(), new Object[0]) + " " + buildingView.getBuildingLevel());
            }
            this.updateButtonBuild(buildingView);
            this.updateButtonRepair(buildingView);
        }
    }

    public abstract String getBuildingName();

    private void updateButtonBuild(AbstractBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        this.buttonBuild.setEnabled(!buildingView.isBuildingMaxLevel() && !buildingView.isRepairing());
        if (buildingView.isBuildingMaxLevel()) {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.upgradeUnavailable", new Object[0]));
        } else if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelBuild", new Object[0]));
            } else {
                this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelUpgrade", new Object[0]));
            }
        } else if (buildingView.getBuildingLevel() == 0) {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.build", new Object[0]));
        } else {
            this.buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.upgrade", new Object[0]));
        }
    }

    private void updateButtonRepair(AbstractBuildingView buildingView) {
        if (this.buttonRepair == null) {
            return;
        }
        this.buttonRepair.setEnabled(buildingView.getBuildingLevel() != 0 && !buildingView.isBuilding());
        if (buildingView.isRepairing()) {
            this.buttonRepair.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.cancelRepair", new Object[0]));
        } else {
            this.buttonRepair.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.repair", new Object[0]));
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "prevPage": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
                this.buttonPrevPage.setEnabled(false);
                this.buttonNextPage.setEnabled(true);
                this.buttonPrevPage.hide();
                this.buttonNextPage.show();
                break;
            }
            case "nextPage": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
                this.buttonPrevPage.setEnabled(true);
                this.buttonNextPage.setEnabled(false);
                this.buttonPrevPage.show();
                this.buttonNextPage.hide();
                break;
            }
            default: {
                super.onButtonClicked(button);
            }
        }
    }
}

