/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blockout.views;

import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.PaneParams;
import com.minecolonies.blockout.views.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchView
extends View {
    @Nullable
    private Pane currentView;

    public SwitchView() {
    }

    public SwitchView(PaneParams params) {
        super(params);
    }

    @Override
    public void parseChildren(@NotNull PaneParams params) {
        super.parseChildren(params);
        String defaultView = params.getStringAttribute("default", null);
        if (defaultView != null) {
            this.setView(defaultView);
        }
    }

    public void setView(String name) {
        for (Pane child : this.children) {
            if (!child.getID().equals(name)) continue;
            this.setCurrentView(child);
            return;
        }
    }

    @Override
    @Nullable
    public Pane findPaneForClick(int mx, int my) {
        if (this.currentView != null && this.currentView.canHandleClick(mx, my)) {
            return this.currentView;
        }
        return null;
    }

    @Override
    protected boolean childIsVisible(Pane child) {
        return child == this.currentView && super.childIsVisible(child);
    }

    @Override
    public void addChild(@NotNull Pane child) {
        super.addChild(child);
        if (this.children.size() == 1) {
            this.currentView = child;
            child.setVisible(true);
        } else {
            child.setVisible(false);
        }
    }

    @Override
    public void adjustChild(@NotNull Pane child) {
        if (child.getWidth() == 0 || child.getHeight() == 0) {
            child.setSize(this.width - child.getX(), this.height - child.getY());
        }
        super.adjustChild(child);
    }

    @Override
    public void removeChild(Pane child) {
        super.removeChild(child);
        if (child == this.currentView) {
            if (this.children.isEmpty()) {
                this.currentView = null;
            } else {
                this.currentView = (Pane)((Object)this.children.get(0));
                this.currentView.setVisible(true);
            }
        }
    }

    @Nullable
    public Pane getCurrentView() {
        return this.currentView;
    }

    private void setCurrentView(Pane pane) {
        if (this.currentView != null) {
            this.currentView.setVisible(false);
        }
        this.currentView = pane;
        this.currentView.setVisible(true);
    }

    public void nextView() {
        if (this.children.isEmpty()) {
            return;
        }
        int index = this.children.indexOf((Object)this.currentView) + 1;
        if (index >= this.children.size()) {
            index = 0;
        }
        this.setCurrentView((Pane)((Object)this.children.get(index)));
    }

    public void previousView() {
        if (this.children.isEmpty()) {
            return;
        }
        int index = this.children.indexOf((Object)this.currentView) - 1;
        if (index < 0) {
            index = this.children.size();
        }
        this.setCurrentView((Pane)((Object)this.children.get(index)));
    }
}

