/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blockout.controls;

import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.PaneParams;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

public class Image
extends Pane {
    public static final int MINECRAFT_DEFAULT_TEXTURE_MAP_SIZE = 256;
    protected ResourceLocation resourceLocation;
    protected int imageOffsetX = 0;
    protected int imageOffsetY = 0;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected int mapWidth = 256;
    protected int mapHeight = 256;
    protected boolean customSized = true;

    public Image() {
    }

    public Image(PaneParams params) {
        super(params);
        PaneParams.SizePair size;
        String source = params.getStringAttribute("source", null);
        if (source != null) {
            this.resourceLocation = new ResourceLocation(source);
            this.loadMapDimensions();
        }
        if ((size = params.getSizePairAttribute("imageoffset", null, null)) != null) {
            this.imageOffsetX = size.getX();
            this.imageOffsetY = size.getY();
        }
        if ((size = params.getSizePairAttribute("imagesize", null, null)) != null) {
            this.imageWidth = size.getX();
            this.imageHeight = size.getY();
        }
    }

    private void loadMapDimensions() {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(this.resourceLocation);
        this.mapWidth = (Integer)dimensions.func_76341_a();
        this.mapHeight = (Integer)dimensions.func_76340_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple<Integer, Integer> getImageDimensions(ResourceLocation resourceLocation) {
        int width = 0;
        int height = 0;
        Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix("png");
        if (it.hasNext()) {
            ImageReader reader = it.next();
            try (ImageInputStream stream = ImageIO.createImageInputStream(Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b());){
                reader.setInput(stream);
                width = reader.getWidth(reader.getMinIndex());
                height = reader.getHeight(reader.getMinIndex());
            }
            catch (IOException e) {
                Log.getLogger().warn((Object)e);
            }
            finally {
                reader.dispose();
            }
        }
        return new Tuple((Object)width, (Object)height);
    }

    public void setImage(String source) {
        this.setImage(source, 0, 0, 0, 0);
    }

    public void setImage(String source, int offsetX, int offsetY, int w, int h) {
        this.setImage(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.resourceLocation = loc;
        this.imageOffsetX = offsetX;
        this.imageOffsetY = offsetY;
        this.imageWidth = w;
        this.imageHeight = h;
        this.loadMapDimensions();
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h, boolean customSized) {
        this.customSized = customSized;
        this.resourceLocation = loc;
        this.imageOffsetX = offsetX;
        this.imageOffsetY = offsetY;
        this.imageWidth = w;
        this.imageHeight = h;
        this.loadMapDimensions();
    }

    public void setImage(ResourceLocation loc) {
        this.setImage(loc, 0, 0, 0, 0);
    }

    @Override
    protected void drawSelf(int mx, int my) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(this.resourceLocation);
        if (this.customSized) {
            Image.func_146110_a((int)this.x, (int)this.y, (float)this.imageOffsetX, (float)this.imageOffsetY, (int)(this.imageWidth != 0 ? this.imageWidth : this.getWidth()), (int)(this.imageHeight != 0 ? this.imageHeight : this.getHeight()), (float)this.mapWidth, (float)this.mapHeight);
        } else {
            this.func_73729_b(this.x, this.y, this.imageOffsetX, this.imageOffsetY, this.imageWidth != 0 ? this.imageWidth : this.getWidth(), this.imageHeight != 0 ? this.imageHeight : this.getHeight());
        }
    }
}

