/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.function.Predicate;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    public static final ItemStack EMPTY = null;
    @NotNull
    public static final Predicate<ItemStack> EMPTY_PREDICATE = ItemStackUtils::isEmpty;
    @NotNull
    public static final Predicate<ItemStack> NOT_EMPTY_PREDICATE = EMPTY_PREDICATE.negate();
    private static final String NBT_TAG_ENCHANT_ID = "id";
    private static final String NBT_TAG_ENCHANT_LEVEL = "lvl";
    private static final int FORTUNE_ENCHANT_ID = 35;
    public static final Predicate<ItemStack> ISFOOD = itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemFood;
    public static final Predicate<ItemStack> IS_SMELTABLE = itemStack -> ItemStackUtils.isEmpty(FurnaceRecipes.func_77602_a().func_151395_a(itemStack)) == false;
    public static final Predicate<ItemStack> ISCOOKABLE = ISFOOD.and(IS_SMELTABLE);

    private ItemStackUtils() {
    }

    public static boolean hasToolLevel(@Nullable ItemStack stack, IToolType toolType, int minimalLevel, int maximumLevel) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        int level = Compatibility.isTinkersWeapon(stack) ? Compatibility.getToolLevel(stack) : ItemStackUtils.getMiningLevel(stack, toolType);
        return ItemStackUtils.isTool(stack, toolType) && ItemStackUtils.verifyToolLevel(stack, level, minimalLevel, maximumLevel);
    }

    @NotNull
    public static Boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack == EMPTY || stack.field_77994_a <= 0;
    }

    public static int getMiningLevel(@Nullable ItemStack stack, @Nullable IToolType toolType) {
        if (toolType == ToolType.NONE) {
            return stack == null ? 0 : 1;
        }
        if (!Compatibility.getMiningLevelCompatibility(stack, toolType.toString()) || ItemStackUtils.isEmpty(stack).booleanValue()) {
            return -1;
        }
        if (ToolType.HOE.equals(toolType)) {
            if (stack.func_77973_b() instanceof ItemHoe) {
                ItemHoe itemHoe = (ItemHoe)stack.func_77973_b();
                return ItemStackUtils.getToolLevel(itemHoe.func_77842_f());
            }
        } else if (ToolType.SWORD.equals(toolType)) {
            if (stack.func_77973_b() instanceof ItemSword) {
                ItemSword itemSword = (ItemSword)stack.func_77973_b();
                return ItemStackUtils.getToolLevel(itemSword.func_150932_j());
            }
        } else {
            if (!toolType.hasVariableMaterials()) {
                return 1;
            }
            return stack.func_77973_b().getHarvestLevel(stack, toolType.getName(), null, null);
        }
        return -1;
    }

    public static boolean isTool(@Nullable ItemStack itemStack, IToolType toolType) {
        if (ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            return false;
        }
        boolean isATool = false;
        if (ToolType.AXE.equals(toolType) || ToolType.SHOVEL.equals(toolType) || ToolType.PICKAXE.equals(toolType)) {
            isATool = ItemStackUtils.getMiningLevel(itemStack, toolType) >= 0;
        } else if (ToolType.HOE.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ItemHoe;
        } else if (ToolType.BOW.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ItemBow;
        } else if (ToolType.SWORD.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ItemSword || Compatibility.isTinkersWeapon(itemStack);
        } else if (ToolType.FISHINGROD.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ItemFishingRod;
        } else if (ToolType.SHEARS.equals(toolType)) {
            isATool = itemStack.func_77973_b() instanceof ItemShears;
        }
        return isATool;
    }

    public static boolean verifyToolLevel(@NotNull ItemStack itemStack, int toolLevel, int minimalLevel, int maximumLevel) {
        if (toolLevel < minimalLevel) {
            return false;
        }
        return toolLevel + ItemStackUtils.getMaxEnchantmentLevel(itemStack) <= maximumLevel;
    }

    private static int getToolLevel(String material) {
        if ("WOOD".equals(material) || "GOLD".equals(material)) {
            return 0;
        }
        if ("STONE".equals(material)) {
            return 1;
        }
        if ("IRON".equals(material)) {
            return 2;
        }
        if ("DIAMOND".equals(material)) {
            return 3;
        }
        return -1;
    }

    public static int getMaxEnchantmentLevel(ItemStack itemStack) {
        NBTTagList nbttaglist;
        if (itemStack == null) {
            return 0;
        }
        short maxLevel = 0;
        if (itemStack != null && (nbttaglist = itemStack.func_77986_q()) != null) {
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                short level = nbttaglist.func_150305_b(j).func_74765_d(NBT_TAG_ENCHANT_LEVEL);
                maxLevel = level > maxLevel ? level : maxLevel;
            }
        }
        return maxLevel;
    }

    public static int getFortuneOf(@Nullable ItemStack tool) {
        if (tool == null) {
            return 0;
        }
        int fortune = 0;
        if (tool.func_77948_v()) {
            NBTTagList t = tool.func_77986_q();
            for (int i = 0; i < t.func_74745_c(); ++i) {
                short id = t.func_150305_b(i).func_74765_d(NBT_TAG_ENCHANT_ID);
                if (id != 35) continue;
                fortune = t.func_150305_b(i).func_74765_d(NBT_TAG_ENCHANT_LEVEL);
            }
        }
        return fortune;
    }

    public static boolean doesItemServeAsWeapon(@NotNull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || Compatibility.isTinkersWeapon(stack);
    }

    public static String swapToolGrade(int toolGrade) {
        switch (toolGrade) {
            case 0: {
                return "Wood or Gold";
            }
            case 1: {
                return "Stone";
            }
            case 2: {
                return "Iron";
            }
            case 3: {
                return "Diamond";
            }
        }
        return "Better than Diamond";
    }

    @NotNull
    public static Boolean areItemStacksMergable(ItemStack existingStack, ItemStack mergingStack) {
        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(existingStack, mergingStack).booleanValue()) {
            return false;
        }
        return existingStack.func_77976_d() >= ItemStackUtils.getSize(existingStack) + ItemStackUtils.getSize(mergingStack);
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    @NotNull
    public static int getSize(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.field_77994_a;
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchMeta, boolean matchNBT) {
        if (!(ItemStackUtils.isEmpty(itemStack1).booleanValue() || ItemStackUtils.isEmpty(itemStack2).booleanValue() || itemStack1.func_77973_b() != itemStack2.func_77973_b() || itemStack1.func_77952_i() != itemStack2.func_77952_i() && matchMeta)) {
            if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                return ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2) || !matchNBT;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static void setSize(@NotNull ItemStack stack, int size) {
        stack.field_77994_a = size;
    }

    public static void changeSize(@NotNull ItemStack stack, int amount) {
        stack.field_77994_a += amount;
    }

    @NotNull
    public static ItemStack deserializeFromNBT(@NotNull NBTTagCompound compound) {
        return ItemStack.func_77949_a((NBTTagCompound)compound);
    }

    public boolean isPreferrableFuel(@NotNull ItemStack stack) {
        return stack.func_185136_b(new ItemStack(Items.field_151044_h)) || stack.func_185136_b(new ItemStack(Blocks.field_150364_r)) || stack.func_185136_b(new ItemStack(Blocks.field_150363_s));
    }
}

