/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    private static final double SPAWN_MODIFIER = 0.8;
    private static final double SPAWN_ADDITION = 0.1;
    private static final int MAX_RANDOM_SPAWN = 21;
    private static final int MIN_RANDOM_SPAWN = 10;
    private static final double MOTION_MULTIPLIER = (double)0.05f;
    private static final double MOTION_Y_MIN = (double)0.2f;

    private InventoryUtils() {
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Block block, int metaData) {
        return InventoryUtils.filterItemHandler(itemHandler, stack -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block), metaData));
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue() || !itemStackSelectionPredicate.test(stack)) continue;
            filtered.add(stack);
        }
        return filtered;
    }

    private static boolean compareItems(@Nullable ItemStack itemStack, Item targetItem, int itemDamage) {
        return ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() == targetItem && (itemStack.func_77952_i() == itemDamage || itemDamage == -1);
    }

    public static Item getItemFromBlock(Block block) {
        return Item.func_150898_a((Block)block);
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.filterItemHandler(itemHandler, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemStackSelectionPredicate.test(itemHandler.getStackInSlot(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static int getItemCountInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Block block, int itemDamage) {
        return InventoryUtils.getItemCountInItemHandler(itemHandler, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int getItemCountInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInItemHandler(itemHandler, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int getItemCountInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.filterItemHandler(itemHandler, itemStackSelectionPredicate).stream().mapToInt(ItemStackUtils::getSize).sum();
    }

    public static boolean hasItemInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Block block, int itemDamage) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static boolean hasItemInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Item item, int itemDamage) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, stack -> InventoryUtils.compareItems(stack, item, itemDamage));
    }

    public static boolean hasItemInItemHandler(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getItemCountInItemHandler(itemHandler, itemStackSelectionPredicate) > 0;
    }

    public static boolean isItemHandlerFull(@NotNull IItemHandler itemHandler) {
        return InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler) == -1;
    }

    public static int getFirstOpenSlotFromItemHandler(@NotNull IItemHandler itemHandler) {
        return IntStream.range(0, itemHandler.getSlots()).filter(slot -> ItemStackUtils.isEmpty(itemHandler.getStackInSlot(slot))).findFirst().orElse(-1);
    }

    @Nullable
    public static ItemStack forceItemStackToItemHandler(@NotNull IItemHandler itemHandler, @NotNull ItemStack itemStack, @NotNull Predicate<ItemStack> itemStackToKeepPredicate) {
        ItemStack standardInsertionResult = InventoryUtils.addItemStackToItemHandlerWithResult(itemHandler, itemStack);
        if (!ItemStackUtils.isEmpty(standardInsertionResult).booleanValue()) {
            for (int i = 0; i < itemHandler.getSlots() && !ItemStackUtils.isEmpty(standardInsertionResult).booleanValue(); ++i) {
                ItemStack localStack = itemHandler.getStackInSlot(i);
                if (!ItemStackUtils.isEmpty(localStack).booleanValue() && itemStackToKeepPredicate.test(localStack)) continue;
                ItemStack removedStack = itemHandler.extractItem(i, Integer.MAX_VALUE, false);
                ItemStack localInsertionResult = itemHandler.insertItem(i, standardInsertionResult, false);
                if (ItemStackUtils.isEmpty(localInsertionResult).booleanValue()) {
                    return removedStack.func_77946_l();
                }
                itemHandler.insertItem(i, removedStack, false);
            }
        }
        return standardInsertionResult;
    }

    public static int getAmountOfStacksInItemHandler(@NotNull IItemHandler itemHandler) {
        return InventoryUtils.getItemHandlerAsList(itemHandler).size();
    }

    @NotNull
    public static List<ItemStack> getItemHandlerAsList(@NotNull IItemHandler itemHandler) {
        return InventoryUtils.filterItemHandler(itemHandler, stack -> true);
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, Block block, int metaData) {
        return InventoryUtils.filterProvider(provider, stack -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block), metaData));
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getFromProviderForAllSides(provider, itemStackSelectionPredicate);
    }

    @NotNull
    private static List<ItemStack> getFromProviderForAllSides(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> predicate) {
        ArrayList<ItemStack> combinedList = new ArrayList<ItemStack>();
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            if (handler == null) continue;
            combinedList.addAll(InventoryUtils.filterItemHandler(handler, predicate));
        }
        return combinedList;
    }

    @NotNull
    public static Set<IItemHandler> getItemHandlersFromProvider(@NotNull ICapabilityProvider provider) {
        IItemHandler nullHandler;
        Set<IItemHandler> handlerList = Arrays.stream(EnumFacing.field_82609_l).filter(facing -> provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)).map(facing -> (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)).collect(Collectors.toSet());
        if (provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && !handlerList.contains(nullHandler = (IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))) {
            handlerList.add(nullHandler);
        }
        return handlerList;
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, @Nullable Item targetItem, int itemDamage) {
        return InventoryUtils.filterProvider(provider, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int findFirstSlotInProviderWith(@NotNull ICapabilityProvider provider, Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderWith(provider, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int findFirstSlotInProviderWith(@NotNull ICapabilityProvider provider, Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderWith(provider, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int findFirstSlotInProviderWith(@NotNull ICapabilityProvider provider, Predicate<ItemStack> itemStackSelectionPredicate) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int foundSlot = InventoryUtils.findFirstSlotInItemHandlerWith(handler, itemStackSelectionPredicate);
            if (foundSlot <= -1) continue;
            return foundSlot;
        }
        return -1;
    }

    public static int findFirstSlotInProviderNotEmptyWith(@NotNull ICapabilityProvider provider, Predicate<ItemStack> itemStackSelectionPredicate) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int foundSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStackSelectionPredicate);
            if (foundSlot <= -1) continue;
            return foundSlot;
        }
        return -1;
    }

    public static int findFirstSlotInItemHandlerNotEmptyWith(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        Predicate<ItemStack> firstWorthySlotPredicate = ItemStackUtils.NOT_EMPTY_PREDICATE.and(itemStackSelectionPredicate);
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!firstWorthySlotPredicate.test(itemHandler.getStackInSlot(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Block block, int itemDamage) {
        return InventoryUtils.getItemCountInProvider(provider, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInProvider(provider, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().filter(Objects::nonNull).mapToInt(handler -> InventoryUtils.filterItemHandler(handler, itemStackSelectionPredicate).stream().mapToInt(ItemStackUtils::getSize).sum()).sum();
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider2, @NotNull Block block, int itemDamage) {
        return InventoryUtils.hasItemInProvider(Provider2, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider2, @NotNull Item item, int itemDamage) {
        return InventoryUtils.hasItemInProvider(Provider2, stack -> InventoryUtils.compareItems(stack, item, itemDamage));
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider2, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getItemCountInProvider(Provider2, itemStackSelectionPredicate) > 0;
    }

    public static boolean isProviderFull(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getFirstOpenSlotFromProvider(provider) == -1;
    }

    public static int getFirstOpenSlotFromProvider(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().mapToInt(InventoryUtils::getFirstOpenSlotFromItemHandler).filter(slotIndex -> slotIndex > -1).findFirst().orElse(-1);
    }

    public static boolean isToolInProvider(@NotNull ICapabilityProvider provider, @NotNull IToolType toolType, int minimalLevel, int maximumLevel) {
        return InventoryUtils.hasItemInProvider(provider, stack -> ItemStackUtils.hasToolLevel(stack, toolType, minimalLevel, maximumLevel));
    }

    public static boolean addItemStackToProvider(@NotNull ICapabilityProvider provider, @Nullable ItemStack itemStack) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().anyMatch(handler -> InventoryUtils.addItemStackToItemHandler(handler, itemStack));
    }

    public static boolean addItemStackToItemHandler(@NotNull IItemHandler itemHandler, @Nullable ItemStack itemStack) {
        if (!ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            int slot;
            if (itemStack.func_77951_h()) {
                int slot2 = InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler);
                if (slot2 >= 0) {
                    itemHandler.insertItem(slot2, itemStack, false);
                    return true;
                }
                return false;
            }
            ItemStack resultStack = itemStack;
            int n = slot = itemHandler.getSlots() == 0 ? -1 : 0;
            while (!ItemStackUtils.isEmpty(resultStack).booleanValue() && slot != -1 && slot != itemHandler.getSlots()) {
                if (ItemStackUtils.isEmpty(resultStack = itemHandler.insertItem(slot, resultStack, false)).booleanValue()) continue;
                ++slot;
            }
            return ItemStackUtils.isEmpty(resultStack);
        }
        return false;
    }

    public static ItemStack addItemStackToProviderWithResult(@NotNull ICapabilityProvider provider, @Nullable ItemStack itemStack) {
        ItemStack activeStack = itemStack;
        if (ItemStackUtils.isEmpty(activeStack).booleanValue()) {
            return ItemStackUtils.EMPTY;
        }
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            activeStack = InventoryUtils.addItemStackToItemHandlerWithResult(handler, activeStack);
        }
        return activeStack;
    }

    public static ItemStack addItemStackToItemHandlerWithResult(@NotNull IItemHandler itemHandler, @Nullable ItemStack itemStack) {
        if (!ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            int slot;
            if (itemStack.func_77951_h()) {
                int slot2 = InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler);
                if (slot2 >= 0) {
                    itemHandler.insertItem(slot2, itemStack, false);
                    return ItemStackUtils.EMPTY;
                }
                return itemStack;
            }
            ItemStack resultStack = itemStack;
            int n = slot = itemHandler.getSlots() == 0 ? -1 : 0;
            while (!ItemStackUtils.isEmpty(resultStack).booleanValue() && slot != -1 && slot != itemHandler.getSlots()) {
                if (ItemStackUtils.isEmpty(resultStack = itemHandler.insertItem(slot, resultStack, false)).booleanValue()) continue;
                ++slot;
            }
            return resultStack;
        }
        return itemStack;
    }

    @Nullable
    public static ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack, @NotNull Predicate<ItemStack> itemStackToKeepPredicate) {
        ItemStack standardInsertionResult = InventoryUtils.addItemStackToProviderWithResult(provider, itemStack);
        if (!ItemStackUtils.isEmpty(standardInsertionResult).booleanValue()) {
            ItemStack resultStack = standardInsertionResult.func_77946_l();
            Iterator<IItemHandler> iterator = InventoryUtils.getItemHandlersFromProvider(provider).iterator();
            while (iterator.hasNext() && !ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                resultStack = InventoryUtils.forceItemStackToItemHandler(iterator.next(), resultStack, itemStackToKeepPredicate);
            }
            return resultStack;
        }
        return ItemStackUtils.EMPTY;
    }

    public static int getAmountOfStacksInProvider(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getProviderAsList(provider).size();
    }

    @NotNull
    public static List<ItemStack> getProviderAsList(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.filterProvider(provider, stack -> true);
    }

    @NotNull
    public static boolean hasProviderIItemHandler(@NotNull ICapabilityProvider provider) {
        return !InventoryUtils.getItemHandlersFromProvider(provider).isEmpty();
    }

    @NotNull
    public static boolean isProviderSided(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getItemHandlersFromProvider(provider).size() > 1;
    }

    @NotNull
    public static List<ItemStack> getInventoryAsListFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), stack -> true);
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Block block, int metaData) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), stack -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block), metaData));
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return Collections.emptyList();
        }
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), itemStackSelectionPredicate);
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderForSideWith(provider, facing, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderForSideWith(provider, facing, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return -1;
        }
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), itemStackSelectionPredicate);
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Block block, int itemDamage) {
        return InventoryUtils.getItemCountInProviderForSide(provider, facing, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInProviderForSide(provider, facing, stack -> InventoryUtils.compareItems(stack, targetItem, itemDamage));
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return 0;
        }
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), itemStackSelectionPredicate).stream().mapToInt(ItemStackUtils::getSize).sum();
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Block block, int itemDamage) {
        return InventoryUtils.hasItemInProviderForSide(provider, facing, InventoryUtils.getItemFromBlock(block), itemDamage);
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Item item, int itemDamage) {
        return InventoryUtils.hasItemInProviderForSide(provider, facing, stack -> InventoryUtils.compareItems(stack, item, itemDamage));
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return false;
        }
        return InventoryUtils.getItemCountInItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), itemStackSelectionPredicate) > 0;
    }

    public static boolean isProviderFull(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing) {
        return InventoryUtils.getFirstOpenSlotFromProviderForSide(provider, facing) == -1;
    }

    public static int getFirstOpenSlotFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return -1;
        }
        return InventoryUtils.getFirstOpenSlotFromItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing));
    }

    public static boolean isToolInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable EnumFacing facing, @NotNull IToolType toolType, int minimalLevel, int maximumLevel) {
        if (!provider.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            return false;
        }
        return InventoryUtils.isToolInItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing), toolType, minimalLevel, maximumLevel);
    }

    public static boolean isToolInItemHandler(@NotNull IItemHandler itemHandler, @NotNull IToolType toolType, int minimalLevel, int maximumLevel) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, stack -> ItemStackUtils.hasToolLevel(stack, toolType, minimalLevel, maximumLevel));
    }

    public static void clearItemHandler(@NotNull IItemHandler itemHandler) {
        for (int slotIndex = 0; slotIndex < itemHandler.getSlots(); ++slotIndex) {
            itemHandler.extractItem(slotIndex, Integer.MAX_VALUE, false);
        }
    }

    public static int getFirstSlotOfItemHandlerContainingTool(@NotNull IItemHandler itemHandler, @NotNull IToolType toolType, int minimalLevel, int maximumLevel) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, stack -> ItemStackUtils.hasToolLevel(stack, toolType, minimalLevel, maximumLevel));
    }

    public static boolean hasItemHandlerToolWithLevel(@NotNull IItemHandler itemHandler, IToolType toolType, int requiredLevel, int maximumLevel) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.isTool(stack, toolType) && ItemStackUtils.verifyToolLevel(stack, ItemStackUtils.getMiningLevel(stack, toolType), requiredLevel, maximumLevel)) > -1;
    }

    public static boolean transferItemStackIntoNextFreeSlotInProvider(@NotNull IItemHandler sourceHandler, @NotNull int sourceIndex, @NotNull ICapabilityProvider targetProvider) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(targetProvider)) {
            if (!InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers(sourceHandler, sourceIndex, handler)) continue;
            return true;
        }
        return false;
    }

    public static boolean transferItemStackIntoNextFreeSlotInItemHandlers(@NotNull IItemHandler sourceHandler, @NotNull int sourceIndex, @NotNull IItemHandler targetHandler) {
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, true);
        if (ItemStackUtils.isEmpty(sourceStack).booleanValue()) {
            return true;
        }
        ItemStack originalStack = sourceStack.func_77946_l();
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            if (!ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, false);
            return true;
        }
        if (!ItemStack.func_77989_b((ItemStack)sourceStack, (ItemStack)originalStack) && ItemStackUtils.compareItemStacksIgnoreStackSize(sourceStack, originalStack).booleanValue()) {
            int usedAmount = ItemStackUtils.getSize(sourceStack) - ItemStackUtils.getSize(originalStack);
            sourceHandler.extractItem(sourceIndex, usedAmount, false);
            return true;
        }
        return false;
    }

    public static boolean transferXOfFirstSlotInProviderWithIntoNextFreeSlotInProvider(@NotNull ICapabilityProvider sourceProvider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, @NotNull int amount, @NotNull ICapabilityProvider targetProvider) {
        return InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInProviderWithResult(sourceProvider, itemStackSelectionPredicate, amount, targetProvider) == 0;
    }

    public static int transferXOfFirstSlotInProviderWithIntoNextFreeSlotInProviderWithResult(@NotNull ICapabilityProvider sourceProvider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, @NotNull int amount, @NotNull ICapabilityProvider targetProvider) {
        int currentAmount = amount;
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(targetProvider)) {
            currentAmount = InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandlerWithResult(sourceProvider, itemStackSelectionPredicate, amount, handler);
            if (currentAmount > 0) continue;
            return 0;
        }
        return currentAmount;
    }

    public static boolean transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(@NotNull ICapabilityProvider sourceProvider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, @NotNull int amount, @NotNull IItemHandler targetHandler) {
        return InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandlerWithResult(sourceProvider, itemStackSelectionPredicate, amount, targetHandler) == 0;
    }

    public static int transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandlerWithResult(@NotNull ICapabilityProvider sourceProvider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, @NotNull int amount, @NotNull IItemHandler targetHandler) {
        int currentAmount = amount;
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(sourceProvider)) {
            currentAmount = InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandlerWithResult(handler, itemStackSelectionPredicate, currentAmount, targetHandler);
            if (currentAmount > 0) continue;
            return 0;
        }
        return currentAmount;
    }

    public static boolean transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler(@NotNull IItemHandler sourceHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, @NotNull int amount, @NotNull IItemHandler targetHandler) {
        return InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandlerWithResult(sourceHandler, itemStackSelectionPredicate, amount, targetHandler) == 0;
    }

    public static int transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandlerWithResult(@NotNull IItemHandler sourceHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, @NotNull int amount, @NotNull IItemHandler targetHandler) {
        int desiredItemSlot;
        int currentAmount = amount;
        int tries = 0;
        while (currentAmount > 0 && ++tries <= sourceHandler.getSlots() && (desiredItemSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(sourceHandler, itemStackSelectionPredicate::test)) != -1) {
            ItemStack returnStack = sourceHandler.extractItem(desiredItemSlot, currentAmount, false);
            if (ItemStackUtils.isEmpty(returnStack).booleanValue()) continue;
            currentAmount -= returnStack.field_77994_a;
            if (InventoryUtils.addItemStackToItemHandler(targetHandler, returnStack)) continue;
            break;
        }
        return currentAmount;
    }

    public static boolean transferXOfFirstSlotInItemHandlerWithIntoInItemHandler(IItemHandler sourceHandler, Predicate<ItemStack> itemStackSelectionPredicate, int amount, IItemHandler targetHandler, int slot) {
        int desiredItemSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(sourceHandler, itemStackSelectionPredicate::test);
        if (desiredItemSlot == -1) {
            return false;
        }
        ItemStack returnStack = sourceHandler.extractItem(desiredItemSlot, amount, false);
        if (ItemStackUtils.isEmpty(returnStack).booleanValue()) {
            return false;
        }
        targetHandler.insertItem(slot, returnStack, false);
        return true;
    }

    public static boolean transferItemStackIntoNextFreeSlotFromProvider(@NotNull ICapabilityProvider sourceProvider, @NotNull int sourceIndex, @NotNull IItemHandler targetHandler) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(sourceProvider)) {
            if (!InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandlers(handler, sourceIndex, targetHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean swapItemStacksInItemHandlers(@NotNull IItemHandler sourceHandler, @NotNull int sourceIndex, @NotNull IItemHandler targetHandler, @NotNull int targetIndex) {
        ItemStack targetStack = targetHandler.extractItem(targetIndex, Integer.MAX_VALUE, false);
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, true);
        ItemStack resultSourceSimulationInsertion = targetHandler.insertItem(targetIndex, sourceStack, true);
        if (ItemStackUtils.isEmpty(resultSourceSimulationInsertion).booleanValue() || ItemStackUtils.isEmpty(targetStack).booleanValue()) {
            targetHandler.insertItem(targetIndex, sourceStack, false);
            sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, false);
            sourceHandler.insertItem(sourceIndex, targetStack, false);
            return true;
        }
        targetHandler.insertItem(targetIndex, targetStack, false);
        return false;
    }

    public static boolean removeStacksFromProvider(ICapabilityProvider provider, List<ItemStack> input) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            if (InventoryUtils.removeStacksFromItemHandler(handler, input)) continue;
            return false;
        }
        return true;
    }

    public static boolean removeStacksFromItemHandler(IItemHandler handler, List<ItemStack> input) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int maxTries = 0;
        for (ItemStack stack : input) {
            maxTries += ItemStackUtils.getSize(stack);
            list.add(stack.func_77946_l());
        }
        boolean success = true;
        int i = 0;
        int tries = 0;
        while (i < list.size() && tries < maxTries) {
            ItemStack stack = (ItemStack)list.get(i);
            int slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, arg_0 -> ((ItemStack)stack).func_77969_a(arg_0));
            if (slot == -1) {
                success = false;
                ++i;
                continue;
            }
            int removedSize = ItemStackUtils.getSize(handler.extractItem(slot, ItemStackUtils.getSize(stack), false));
            if (removedSize == ItemStackUtils.getSize(stack)) {
                ++i;
            } else {
                ItemStackUtils.changeSize(stack, -removedSize);
            }
            ++tries;
        }
        return success && i >= list.size();
    }

    public static boolean removeStackFromItemHandler(IItemHandler handler, ItemStack input) {
        int maxTries = 0;
        maxTries += ItemStackUtils.getSize(input);
        boolean success = true;
        int i = 0;
        int tries = 0;
        while (tries < maxTries) {
            int slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, arg_0 -> ((ItemStack)input).func_77969_a(arg_0));
            if (slot == -1) {
                success = false;
                ++i;
                continue;
            }
            int removedSize = ItemStackUtils.getSize(handler.extractItem(slot, ItemStackUtils.getSize(input), false));
            if (removedSize == ItemStackUtils.getSize(input)) {
                ++i;
            } else {
                ItemStackUtils.changeSize(input, -removedSize);
            }
            ++tries;
        }
        return success && i >= 1;
    }

    public static int findSlotInProviderNotFullWithItem(ICapabilityProvider provider, Item item, int itemDamage, int amount) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int foundSlot = InventoryUtils.findSlotInItemHandlerNotFullWithItem(handler, stack -> InventoryUtils.compareItems(stack, item, itemDamage), amount);
            if (foundSlot <= -1) continue;
            return foundSlot;
        }
        return -1;
    }

    public static int findSlotInItemHandlerNotFullWithItem(IItemHandler handler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, int amount) {
        boolean foundEmptySlot = false;
        boolean foundItem = false;
        int itemSlot = -1;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                foundEmptySlot = true;
            } else if (itemStackSelectionPredicate.test(stack)) {
                if (ItemStackUtils.getSize(stack) + amount <= 64) {
                    foundEmptySlot = true;
                }
                foundItem = true;
                itemSlot = slot;
            }
            if (!foundItem || !foundEmptySlot) continue;
            return itemSlot;
        }
        return -1;
    }

    public static void dropItemHandler(IItemHandler handler, World world, int x, int y, int z) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemstack = handler.getStackInSlot(i);
            if (itemstack == null) continue;
            InventoryUtils.spawnItemStack(world, x, y, z, itemstack);
        }
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        Random random = new Random();
        double spawnX = random.nextDouble() * 0.8 + 0.1;
        double spawnY = random.nextDouble() * 0.8 + 0.1;
        double spawnZ = random.nextDouble() * 0.8 + 0.1;
        while (stack.field_77994_a > 0) {
            int randomSplitStackSize = random.nextInt(21) + 10;
            EntityItem entityitem = new EntityItem(worldIn, x + spawnX, y + spawnY, z + spawnZ, stack.func_77979_a(randomSplitStackSize));
            entityitem.field_70159_w = random.nextGaussian() * (double)0.05f;
            entityitem.field_70181_x = random.nextGaussian() * (double)0.05f + (double)0.2f;
            entityitem.field_70179_y = random.nextGaussian() * (double)0.05f;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }
}

