/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.pathfinding;

import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWalkToProxy
implements IWalkToProxy {
    private static final int MIN_RANGE_FOR_DIRECT_PATH = 400;
    private static final int MIN_DISTANCE = 25;
    private final EntityLiving entity;
    private final List<BlockPos> proxyList = new ArrayList<BlockPos>();
    private BlockPos currentProxy;
    private BlockPos target;

    protected AbstractWalkToProxy(EntityLiving entity) {
        this.entity = entity;
    }

    @Override
    public boolean walkToBlock(@NotNull BlockPos target, int range) {
        return this.walkToBlock(target, range, false);
    }

    @Override
    public boolean walkToBlock(@NotNull BlockPos target, int range, boolean onMove) {
        double distanceProxyNextProxy;
        double distanceToPath;
        if (!target.equals((Object)this.target)) {
            this.resetProxyList();
            this.target = target;
        }
        double d = distanceToPath = this.careAboutY() ? (double)BlockPosUtil.getDistanceSquared2D(this.entity.func_180425_c(), target) : (double)BlockPosUtil.getDistanceSquared(this.entity.func_180425_c(), target);
        if (distanceToPath <= 400.0) {
            this.currentProxy = distanceToPath <= 25.0 ? null : target;
            this.resetProxyList();
            return this.takeTheDirectPath(target, range, onMove);
        }
        if (this.currentProxy == null) {
            this.currentProxy = this.fillProxyList(target, distanceToPath);
        }
        double distanceToProxy = BlockPosUtil.getDistanceSquared2D(this.entity.func_180425_c(), this.currentProxy);
        double distanceToNextProxy = this.proxyList.isEmpty() ? (double)BlockPosUtil.getDistanceSquared2D(this.entity.func_180425_c(), target) : (double)BlockPosUtil.getDistanceSquared2D(this.entity.func_180425_c(), this.proxyList.get(0));
        double d2 = distanceProxyNextProxy = this.proxyList.isEmpty() ? (double)BlockPosUtil.getDistanceSquared2D(this.currentProxy, target) : (double)BlockPosUtil.getDistanceSquared2D(this.currentProxy, this.proxyList.get(0));
        if (distanceToProxy < 25.0 || distanceToNextProxy < distanceProxyNextProxy) {
            if (this.proxyList.isEmpty()) {
                this.currentProxy = target;
                return this.takeTheDirectPath(target, range, onMove);
            }
            this.entity.func_70661_as().func_75499_g();
            this.currentProxy = this.proxyList.get(0);
            this.proxyList.remove(0);
        }
        if (this.currentProxy != null && !this.isLivingAtSiteWithMove(this.entity, this.currentProxy.func_177958_n(), this.currentProxy.func_177956_o(), this.currentProxy.func_177952_p(), range)) {
            return !onMove;
        }
        return !onMove;
    }

    @Override
    public List<BlockPos> getProxyList() {
        return new ArrayList<BlockPos>(this.proxyList);
    }

    @Override
    public void addToProxyList(BlockPos pos) {
        this.proxyList.add(pos);
    }

    @Override
    public boolean isLivingAtSiteWithMove(EntityLiving entity, int x, int y, int z, int range) {
        if (!EntityUtils.isLivingAtSiteWithMove(entity, x, y, z, range)) {
            EntityUtils.tryMoveLivingToXYZ(entity, x, y, z);
            return false;
        }
        return true;
    }

    @Override
    public EntityLiving getEntity() {
        return this.entity;
    }

    private boolean takeTheDirectPath(@NotNull BlockPos target, int range, boolean onMove) {
        boolean arrived;
        if (onMove) {
            int targetY = this.careAboutY() ? this.entity.func_180425_c().func_177956_o() : target.func_177956_o();
            arrived = this.isLivingAtSiteWithMove(this.entity, target.func_177958_n(), target.func_177956_o(), target.func_177952_p(), range) || EntityUtils.isLivingAtSite(this.entity, target.func_177958_n(), targetY, target.func_177952_p(), range + 1);
        } else {
            boolean bl = arrived = !EntityUtils.isLivingAtSite(this.entity, target.func_177958_n(), target.func_177956_o(), target.func_177952_p(), range);
        }
        if (arrived) {
            this.target = null;
        }
        return arrived;
    }

    @NotNull
    private BlockPos fillProxyList(@NotNull BlockPos target, double distanceToPath) {
        BlockPos proxyPoint = this.getSpecializedProxy(target, distanceToPath);
        if (proxyPoint == null) {
            proxyPoint = this.getProxy(target, this.entity.func_180425_c(), distanceToPath);
        }
        if (!this.proxyList.isEmpty()) {
            this.proxyList.remove(0);
        }
        return proxyPoint;
    }

    private void resetProxyList() {
        this.currentProxy = null;
        this.proxyList.clear();
    }

    @NotNull
    protected BlockPos getProxy(@NotNull BlockPos target, @NotNull BlockPos position, double distanceToPath) {
        double weight = Double.MAX_VALUE;
        BlockPos proxyPoint = null;
        double distance = Double.MAX_VALUE;
        for (BlockPos wayPoint : this.getWayPoints()) {
            double simpleDistance = BlockPosUtil.getDistanceSquared(position, wayPoint);
            double currentWeight = simpleDistance * simpleDistance + (double)BlockPosUtil.getDistanceSquared(wayPoint, target);
            if (!(currentWeight < weight) || !((double)BlockPosUtil.getDistanceSquared2D(wayPoint, target) < distanceToPath) || !(simpleDistance > 25.0) || !(simpleDistance < distanceToPath) || this.proxyList.contains(proxyPoint)) continue;
            proxyPoint = wayPoint;
            weight = currentWeight;
            distance = simpleDistance;
        }
        if (this.proxyList.contains(proxyPoint)) {
            return target;
        }
        if (proxyPoint != null) {
            this.proxyList.add(proxyPoint);
            this.getProxy(target, proxyPoint, distanceToPath - distance);
            return this.proxyList.get(0);
        }
        return target;
    }

    @Override
    public void reset() {
        this.target = null;
    }
}

