/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.util.ItemStackUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorage {
    private final ItemStack stack;
    private final boolean ignoreDamageValue;
    private int amount;

    public ItemStorage(@NotNull ItemStack stack, int amount, boolean ignoreDamageValue) {
        this.stack = stack;
        this.ignoreDamageValue = ignoreDamageValue;
        this.amount = amount;
    }

    public ItemStorage(@NotNull ItemStack stack, boolean ignoreDamageValue) {
        this.stack = stack;
        this.ignoreDamageValue = ignoreDamageValue;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(@NotNull ItemStack stack) {
        this.stack = stack;
        this.ignoreDamageValue = false;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public static ItemStorage getItemStackOfListMatchingPredicate(List<ItemStorage> list, Predicate<ItemStack> predicate) {
        for (ItemStorage stack : list) {
            if (!predicate.test(stack.getItemStack())) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean ignoreDamageValue() {
        return this.ignoreDamageValue;
    }

    public int hashCode() {
        return 31 * this.getItem().hashCode() + (this.ignoreDamageValue ? 0 : this.getDamageValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return this.getItem().equals(that.getItem()) && (this.ignoreDamageValue || that.getDamageValue() == this.getDamageValue());
    }

    @NotNull
    public Item getItem() {
        return this.stack.func_77973_b();
    }

    public int getDamageValue() {
        return this.stack.func_77952_i();
    }
}

