/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class Tool
implements IDeliverable {
    private static final String NBT_TYPE = "Type";
    private static final String NBT_MIN_LEVEL = "MinLevel";
    private static final String NBT_MAX_LEVEL = "MaxLevel";
    private static final String NBT_RESULT = "Result";
    @NotNull
    private final IToolType toolClass;
    @NotNull
    private final Integer minLevel;
    @NotNull
    private final Integer maxLevel;
    @NotNull
    private ItemStack result;

    public Tool(@NotNull IToolType toolClass, @NotNull Integer minLevel, @NotNull Integer maxLevel) {
        this(toolClass, minLevel, maxLevel, ItemStackUtils.EMPTY);
    }

    public Tool(@NotNull IToolType toolClass, @NotNull Integer minLevel, @NotNull Integer maxLevel, ItemStack result) {
        this.toolClass = toolClass;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.result = result;
    }

    @NotNull
    public static NBTTagCompound serialize(IFactoryController controller, Tool tool) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a(NBT_TYPE, tool.getToolClass().getName());
        compound.func_74768_a(NBT_MIN_LEVEL, tool.getMinLevel().intValue());
        compound.func_74768_a(NBT_MAX_LEVEL, tool.getMaxLevel().intValue());
        if (tool.getResult() != null) {
            compound.func_74782_a(NBT_RESULT, (NBTBase)tool.getResult().serializeNBT());
        }
        return compound;
    }

    @NotNull
    public IToolType getToolClass() {
        return this.toolClass;
    }

    @NotNull
    public Integer getMinLevel() {
        return this.minLevel;
    }

    @NotNull
    public Integer getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public static Tool deserialize(IFactoryController controller, NBTTagCompound nbt) {
        IToolType type = ToolType.getToolType(nbt.func_74779_i(NBT_TYPE));
        Integer minLevel = nbt.func_74762_e(NBT_MIN_LEVEL);
        Integer maxLevel = nbt.func_74762_e(NBT_MAX_LEVEL);
        ItemStack result = nbt.func_74764_b(NBT_RESULT) ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l(NBT_RESULT)) : null;
        return new Tool(type, minLevel, maxLevel, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        boolean toolTypeResult;
        boolean bl = toolTypeResult = ItemStackUtils.isEmpty(stack) == false && stack.field_77994_a >= 1 && this.getToolClasses(stack).stream().filter(s -> this.getToolClass().getName().equalsIgnoreCase((String)s)).map(ToolType::getToolType).filter(t -> t != ToolType.NONE).anyMatch(t -> ItemStackUtils.hasToolLevel(stack, t, this.getMinLevel(), this.getMaxLevel()));
        if (!toolTypeResult) {
            return stack.func_77973_b() instanceof ItemHoe && this.toolClass.equals(ToolType.HOE);
        }
        return toolTypeResult;
    }

    private Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return set;
        }
        set.addAll(stack.func_77973_b().getToolClasses(stack));
        if (stack.func_77973_b() instanceof ItemBow) {
            set.add("bow");
        } else if (stack.func_77973_b() instanceof ItemSword || Compatibility.isTinkersWeapon(stack)) {
            set.add("weapon");
        } else if (stack.func_77973_b() instanceof ItemHoe) {
            set.add("hoe");
        } else if (stack.func_77973_b() instanceof ItemFishingRod) {
            set.add("rod");
        } else if (stack.func_77973_b() instanceof ItemShears) {
            set.add("shears");
        }
        return set;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }
}

