/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class Stack
implements IDeliverable {
    private static final String NBT_STACK = "Stack";
    private static final String NBT_MATCHMETA = "MatchMeta";
    private static final String NBT_MATCHNBT = "MatchNBT";
    private static final String NBT_MATCHOREDIC = "MatchOreDic";
    private static final String NBT_RESULT = "Result";
    @NotNull
    private final ItemStack stack;
    @NotNull
    private boolean matchMeta = false;
    @NotNull
    private boolean matchNBT = false;
    @NotNull
    private boolean matchOreDic = false;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Stack(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            throw new IllegalArgumentException("Cannot deliver Empty Stack.");
        }
        this.setMatchMeta(true).setMatchNBT(true);
        this.stack = stack.func_77946_l();
        this.stack.field_77994_a = Math.min(this.stack.field_77994_a, this.stack.func_77976_d());
    }

    public Stack setMatchNBT(boolean match) {
        this.matchNBT = match;
        return this;
    }

    public Stack setMatchMeta(boolean match) {
        this.matchMeta = match;
        return this;
    }

    public Stack(@NotNull ItemStack stack, @NotNull boolean matchMeta, @NotNull boolean matchNBT, @NotNull boolean matchOreDic, ItemStack result) {
        this.stack = stack;
        this.matchMeta = matchMeta;
        this.matchNBT = matchNBT;
        this.matchOreDic = matchOreDic;
        this.result = result;
    }

    public static NBTTagCompound serialize(IFactoryController controller, Stack input) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(NBT_STACK, (NBTBase)input.stack.serializeNBT());
        compound.func_74757_a(NBT_MATCHMETA, input.matchMeta);
        compound.func_74757_a(NBT_MATCHNBT, input.matchNBT);
        compound.func_74757_a(NBT_MATCHOREDIC, input.matchOreDic);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            compound.func_74782_a(NBT_RESULT, (NBTBase)input.result.serializeNBT());
        }
        return compound;
    }

    public static Stack deserialize(IFactoryController controller, NBTTagCompound compound) {
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_STACK));
        boolean matchMeta = compound.func_74767_n(NBT_MATCHMETA);
        boolean matchNBT = compound.func_74767_n(NBT_MATCHNBT);
        boolean matchOreDic = compound.func_74767_n(NBT_MATCHOREDIC);
        ItemStack result = compound.func_74764_b(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        return new Stack(stack, matchMeta, matchNBT, matchOreDic, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        if (this.matchOreDic) {
            return OreDictionary.itemMatches((ItemStack)this.getStack(), (ItemStack)stack, (boolean)this.matchMeta) && this.getCount() <= stack.field_77994_a;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getStack(), stack, this.matchMeta, this.matchNBT);
    }

    @Override
    public int getCount() {
        return this.stack.field_77994_a;
    }

    @NotNull
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    public Stack setMatchOreDic(boolean match) {
        this.matchOreDic = match;
        return this;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }
}

