/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Burnable
implements IDeliverable {
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private final int count;
    private ItemStack result;

    public Burnable(int count) {
        this.count = count;
    }

    public Burnable(int count, ItemStack result) {
        this.count = count;
        this.result = result;
    }

    public static NBTTagCompound serialize(IFactoryController controller, Burnable food) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(NBT_COUNT, food.count);
        if (!ItemStackUtils.isEmpty(food.result).booleanValue()) {
            compound.func_74782_a(NBT_RESULT, (NBTBase)food.result.serializeNBT());
        }
        return compound;
    }

    public static Burnable deserialize(IFactoryController controller, NBTTagCompound compound) {
        int count = compound.func_74762_e(NBT_COUNT);
        ItemStack result = compound.func_74764_b(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        return new Burnable(count, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return TileEntityFurnace.func_145954_b((ItemStack)stack) && stack.field_77994_a >= this.getCount();
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    @Nullable
    public ItemStack getResult() {
        return this.result;
    }
}

