/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.proxies.LibCommonProxy;
import com.teamacronymcoders.base.util.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;

public class ClassLoading {
    private ClassLoading() {
    }

    public static LibCommonProxy createProxy(String clientString, String serverString) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        String proxyString = side == Side.CLIENT ? clientString : serverString;
        Object proxyObject = ClassLoading.createObjectInstance(proxyString);
        if (proxyObject instanceof LibCommonProxy) {
            return (LibCommonProxy)proxyObject;
        }
        return null;
    }

    public static <T> T createInstanceOf(Class<T> tClass, String path) {
        Object object = ClassLoading.createObjectInstance(path);
        if (object != null) {
            return tClass.cast(object);
        }
        return null;
    }

    public static Object createObjectInstance(String path) {
        try {
            Class<?> classToGrab = Class.forName(path);
            return ClassLoading.createObjectInstance(classToGrab);
        }
        catch (ClassNotFoundException exception) {
            Platform.attemptLogExceptionToCurrentMod(exception);
            Platform.attemptLogErrorToCurrentMod(path + " did not initialize. Something's gonna break.");
            return null;
        }
    }

    public static <T> T createObjectInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException exception) {
            Platform.attemptLogExceptionToCurrentMod(exception);
            Platform.attemptLogErrorToCurrentMod(clazz.getName() + " did not initialize. Something's gonna break.");
            return null;
        }
    }

    public static <T> List<T> getInstances(@Nonnull ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        return ClassLoading.getInstances(asmDataTable, annotationClass, instanceClass, aClass -> true);
    }

    public static <T> List<T> getInstances(@Nonnull ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass, Function<Class<? extends T>, Boolean> createInstance) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDataSet = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDataSet) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                if (!createInstance.apply(asmInstanceClass).booleanValue()) continue;
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (IllegalAccessException | InstantiationException exception) {
                Platform.attemptLogErrorToCurrentMod("Failed to load: " + asmData.getClassName());
                Platform.attemptLogExceptionToCurrentMod(exception);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return instances;
    }
}

