/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.modules.materials.blocks;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.api.materials.MaterialType;
import com.teamacronymcoders.base.blocks.BlockBase;
import com.teamacronymcoders.base.blocks.IHasBlockColor;
import com.teamacronymcoders.base.blocks.IHasBlockStateMapper;
import com.teamacronymcoders.base.modules.materials.blocks.BlockProperties;
import com.teamacronymcoders.base.modules.materials.items.ItemBlockMaterial;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockMaterial
extends BlockBase
implements IHasBlockColor,
IHasBlockStateMapper {
    private MaterialType materialType;
    private MaterialType.EnumPartType partType;

    public BlockMaterial(MaterialType materialType, MaterialType.EnumPartType partType, BlockProperties blockProperties) {
        super(Material.field_151573_f);
        this.setMaterialType(materialType);
        this.setPartType(partType);
        this.func_149663_c(materialType.getName().toLowerCase() + "." + partType.getLowerCaseName());
        blockProperties.setPropertiesToBlock(this);
        this.setItemBlock(new ItemBlockMaterial(this));
    }

    @Nonnull
    public String func_149732_F() {
        if (this.getMaterialType() != null) {
            return String.format("%s %s", this.getMaterialType().getLocalizedName(), Base.languageHelper.none("base.part." + this.getPartType().getName().toLowerCase()));
        }
        return ChatFormatting.RED + Base.languageHelper.error("null_part");
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149730_j(@Nonnull IBlockState state) {
        return false;
    }

    public boolean isSideSolid(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return true;
    }

    @Override
    public List<String> getModelNames(List<String> names) {
        names.add(this.getPartType().getName().toLowerCase());
        return names;
    }

    @Override
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        return this.getMaterialType().getColour().getRGB();
    }

    @Override
    public ResourceLocation getResourceLocation(IBlockState blockState) {
        return new ResourceLocation("base", this.getPartType().getLowerCaseName());
    }

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public void setMaterialType(MaterialType materialType) {
        this.materialType = materialType;
    }

    public MaterialType.EnumPartType getPartType() {
        return this.partType;
    }

    public void setPartType(MaterialType.EnumPartType partType) {
        this.partType = partType;
    }
}

