/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.modules.debug.items;

import com.teamacronymcoders.base.api.IDebuggable;
import com.teamacronymcoders.base.items.ItemBase;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemDebuggerStick
extends ItemBase {
    public ItemDebuggerStick() {
        super("debugger_stick");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand) {
        RayTraceResult result = ProjectileHelper.func_188802_a((Entity)entityPlayer, (boolean)true, (boolean)true, (Entity)entityPlayer);
        EnumActionResult actionResult = EnumActionResult.SUCCESS;
        switch (result.field_72313_a) {
            case BLOCK: {
                TileEntity tileEntity = world.func_175625_s(result.func_178782_a());
                Block block = world.func_180495_p(result.func_178782_a()).func_177230_c();
                if (tileEntity instanceof IDebuggable) {
                    this.writeDebug((IDebuggable)tileEntity);
                    break;
                }
                if (block instanceof IDebuggable) {
                    this.writeDebug((IDebuggable)block);
                    break;
                }
                this.getMod().getLogger().info(block.getRegistryName().toString());
                break;
            }
            case ENTITY: {
                Entity entity = result.field_72308_g;
                if (entity instanceof IDebuggable) {
                    this.writeDebug((IDebuggable)entity);
                    break;
                }
                if (entity == null) break;
                this.getMod().getLogger().info(entity.func_70005_c_() + ":" + entity.func_110124_au());
                break;
            }
            case MISS: {
                actionResult = EnumActionResult.PASS;
            }
        }
        return ActionResult.newResult((EnumActionResult)actionResult, (Object)itemStack);
    }

    public void writeDebug(IDebuggable debuggable) {
        LinkedHashMap<String, String> debugStrings = new LinkedHashMap<String, String>();
        if (!(debugStrings = debuggable.getDebugStrings(debugStrings)).isEmpty()) {
            for (String debugString : debugStrings.values()) {
                this.getMod().getLogger().info(debugString);
            }
        }
    }

    @Override
    public List<String> getModelNames(List<String> modelNames) {
        modelNames.add("debugger_stick");
        return modelNames;
    }
}

