/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.wrapped;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.teamacronymcoders.base.client.models.EmptyModelState;
import com.teamacronymcoders.base.client.models.wrapped.WrappedBakedModel;
import com.teamacronymcoders.base.client.models.wrapped.WrappedBlockEntry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WrappedModel
implements IModel {
    private WrappedBlockEntry blockEntry;

    public WrappedModel(WrappedBlockEntry blockEntry) {
        this.blockEntry = blockEntry;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList textures = Lists.newArrayList();
        textures.add(this.blockEntry.getBaseResource());
        textures.addAll(this.blockEntry.getLayers().keySet());
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new WrappedBakedModel(this.blockEntry);
    }

    public IModelState getDefaultState() {
        return new EmptyModelState();
    }
}

