/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.client.models.generator;

import com.teamacronymcoders.base.IBaseMod;
import com.teamacronymcoders.base.client.models.generator.IHasGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.util.Platform;
import com.teamacronymcoders.base.util.files.BaseFileUtils;
import java.io.File;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelGenerator {
    private static File blockStatesFolder;
    private static File blockModelsFolder;
    private static File itemModelsFolder;
    private static boolean isSetup;
    private static boolean okayToRun;

    public static void generate(IHasGeneratedModel model) {
        if (!isSetup) {
            ModelGenerator.setupFolders();
        }
        if (okayToRun) {
            List<IGeneratedModel> generatedModels = model.getGeneratedModels();
            generatedModels.forEach(resource -> {
                File file = null;
                switch (resource.getModelType()) {
                    case BLOCKSTATE: {
                        file = new File(blockStatesFolder, resource.getName() + ".json");
                        break;
                    }
                    case BLOCK_MODEL: {
                        file = new File(blockModelsFolder, resource.getName() + ".json");
                        break;
                    }
                    case ITEM_MODEL: {
                        file = new File(itemModelsFolder, resource.getName() + ".json");
                    }
                }
                if (!file.exists()) {
                    BaseFileUtils.writeStringToFile(resource.getJson(), file);
                }
            });
        }
    }

    private static void setupFolders() {
        IBaseMod mod = Platform.getCurrentMod();
        if (mod != null && mod.getResourceFolder() != null) {
            blockStatesFolder = new File(mod.getResourceFolder(), "blockstates");
            BaseFileUtils.createFolder(blockStatesFolder);
            blockModelsFolder = new File(mod.getResourceFolder(), "models/block");
            BaseFileUtils.createFolder(blockModelsFolder);
            itemModelsFolder = new File(mod.getResourceFolder(), "models/item");
            BaseFileUtils.createFolder(itemModelsFolder);
            okayToRun = true;
        }
        isSetup = true;
    }

    static {
        isSetup = false;
        okayToRun = false;
    }
}

