/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.config.IConfigContainer;
import com.feed_the_beast.ftbl.api.events.ConfigLoadedEvent;
import com.feed_the_beast.ftbl.lib.net.MessageToServer;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.NetUtils;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageEditConfigResponse
extends MessageToServer<MessageEditConfigResponse> {
    private JsonObject groupData;
    private NBTTagCompound extraNBT;

    public MessageEditConfigResponse() {
    }

    public MessageEditConfigResponse(@Nullable NBTTagCompound nbt, JsonObject json) {
        this.groupData = json;
        this.extraNBT = nbt;
        if (LMUtils.DEV_ENV) {
            LMUtils.DEV_LOGGER.info("TX Response: " + this.groupData);
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        this.groupData = NetUtils.readJsonElement(io).getAsJsonObject();
        this.extraNBT = ByteBufUtils.readTag((ByteBuf)io);
    }

    public void toBytes(ByteBuf io) {
        NetUtils.writeJsonElement(io, (JsonElement)this.groupData);
        ByteBufUtils.writeTag((ByteBuf)io, (NBTTagCompound)this.extraNBT);
    }

    @Override
    public void onMessage(MessageEditConfigResponse m, EntityPlayer player) {
        IConfigContainer cc = FTBLibModCommon.TEMP_SERVER_CONFIG.get(player.func_146103_bH().getId());
        if (cc != null) {
            if (LMUtils.DEV_ENV) {
                LMUtils.DEV_LOGGER.info("RX Response: " + m.groupData);
            }
            cc.saveConfig((ICommandSender)player, m.extraNBT, m.groupData);
            MinecraftForge.EVENT_BUS.post((Event)new ConfigLoadedEvent(LoaderState.ModState.AVAILABLE));
            FTBLibModCommon.TEMP_SERVER_CONFIG.remove(player.func_146103_bH().getId());
        }
    }
}

