/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.guide.GuideFormat;
import com.feed_the_beast.ftbl.api.guide.GuideType;
import com.feed_the_beast.ftbl.api.guide.SpecialGuideButton;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.ModContainer;

public class GuideTitlePage
extends GuidePage {
    private final GuideType type;
    private final GuideFormat format;
    private final List<String> authors;
    private final List<String> guideAuthors;

    public GuideTitlePage(String id, GuideType t, Collection<String> _authors, Collection<String> _guideAuthors) {
        super(id);
        this.type = t;
        this.format = GuideFormat.JSON;
        this.authors = _authors.isEmpty() ? Collections.emptyList() : new ArrayList<String>(_authors);
        this.guideAuthors = _guideAuthors.isEmpty() ? Collections.emptyList() : new ArrayList<String>(_guideAuthors);
    }

    public GuideTitlePage(ModContainer mod) {
        this(mod.getModId(), GuideType.MOD, mod.getMetadata().authorList, Collections.singleton("Autogenerated"));
        if (!mod.getMetadata().description.isEmpty()) {
            for (String s : mod.getMetadata().description.split("\n")) {
                this.println(s);
            }
        }
        this.setTitle((ITextComponent)new TextComponentString(mod.getName()));
    }

    public GuideTitlePage(String id, JsonObject o) {
        super(id);
        this.setTitle((ITextComponent)new TextComponentTranslation(id + ".guide", new Object[0]));
        if (o.has("icon")) {
            this.setIcon(ImageProvider.get(o.get("icon")));
        } else {
            this.setIcon(new ImageProvider(new ResourceLocation(id, "textures/icon.png")));
        }
        if (o.has("button")) {
            this.addSpecialButton(new SpecialGuideButton(o.get("button").getAsJsonObject()));
        }
        this.type = o.has("type") ? GuideType.getFromString(o.get("type").getAsString()) : GuideType.OTHER;
        this.format = o.has("format") ? GuideFormat.getFromString(o.get("format").getAsString()) : GuideFormat.JSON;
        ArrayList<String> l = new ArrayList<String>();
        for (JsonElement e : o.get("authors").getAsJsonArray()) {
            l.add(e.getAsString());
        }
        this.authors = Collections.unmodifiableList(l);
        l = new ArrayList();
        if (o.has("guide_authors")) {
            for (JsonElement e : o.get("guide_authors").getAsJsonArray()) {
                l.add(e.getAsString());
            }
        }
        this.guideAuthors = Collections.unmodifiableList(l);
    }

    public GuideType getType() {
        return this.type;
    }

    public GuideFormat getFormat() {
        return this.format;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public List<String> getGuideAuthors() {
        return this.guideAuthors;
    }
}

