/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.guide;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbl.api.guide.IGuideTextLineProvider;
import com.feed_the_beast.ftbl.api.guide.SpecialGuideButton;
import com.feed_the_beast.ftbl.lib.FinalIDObject;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiGuide;
import com.feed_the_beast.ftbl.lib.guide.ButtonGuidePage;
import com.feed_the_beast.ftbl.lib.guide.GuideExtendedTextLine;
import com.feed_the_beast.ftbl.lib.guide.GuideTextLineString;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.MapUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;

public class GuidePage
extends FinalIDObject {
    private static final Comparator<Map.Entry<String, GuidePage>> COMPARATOR = (o1, o2) -> ((GuidePage)o1.getValue()).getDisplayName().func_150260_c().compareToIgnoreCase(((GuidePage)o2.getValue()).getDisplayName().func_150260_c());
    public static final Map<String, IGuideTextLineProvider> LINE_PROVIDERS = new HashMap<String, IGuideTextLineProvider>();
    public final List<IGuideTextLine> text = new ArrayList<IGuideTextLine>();
    public final LinkedHashMap<String, GuidePage> childPages = new LinkedHashMap(0);
    public GuidePage parent;
    private ITextComponent title;
    private IDrawableObject pageIcon = ImageProvider.NULL;
    public final List<SpecialGuideButton> specialButtons = new ArrayList<SpecialGuideButton>();

    public GuidePage(String id) {
        super(id);
    }

    public GuidePage(String id, @Nullable GuidePage p, JsonElement json) {
        this(id);
        this.parent = p;
        if (!json.isJsonObject()) {
            return;
        }
        JsonObject o = json.getAsJsonObject();
        if (o.has("title")) {
            this.setTitle(JsonUtils.deserializeTextComponent(o.get("title")));
        }
        if (o.has("text")) {
            JsonArray a = o.get("text").getAsJsonArray();
            for (int i = 0; i < a.size(); ++i) {
                this.text.add(this.createLine(a.get(i)));
            }
        }
        if (o.has("pages")) {
            JsonObject o1 = o.get("pages").getAsJsonObject();
            for (Map.Entry entry : o1.entrySet()) {
                this.childPages.put((String)entry.getKey(), new GuidePage((String)entry.getKey(), this, (JsonElement)entry.getValue()));
            }
        }
        if (o.has("icon")) {
            this.pageIcon = ImageProvider.get(o.get("icon"));
        }
        if (o.has("buttons")) {
            for (JsonElement e : o.get("buttons").getAsJsonArray()) {
                this.specialButtons.add(new SpecialGuideButton(e.getAsJsonObject()));
            }
        }
    }

    public String getFullID() {
        return this.parent == null ? this.func_176610_l() : this.parent.getFullID() + '.' + this.func_176610_l();
    }

    public ITextComponent getDisplayName() {
        return this.title == null ? new TextComponentString(this.func_176610_l()) : this.title;
    }

    public void println(@Nullable Object o) {
        if (o == null) {
            this.text.add(null);
        } else if (o instanceof IGuideTextLine) {
            if (o instanceof GuideTextLineString) {
                String text = ((GuideTextLineString)o).getUnformattedText();
                if (text.isEmpty()) {
                    this.println(null);
                    return;
                }
                if (text.startsWith("# ")) {
                    TextComponentString component = new TextComponentString(text.substring(2));
                    component.func_150256_b().func_150227_a(Boolean.valueOf(true));
                    component.func_150256_b().func_150228_d(Boolean.valueOf(true));
                    this.println(component);
                    return;
                }
                if (text.startsWith("## ")) {
                    TextComponentString component = new TextComponentString(text.substring(3));
                    component.func_150256_b().func_150227_a(Boolean.valueOf(true));
                    this.println(component);
                    return;
                }
            }
            this.text.add((IGuideTextLine)o);
        } else if (o instanceof ITextComponent) {
            ITextComponent c = (ITextComponent)o;
            if (c instanceof TextComponentString && c.func_150256_b().func_150229_g() && c.func_150253_a().isEmpty()) {
                this.text.add(new GuideTextLineString(((TextComponentString)c).func_150265_g()));
            } else {
                this.text.add(new GuideExtendedTextLine(c));
            }
        } else if (o instanceof GuidePage) {
            this.copyFrom((GuidePage)o);
        } else {
            this.text.add(new GuideTextLineString(String.valueOf(o)));
        }
    }

    public GuidePage addSub(GuidePage c) {
        c.parent = this;
        this.childPages.put(c.func_176610_l(), c);
        return c;
    }

    public GuidePage getSub(String id) {
        GuidePage p = this.childPages.get(id);
        if (p == null) {
            p = this.addSub(new GuidePage(id));
        }
        return p;
    }

    @Nullable
    public GuidePage getSubRaw(String id) {
        int i = id.indexOf(46);
        if (i >= 0) {
            GuidePage page = this.childPages.get(id.substring(0, i));
            return page == null ? null : page.getSubRaw(id.substring(i + 1));
        }
        return this.childPages.get(id);
    }

    public void clear() {
        this.text.clear();
        this.childPages.clear();
    }

    public void cleanup() {
        this.childPages.values().forEach(GuidePage::cleanup);
        this.childPages.values().removeIf(GuidePage::isEmpty);
    }

    public boolean isEmpty() {
        if (!this.childPages.isEmpty()) {
            return false;
        }
        for (IGuideTextLine line : this.text) {
            if (line == null || line.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void sort(boolean tree) {
        MapUtils.sortMap(this.childPages, COMPARATOR);
        if (tree) {
            this.childPages.values().forEach(page -> page.sort(true));
        }
    }

    public void copyFrom(GuidePage c) {
        for (IGuideTextLine l : c.text) {
            this.text.add(l == null ? null : l.copy(this));
        }
        c.childPages.forEach((key, value) -> this.getSub((String)key).copyFrom((GuidePage)value));
    }

    public JsonElement toJson() {
        JsonArray a;
        JsonObject o = new JsonObject();
        if (this.title != null) {
            o.add("title", JsonUtils.serializeTextComponent(this.title));
        }
        if (!this.text.isEmpty()) {
            a = new JsonArray();
            for (IGuideTextLine c : this.text) {
                a.add((JsonElement)(c == null ? JsonNull.INSTANCE : c.getJson()));
            }
            o.add("text", (JsonElement)a);
        }
        if (!this.childPages.isEmpty()) {
            JsonObject o1 = new JsonObject();
            this.childPages.forEach((key, value) -> o1.add(key, value.toJson()));
            o.add("pages", (JsonElement)o1);
        }
        if (this.pageIcon != ImageProvider.NULL) {
            o.add("icon", this.pageIcon.getJson());
        }
        if (!this.specialButtons.isEmpty()) {
            a = new JsonArray();
            for (SpecialGuideButton button : this.specialButtons) {
                a.add((JsonElement)button.serialize());
            }
            o.add("buttons", (JsonElement)a);
        }
        return o;
    }

    @Nullable
    public final ITextComponent getTitle() {
        return this.title;
    }

    public GuidePage setTitle(@Nullable ITextComponent t) {
        this.title = t;
        return this;
    }

    public void refreshGui(GuiBase gui) {
    }

    public final GuidePage addSpecialButton(SpecialGuideButton button) {
        this.specialButtons.add(button);
        return this;
    }

    public GuidePage setIcon(IDrawableObject icon) {
        this.pageIcon = icon;
        return this;
    }

    public IDrawableObject getIcon() {
        return this.pageIcon;
    }

    public Widget createWidget(GuiBase gui) {
        return new ButtonGuidePage((GuiGuide)gui, this, false);
    }

    public Side getSide() {
        return this.parent == null ? Side.CLIENT : this.parent.getSide();
    }

    @Nullable
    public IGuideTextLine createLine(@Nullable JsonElement json) {
        String id;
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            String s = json.getAsString();
            return s.trim().isEmpty() ? null : new GuideTextLineString(s);
        }
        if (json.isJsonArray()) {
            return new GuideExtendedTextLine(json);
        }
        JsonObject o = json.getAsJsonObject();
        IGuideTextLineProvider provider = null;
        if (o.has("id") && (provider = LINE_PROVIDERS.get(id = o.get("id").getAsString())) == null) {
            TextComponentString component = new TextComponentString("Unknown ID: " + id);
            component.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
            component.func_150256_b().func_150227_a(Boolean.valueOf(true));
            return new GuideExtendedTextLine((ITextComponent)component);
        }
        IGuideTextLine line = provider != null ? provider.create(this, json) : new GuideExtendedTextLine(json);
        return line;
    }
}

