/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.lib.client.PixelBuffer;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiConfigs;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

public class ThreadReloadChunkSelector
extends Thread {
    private static ByteBuffer pixelBuffer = null;
    private static final PixelBuffer PIXELS = new PixelBuffer(256, 256);
    private static final Map<IBlockState, Integer> COLOR_CACHE = new HashMap<IBlockState, Integer>();
    private static final BlockPos.MutableBlockPos CURRENT_BLOCK_POS = new BlockPos.MutableBlockPos(0, 0, 0);
    private static final Function<IBlockState, Integer> COLOR_GETTER = state -> 0xFF000000 | ThreadReloadChunkSelector.getBlockColor0(state);
    public final World worldObj;
    private final int startX;
    private final int startZ;
    private boolean cancelled = false;
    private static ThreadReloadChunkSelector instance;
    private static int textureID;

    public static int getTextureID() {
        if (textureID == -1) {
            textureID = TextureUtil.func_110996_a();
        }
        return textureID;
    }

    public static void updateTexture() {
        if (pixelBuffer != null) {
            GlStateManager.func_179144_i((int)ThreadReloadChunkSelector.getTextureID());
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)256, (int)256, (int)0, (int)6408, (int)5121, (ByteBuffer)pixelBuffer);
            pixelBuffer = null;
        }
    }

    public static void reloadArea(World w, int sx, int sz) {
        if (instance != null) {
            ThreadReloadChunkSelector.instance.cancelled = true;
            instance = null;
        }
        instance = new ThreadReloadChunkSelector(w, sx, sz);
        ThreadReloadChunkSelector.instance.cancelled = false;
        instance.start();
    }

    public static boolean isReloading() {
        return instance != null && !ThreadReloadChunkSelector.instance.cancelled;
    }

    private ThreadReloadChunkSelector(World w, int sx, int sz) {
        super("ChunkSelectorAreaReloader");
        this.setDaemon(true);
        this.worldObj = w;
        this.startX = sx;
        this.startZ = sz;
    }

    private static int getBlockColor0(IBlockState state) {
        Block b = state.func_177230_c();
        if (b == Blocks.field_150322_A) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150480_ab) {
            return MapColor.field_151645_D.field_76291_p;
        }
        if (b == Blocks.field_150327_N) {
            return MapColor.field_151673_t.field_76291_p;
        }
        if (b == Blocks.field_150353_l) {
            return MapColor.field_151676_q.field_76291_p;
        }
        if (b == Blocks.field_150377_bs) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150343_Z) {
            return 1376327;
        }
        if (b == Blocks.field_150351_n) {
            return 9279387;
        }
        if (b == Blocks.field_150349_c) {
            return 7650428;
        }
        if (b == Blocks.field_150478_aa) {
            return 16753968;
        }
        if (b == Blocks.field_150328_O) {
            switch ((BlockFlower.EnumFlowerType)state.func_177229_b(Blocks.field_150328_O.func_176494_l())) {
                case DANDELION: {
                    return MapColor.field_151673_t.field_76291_p;
                }
                case POPPY: {
                    return MapColor.field_151645_D.field_76291_p;
                }
                case BLUE_ORCHID: {
                    return MapColor.field_151674_s.field_76291_p;
                }
                case ALLIUM: {
                    return MapColor.field_151675_r.field_76291_p;
                }
                case HOUSTONIA: {
                    return MapColor.field_151680_x.field_76291_p;
                }
                case RED_TULIP: {
                    return MapColor.field_151645_D.field_76291_p;
                }
                case ORANGE_TULIP: {
                    return MapColor.field_151676_q.field_76291_p;
                }
                case WHITE_TULIP: {
                    return MapColor.field_151666_j.field_76291_p;
                }
                case PINK_TULIP: {
                    return MapColor.field_151671_v.field_76291_p;
                }
                case OXEYE_DAISY: {
                    return MapColor.field_151680_x.field_76291_p;
                }
            }
        } else if (b == Blocks.field_150344_f) {
            switch ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a)) {
                case OAK: {
                    return 13015113;
                }
                case SPRUCE: {
                    return 8150574;
                }
                case BIRCH: {
                    return 15917203;
                }
                case JUNGLE: {
                    return 13006419;
                }
                case ACACIA: {
                    return 14712638;
                }
                case DARK_OAK: {
                    return 5319956;
                }
            }
        }
        return state.func_185909_g().field_76291_p;
    }

    @Override
    public void run() {
        Arrays.fill(PIXELS.getPixels(), 0);
        pixelBuffer = ColorUtils.toByteBuffer(PIXELS.getPixels(), false);
        boolean depth = GuiConfigs.ENABLE_CHUNK_SELECTOR_DEPTH.getBoolean();
        int startY = Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o();
        try {
            for (int cz = 0; cz < 15; ++cz) {
                for (int cx = 0; cx < 15; ++cx) {
                    Chunk chunk = this.worldObj.func_72863_F().func_186026_b(this.startX + cx, this.startZ + cz);
                    if (chunk != null) {
                        int x = MathUtils.unchunk(this.startX + cx);
                        int z = MathUtils.unchunk(this.startZ + cz);
                        int topY = Math.max(255, chunk.func_76625_h() + 15);
                        for (int wz = 0; wz < 16; ++wz) {
                            block5: for (int wx = 0; wx < 16; ++wx) {
                                for (int by = topY; by > 0; --by) {
                                    if (this.cancelled) {
                                        return;
                                    }
                                    IBlockState state = chunk.func_186032_a(wx, by, wz);
                                    CURRENT_BLOCK_POS.func_181079_c(x + wx, by, z + wz);
                                    if (state.func_177230_c() == Blocks.field_150329_H || this.worldObj.func_175623_d((BlockPos)CURRENT_BLOCK_POS)) continue;
                                    int color = COLOR_CACHE.computeIfAbsent(state, COLOR_GETTER);
                                    if (depth) {
                                        color = ColorUtils.addBrightness(color, MathHelper.func_76125_a((int)(by - startY), (int)-30, (int)30) * 5);
                                    }
                                    PIXELS.setRGB(cx * 16 + wx, cz * 16 + wz, color);
                                    continue block5;
                                }
                            }
                        }
                    }
                    pixelBuffer = ColorUtils.toByteBuffer(PIXELS.getPixels(), false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pixelBuffer = ColorUtils.toByteBuffer(PIXELS.getPixels(), false);
        instance = null;
    }

    static {
        textureID = -1;
    }
}

