/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.api.config.IConfigContainer;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.config.IGuiEditConfig;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiEditConfig
extends GuiBase
implements IGuiEditConfig {
    public static final Comparator<Map.Entry<IConfigKey, IConfigValue>> COMPARATOR = (o1, o2) -> {
        int i = ((IConfigKey)o1.getKey()).getGroup().compareToIgnoreCase(((IConfigKey)o2.getKey()).getGroup());
        return i == 0 ? ((IConfigKey)o1.getKey()).getDisplayName().compareToIgnoreCase(((IConfigKey)o2.getKey()).getDisplayName()) : i;
    };
    public static final Color4I COLOR_BACKGROUND = new Color4I(false, -1724697805);
    private final IConfigContainer configContainer;
    private final NBTTagCompound extraNBT;
    private final JsonObject modifiedConfig;
    private final String title;
    private final List<Widget> configEntryButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private final PanelScrollBar scroll;
    private int shouldClose = 0;

    public GuiEditConfig(@Nullable NBTTagCompound nbt, IConfigContainer cc) {
        super(0, 0);
        this.configContainer = cc;
        ITextComponent title0 = this.configContainer.getTitle().func_150259_f();
        title0.func_150256_b().func_150227_a(Boolean.valueOf(true));
        this.title = title0.func_150254_d();
        this.extraNBT = nbt;
        this.modifiedConfig = new JsonObject();
        this.configEntryButtons = new ArrayList<Widget>();
        ArrayList<Map.Entry<IConfigKey, IConfigValue>> list = new ArrayList<Map.Entry<IConfigKey, IConfigValue>>();
        list.addAll(this.configContainer.getConfigTree().getTree().entrySet());
        if (!list.isEmpty()) {
            list.sort(COMPARATOR);
            ButtonConfigGroup group = null;
            for (Map.Entry entry : list) {
                if (((IConfigKey)entry.getKey()).getFlag(2)) continue;
                if (group == null || !group.groupId.equalsIgnoreCase(((IConfigKey)entry.getKey()).getGroup())) {
                    group = new ButtonConfigGroup(((IConfigKey)entry.getKey()).getGroup());
                    this.configEntryButtons.add(group);
                }
                this.configEntryButtons.add(new ButtonConfigEntry(group, (IConfigKey)entry.getKey(), ((IConfigValue)entry.getValue()).copy()));
            }
        }
        this.configPanel = new Panel(0, 20, 0, 20){

            @Override
            public void addWidgets() {
                for (Widget w : GuiEditConfig.this.configEntryButtons) {
                    if (w instanceof ButtonConfigEntry && ((ButtonConfigEntry)w).group.collapsed) continue;
                    this.add(w);
                }
            }

            @Override
            public void updateWidgetPositions() {
                GuiEditConfig.this.scroll.setElementSize(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.configPanel.addFlags(3);
        this.buttonAccept = new Button(0, 2, 16, 16, GuiLang.BUTTON_ACCEPT.translate()){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiEditConfig.this.shouldClose = 1;
                gui.closeGui();
            }
        };
        this.buttonAccept.setIcon(GuiIcons.ACCEPT);
        this.buttonCancel = new Button(0, 2, 16, 16, GuiLang.BUTTON_CANCEL.translate()){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiEditConfig.this.shouldClose = 2;
                gui.closeGui();
            }
        };
        this.buttonCancel.setIcon(GuiIcons.CANCEL);
        this.buttonCollapseAll = new Button(0, 2, 16, 16, "Collapse All"){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                for (Widget w : GuiEditConfig.this.configEntryButtons) {
                    if (!(w instanceof ButtonConfigGroup)) continue;
                    ((ButtonConfigGroup)w).setCollapsed(true);
                }
                GuiEditConfig.this.scroll.setValue(gui, 0.0);
                gui.refreshWidgets();
            }
        };
        this.buttonCollapseAll.setIcon(GuiIcons.REMOVE);
        this.buttonExpandAll = new Button(0, 2, 16, 16, "Expand All"){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                for (Widget w : GuiEditConfig.this.configEntryButtons) {
                    if (!(w instanceof ButtonConfigGroup)) continue;
                    ((ButtonConfigGroup)w).setCollapsed(false);
                }
                GuiEditConfig.this.scroll.setValue(gui, 0.0);
                gui.refreshWidgets();
            }
        };
        this.buttonExpandAll.setIcon(GuiIcons.ADD);
        this.scroll = new PanelScrollBar(-16, 20, 16, 0, 10, this.configPanel){

            @Override
            public boolean shouldRender(GuiBase gui) {
                return true;
            }
        };
    }

    @Override
    public boolean isFullscreen() {
        return true;
    }

    @Override
    public void updateWidgetPositions() {
        this.buttonAccept.posX = this.width - 18;
        this.buttonCancel.posX = this.width - 38;
        this.buttonExpandAll.posX = this.width - 58;
        this.buttonCollapseAll.posX = this.width - 78;
        this.configPanel.setHeight(this.height - 20);
        this.configPanel.setWidth(this.width);
        this.scroll.posX = this.width - 16;
        this.scroll.setHeight(this.configPanel.height);
        for (Widget b : this.configEntryButtons) {
            b.setWidth(this.scroll.posX);
        }
    }

    @Override
    public void addWidgets() {
        this.add(this.scroll);
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.buttonCollapseAll);
        this.add(this.buttonExpandAll);
        this.add(this.configPanel);
    }

    @Override
    public void onClosed() {
        if (this.shouldClose == 1 && !this.modifiedConfig.entrySet().isEmpty()) {
            this.configContainer.saveConfig((ICommandSender)this.mc.field_71439_g, this.extraNBT, this.modifiedConfig);
        }
    }

    @Override
    public boolean onClosedByKey() {
        this.buttonCancel.onClicked(this, MouseButton.LEFT);
        return false;
    }

    @Override
    public void onChanged(IConfigKey key, JsonElement val) {
        this.modifiedConfig.add(key.func_176610_l(), val);
    }

    @Override
    public void drawBackground() {
        GuiHelper.drawBlankRect(0, 0, this.width, 20, COLOR_BACKGROUND);
        this.getFont().func_78276_b(this.getTitle(this), 6, 6, -1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public String getTitle(GuiBase gui) {
        return this.title;
    }

    @Override
    public void onClientDataChanged() {
        this.refreshWidgets();
    }

    public class ButtonConfigEntry
    extends Button {
        public final ButtonConfigGroup group;
        public final IConfigKey key;
        public final IConfigValue value;
        public String keyText;
        public List<String> info;

        public ButtonConfigEntry(ButtonConfigGroup g, IConfigKey id, IConfigValue e) {
            super(0, 0, 0, 16);
            this.group = g;
            this.key = id;
            this.value = e;
            this.keyText = id.getDisplayName();
            String infoText = id.getInfo();
            if (!infoText.isEmpty()) {
                this.info = new ArrayList<String>();
                for (String s : infoText.split("\\\\n")) {
                    this.info.addAll(GuiEditConfig.this.getFont().func_78271_c(s, 230));
                }
            }
            if (this.info == null || this.info.isEmpty()) {
                this.info = Collections.emptyList();
            }
        }

        @Override
        public void renderWidget(GuiBase gui) {
            boolean mouseOver = gui.getMouseY() >= 20 && gui.isMouseOver(this);
            int ax = this.getAX();
            int ay = this.getAY();
            if (mouseOver) {
                GuiHelper.drawBlankRect(ax, ay, this.width, this.height, Color4I.WHITE_A33);
            }
            gui.drawString(this.keyText, ax + 4, ay + 4, mouseOver ? Color4I.WHITE : Color4I.GRAY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String s = this.value.getString();
            int slen = gui.getFont().func_78256_a(s);
            if (slen > 150) {
                s = gui.getFont().func_78269_a(s, 150) + "...";
                slen = 152;
            }
            Color4I textCol = new Color4I(true, this.value.getColor(), 255);
            if (mouseOver) {
                textCol.addBrightness(60);
                if (gui.getMouseX() > ax + this.width - slen - 9) {
                    GuiHelper.drawBlankRect(ax + this.width - slen - 8, ay, slen + 8, this.height, Color4I.WHITE_A33);
                }
            }
            gui.drawString(s, gui.width - (slen + 20), ay + 4, textCol);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            if (gui.getMouseY() >= 20 && !this.key.getFlag(4)) {
                GuiHelper.playClickSound();
                this.value.onClicked(GuiEditConfig.this, this.key, button);
            }
        }

        @Override
        public void addMouseOverText(GuiBase gui, List<String> list) {
            if (gui.getMouseY() > 18) {
                if (!this.info.isEmpty() && gui.getMouseX() < this.getAX() + gui.getFont().func_78256_a(this.keyText) + 10) {
                    list.addAll(this.info);
                }
                if (gui.getMouseX() > gui.width - (Math.min(150, gui.getFont().func_78256_a(this.value.getString())) + 25)) {
                    this.value.addInfo(this.key, list);
                }
            }
        }
    }

    public class ButtonConfigGroup
    extends Button {
        public final String groupId;
        public String title;
        public String info;
        public boolean collapsed;

        public ButtonConfigGroup(String id) {
            super(0, 0, 0, 16);
            this.title = "-";
            this.info = "";
            this.collapsed = false;
            this.groupId = id;
            if (!this.groupId.isEmpty()) {
                StringBuilder current = new StringBuilder("config_group");
                StringBuilder text = new StringBuilder();
                String[] sa = this.groupId.split("\\.");
                for (int i = 0; i < sa.length; ++i) {
                    current.append(".");
                    current.append(sa[i]);
                    text.append(StringUtils.translate(current + ".name"));
                    if (i == sa.length - 1) continue;
                    text.append(" > ");
                }
                this.title = text.toString();
                text.setLength(0);
                text.append("config_group.");
                text.append(this.groupId);
                text.append(".info");
                String infoKey = text.toString();
                if (StringUtils.canTranslate(infoKey)) {
                    this.info = StringUtils.translate(infoKey);
                }
            }
            this.setCollapsed(this.collapsed);
        }

        public void setCollapsed(boolean v) {
            this.collapsed = v;
            this.setTitle((this.collapsed ? TextFormatting.RED + "[-] " : TextFormatting.GREEN + "[v] ") + TextFormatting.RESET + this.title);
        }

        @Override
        public void renderWidget(GuiBase gui) {
            int ax = this.getAX();
            int ay = this.getAY();
            GuiHelper.drawBlankRect(ax, ay, this.width, this.height, COLOR_BACKGROUND);
            gui.drawString(this.getTitle(gui), ax + 3, ay + 4, gui.getContentColor());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (gui.isMouseOver(this)) {
                DEFAULT_MOUSE_OVER.draw(ax, ay, this.width, this.height, Color4I.NONE);
            }
        }

        @Override
        public void addMouseOverText(GuiBase gui, List<String> list) {
            if (!this.info.isEmpty()) {
                list.add(this.info);
            }
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            this.setCollapsed(!this.collapsed);
            gui.refreshWidgets();
        }
    }
}

