/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelNull;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class Widget {
    public int posX;
    public int posY;
    public int width;
    public int height;
    private Panel parentPanel = PanelNull.INSTANCE;

    public Widget(int x, int y, int w, int h) {
        this.posX = x;
        this.posY = y;
        this.width = Math.max(w, 1);
        this.height = Math.max(h, 1);
    }

    public void setX(int v) {
        this.posX = v;
    }

    public void setY(int v) {
        this.posY = v;
    }

    public void setWidth(int v) {
        this.width = Math.max(v, 1);
    }

    public void setHeight(int v) {
        this.height = Math.max(v, 1);
    }

    public Panel getParentPanel() {
        return this.parentPanel;
    }

    public void setParentPanel(Panel p) {
        this.parentPanel = p;
    }

    public int getAX() {
        return this.getParentPanel().getAX() + this.posX;
    }

    public int getAY() {
        return this.getParentPanel().getAY() + this.posY;
    }

    public boolean collidesWith(int x, int y, int w, int h) {
        int ay = this.getAY();
        if (ay >= y + h || ay + this.width <= y) {
            return false;
        }
        int ax = this.getAX();
        return ax < x + w && ax + this.height > x;
    }

    public boolean isEnabled(GuiBase gui) {
        return true;
    }

    public boolean shouldRender(GuiBase gui) {
        return true;
    }

    public Color4I renderTitleInCenter(GuiBase gui) {
        return Color4I.NONE;
    }

    public String getTitle(GuiBase gui) {
        return "";
    }

    public IDrawableObject getIcon(GuiBase gui) {
        return ImageProvider.NULL;
    }

    public void addMouseOverText(GuiBase gui, List<String> list) {
        Color4I col = this.renderTitleInCenter(gui);
        if (col.hasColor()) {
            return;
        }
        String t = this.getTitle(gui);
        if (!t.isEmpty()) {
            list.add(t);
        }
    }

    public void renderWidget(GuiBase gui) {
        String t;
        this.getIcon(gui).draw(this, Color4I.NONE);
        Color4I col = this.renderTitleInCenter(gui);
        if (col.hasColor() && !(t = this.getTitle(gui)).isEmpty()) {
            gui.drawCenteredString(t, this.getAX() + this.width / 2, this.getAY() + this.height / 2, col);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean mousePressed(GuiBase gui, IMouseButton button) {
        return false;
    }

    public void mouseReleased(GuiBase gui) {
    }

    public boolean keyPressed(GuiBase gui, int key, char keyChar) {
        return false;
    }
}

